/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ByteBuffer;

public class HexString {
    static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String hexifyByte(int val) {
        return "" + hexchar[val >>> 4 & 0xF] + hexchar[val & 0xF];
    }

    public static String hexifyByte(byte val) {
        return HexString.hexifyByte(val & 0xFF);
    }

    public static String hexifyShort(int val) {
        return HexString.hexifyByte(val >>> 8 & 0xFF) + HexString.hexifyByte(val & 0xFF);
    }

    public static String hexifyInt(int val) {
        return HexString.hexifyShort(val >> 16 & 0xFFFF) + HexString.hexifyShort(val & 0xFFFF);
    }

    public static String hexifyByteArray(byte[] buffer, char delimiter, int offset, int length) {
        if (offset + length > buffer.length) {
            length = buffer.length - offset;
        }
        StringBuffer sb = new StringBuffer((length << 1) + (delimiter == '\u0000' ? 0 : length));
        int i = 0;
        while (i < length) {
            sb.append(hexchar[buffer[offset] >>> 4 & 0xF]);
            sb.append(hexchar[buffer[offset] & 0xF]);
            if (delimiter != '\u0000' && i < length - 1) {
                sb.append(delimiter);
            }
            ++i;
            ++offset;
        }
        return sb.toString();
    }

    public static String hexifyByteArray(byte[] buffer, char delimiter, int length) {
        return HexString.hexifyByteArray(buffer, delimiter, 0, buffer.length);
    }

    public static String hexifyByteArray(byte[] buffer, char delimiter) {
        return HexString.hexifyByteArray(buffer, delimiter, 0, buffer.length);
    }

    public static String hexifyByteArray(byte[] buffer) {
        return HexString.hexifyByteArray(buffer, '\u0000', 0, buffer.length);
    }

    public static String dump(byte[] data, int offset, int length, int widths, int indent) {
        StringBuffer buffer = new StringBuffer(80);
        if (data == null || widths == 0 || length < 0 || indent < 0) {
            throw new IllegalArgumentException();
        }
        while (length > 0) {
            int i;
            for (i = 0; i < indent; ++i) {
                buffer.append(' ');
            }
            buffer.append(HexString.hexifyShort(offset));
            buffer.append("  ");
            int ofs = offset;
            int len = widths < length ? widths : length;
            i = 0;
            while (i < len) {
                buffer.append(hexchar[data[ofs] >>> 4 & 0xF]);
                buffer.append(hexchar[data[ofs] & 0xF]);
                buffer.append(' ');
                ++i;
                ++ofs;
            }
            while (i < widths) {
                buffer.append("   ");
                ++i;
            }
            buffer.append(' ');
            ofs = offset;
            i = 0;
            while (i < len) {
                char ch = (char)(data[ofs] & 0xFF);
                if (ch < ' ' || ch >= '\u007f') {
                    ch = '.';
                }
                buffer.append(ch);
                ++i;
                ++ofs;
            }
            buffer.append('\n');
            offset += len;
            length -= len;
        }
        return buffer.toString();
    }

    public static String dump(byte[] data, int offset, int length, int widths) {
        return HexString.dump(data, offset, length, widths, 0);
    }

    public static String dump(byte[] data, int offset, int length) {
        return HexString.dump(data, offset, length, 16, 0);
    }

    public static String dump(byte[] data) {
        return HexString.dump(data, 0, data.length, 16, 0);
    }

    public static byte[] parseHexString(String str) {
        ByteBuffer b = new ByteBuffer(str.length() / 2);
        int i = 0;
        int size = str.length();
        if (str.startsWith("0x")) {
            i += 2;
            size -= 2;
        }
        while (size > 0) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                ++i;
                --size;
            }
            if (size < 2) {
                throw new NumberFormatException("Odd number of hexadecimal digits");
            }
            String toParse = str.substring(i, i + 2);
            b.append((byte)Integer.parseInt(toParse, 16));
            i += 2;
            size -= 2;
        }
        return b.getBytes();
    }
}

