/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeySet;
import de.cardcontact.opencard.security.GPSCP02SecureChannel;
import de.cardcontact.opencard.security.GPSCPAuthenticator;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;

public class GPSCP02Authenticator
extends GPSCPAuthenticator {
    private static final byte[] EIGHT_BYTES_PADDING_BLOCK = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] defaultICV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private Cipher desCipher;
    private Mac desMac;
    private Mac desRetailMac;

    public GPSCP02Authenticator(byte[] hostChallenge) {
        super(hostChallenge);
        try {
            this.desCipher = Cipher.getInstance("DESede/CBC/NoPadding");
            this.desMac = Mac.getInstance("DESEDEMAC64");
            this.desRetailMac = Mac.getInstance("ISO9797ALG3Mac");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create cipher instance", e);
        }
    }

    @Override
    public void processInitializeUpdateResponse(byte[] rsp) throws OpenCardException {
        if (rsp.length != 28) {
            throw new CardServiceException("INITIALIZE UPDATE failed - wrong length of response data (" + rsp.length + ")");
        }
        this.keyDiversificationData = new byte[10];
        System.arraycopy(rsp, 0, this.keyDiversificationData, 0, this.keyDiversificationData.length);
        this.keyInformation = new byte[2];
        System.arraycopy(rsp, 10, this.keyInformation, 0, this.keyInformation.length);
        this.sequenceCounter = new byte[2];
        System.arraycopy(rsp, 12, this.sequenceCounter, 0, this.sequenceCounter.length);
        this.cardChallenge = new byte[6];
        System.arraycopy(rsp, 14, this.cardChallenge, 0, this.cardChallenge.length);
        this.cardCryptogram = new byte[8];
        System.arraycopy(rsp, 20, this.cardCryptogram, 0, this.cardCryptogram.length);
    }

    @Override
    public void deriveSessionKeys(GPKeySet keys) {
        IvParameterSpec dps = new IvParameterSpec(defaultICV);
        byte[] derivationParam = new byte[16];
        derivationParam[0] = 1;
        derivationParam[2] = this.sequenceCounter[0];
        derivationParam[3] = this.sequenceCounter[1];
        try {
            derivationParam[1] = -126;
            this.desCipher.init(1, (Key)keys.getEncKey(), dps);
            byte[] res = this.desCipher.doFinal(derivationParam);
            SecretKeySpec sessionEnc = new SecretKeySpec(res, "DESede");
            derivationParam[1] = 1;
            this.desCipher.init(1, (Key)keys.getMacKey(), dps);
            res = this.desCipher.doFinal(derivationParam);
            SecretKeySpec sessionMac = new SecretKeySpec(res, "DESede");
            derivationParam[1] = -127;
            this.desCipher.init(1, (Key)keys.getDekKey(), dps);
            res = this.desCipher.doFinal(derivationParam);
            SecretKeySpec sessionDek = new SecretKeySpec(res, "DESede");
            this.sessionKeys = new GPKeySet(sessionEnc, sessionMac, sessionDek);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to derive session keys", e);
        }
    }

    @Override
    public boolean isCardCryptogramValid() {
        byte[] mac;
        byte[] macInput = new byte[24];
        System.arraycopy(this.hostChallenge, 0, macInput, 0, 8);
        System.arraycopy(this.sequenceCounter, 0, macInput, 8, 2);
        System.arraycopy(this.cardChallenge, 0, macInput, 10, 6);
        System.arraycopy(EIGHT_BYTES_PADDING_BLOCK, 0, macInput, 16, 8);
        try {
            this.desMac.init(this.sessionKeys.getEncKey(), new IvParameterSpec(defaultICV));
            mac = this.desMac.doFinal(macInput);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate MAC", e);
        }
        return Arrays.compare(this.cardCryptogram, mac) == 0;
    }

    @Override
    public byte[] calculateHostCryptogram(byte securityLevel) {
        byte[] mac;
        byte[] hostCryptogram;
        byte[] macInput = new byte[24];
        System.arraycopy(this.sequenceCounter, 0, macInput, 0, 2);
        System.arraycopy(this.cardChallenge, 0, macInput, 2, 6);
        System.arraycopy(this.hostChallenge, 0, macInput, 8, 8);
        System.arraycopy(EIGHT_BYTES_PADDING_BLOCK, 0, macInput, 16, 8);
        try {
            this.desMac.init(this.sessionKeys.getEncKey(), new IvParameterSpec(defaultICV));
            hostCryptogram = this.desMac.doFinal(macInput);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate MAC", e);
        }
        byte[] apdu = new byte[16];
        apdu[0] = -124;
        apdu[1] = -126;
        apdu[2] = securityLevel;
        apdu[3] = 0;
        apdu[4] = 16;
        System.arraycopy(hostCryptogram, 0, apdu, 5, 8);
        apdu[13] = -128;
        try {
            this.desRetailMac.init(this.sessionKeys.getMacKey(), new IvParameterSpec(defaultICV));
            mac = this.desRetailMac.doFinal(apdu);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate MAC", e);
        }
        System.arraycopy(hostCryptogram, 0, apdu, 0, 8);
        System.arraycopy(mac, 0, apdu, 8, 8);
        this.secureChannel = new GPSCP02SecureChannel(this.sessionKeys.getEncKey(), this.sessionKeys.getMacKey(), this.sessionKeys.getDekKey(), mac, securityLevel, "BC");
        return apdu;
    }
}

