/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.KeyDomainUIDExtension;
import de.cardcontact.opencard.eac.cvc.SecurityClassification;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class Extension
extends ConstructedTLV {
    static final Tag TAG = new Tag(19, 64, true);
    static final String NAME = "Extension";

    public Extension(ObjectIdentifier oid) {
        super(TAG);
        this.setName(NAME);
        this.add(oid);
    }

    public Extension(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Extension with wrong tag " + tlv.getTag());
        }
        this.setName(NAME);
        if (this.childs.size() < 2) {
            throw new TLVEncodingException("Extension must contain at least 2 elements");
        }
        if (!(this.childs.get(0) instanceof ObjectIdentifier)) {
            throw new TLVEncodingException("Extension must start with Object Identifier");
        }
    }

    public static Extension newExtension(TLV tlv) throws TLVEncodingException {
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Extension with wrong tag " + tlv.getTag());
        }
        ConstructedTLV ctlv = (ConstructedTLV)tlv;
        if (ctlv.getChildCount() < 1) {
            throw new TLVEncodingException("Extension must contain at least 1 element");
        }
        if (!(ctlv.getChildAt(0) instanceof ObjectIdentifier)) {
            throw new TLVEncodingException("Extension must start with Object Identifier");
        }
        ObjectIdentifier oid = (ObjectIdentifier)ctlv.getChildAt(0);
        if (oid.equals(KeyDomainUIDExtension.id_key_domain_uid)) {
            return new KeyDomainUIDExtension(tlv);
        }
        if (oid.equals(SecurityClassification.id_security_classification)) {
            return new SecurityClassification(tlv);
        }
        return new Extension(tlv);
    }
}

