/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.pkcs15.CommonDataContainerObjectAttributes;
import de.cardcontact.opencard.pkcs15.CommonObjectAttributes;
import de.cardcontact.opencard.pkcs15.DataContainerObject;
import de.cardcontact.opencard.pkcs15.Path;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStore {
    static final Logger logger = LoggerFactory.getLogger(DataStore.class);
    private SmartCardHSMCardService service;
    private BitSet descriptorMap = new BitSet(256);
    private BitSet publicDOMap = new BitSet(256);
    private BitSet privateDOMap = new BitSet(256);
    private Map<String, CardFilePath[]> fidMap = new HashMap<String, CardFilePath[]>();

    public DataStore(SmartCardHSMCardService service) {
        this.service = service;
    }

    public void addAll(byte[] fobs) throws OpenCardException {
        for (int i = 0; i < fobs.length; i += 2) {
            if (fobs[i] == -55) {
                byte id = fobs[i + 1];
                this.descriptorMap.set(id & 0xFF);
                CardFilePath file = new CardFilePath(new byte[]{-55, id});
                byte[] desc = this.service.read(file, 0, -1);
                try {
                    TLV tlv = TLV.factory(desc);
                    DataContainerObject dco = new DataContainerObject(tlv);
                    String label = dco.getCommonObjectAttributes().getLabel();
                    byte[] path = dco.getPath().getEFIDorPath();
                    CardFilePath cfp = new CardFilePath(path);
                    this.fidMap.put(label, new CardFilePath[]{file, cfp});
                }
                catch (TLVEncodingException e) {
                    logger.error("Error parsing certificate description", (Throwable)e);
                }
            }
            if (fobs[i] == -49) {
                this.publicDOMap.set(fobs[i + 1] & 0xFF);
            }
            if (fobs[i] != -51) continue;
            this.privateDOMap.set(fobs[i + 1] & 0xFF);
        }
    }

    public String[] getLabels() {
        return this.fidMap.keySet().toArray(new String[this.fidMap.size()]);
    }

    public CardFilePath getCardFilePath(String label) {
        CardFilePath[] cfp = this.fidMap.get(label);
        if (cfp == null) {
            return null;
        }
        return cfp[1];
    }

    public byte[] getDataObject(String label) throws OpenCardException {
        CardFilePath cfp = this.getCardFilePath(label);
        if (cfp == null) {
            return null;
        }
        return this.service.read(cfp, 0, -1);
    }

    public void addDataObject(String label, boolean privObj, boolean modifiable, byte[] data) throws OpenCardException {
        byte prefixData;
        int idData;
        if (this.fidMap.containsKey(label)) {
            throw new CardServiceException("A data object with label " + label + " does already exist");
        }
        if (privObj) {
            idData = this.privateDOMap.nextClearBit(0);
            prefixData = -51;
        } else {
            idData = this.publicDOMap.nextClearBit(0);
            prefixData = -49;
        }
        if (idData < 0) {
            throw new CardServiceException("Out of memory for private data objects");
        }
        int idDesc = this.descriptorMap.nextClearBit(0);
        if (idDesc < 0) {
            throw new CardServiceException("Out of memory for data object descriptors");
        }
        byte[] fid = new byte[]{prefixData, (byte)idData};
        DataContainerObject dco = new DataContainerObject(new CommonObjectAttributes(label, privObj, modifiable, null), new CommonDataContainerObjectAttributes("Java"), new Path(fid));
        CardFilePath desccfp = new CardFilePath(new byte[]{-55, (byte)idDesc});
        CardFilePath datacfp = new CardFilePath(fid);
        this.service.write(datacfp, 0, data);
        this.service.write(desccfp, 0, dco.getBytes());
        this.fidMap.put(label, new CardFilePath[]{desccfp, datacfp});
        this.descriptorMap.set(idDesc);
        if (privObj) {
            this.privateDOMap.set(idData);
        } else {
            this.publicDOMap.set(idData);
        }
    }

    public void deleteDataObject(String label) throws OpenCardException {
        CardFilePath[] cfp = this.fidMap.get(label);
        if (cfp == null) {
            throw new CardServiceException("Data object with label " + label + " not found");
        }
        this.service.delete(cfp[0]);
        this.service.delete(cfp[1]);
        this.fidMap.remove(label);
        byte[] fid = ((CardFileFileID)cfp[0].tail()).toByteArray();
        this.descriptorMap.clear(fid[1] & 0xFF);
        fid = ((CardFileFileID)cfp[1].tail()).toByteArray();
        if (fid[0] == -51) {
            this.privateDOMap.clear(fid[1] & 0xFF);
        } else if (fid[0] == -49) {
            this.publicDOMap.clear(fid[1] & 0xFF);
        }
    }
}

