/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.globalplatform;

import de.cardcontact.opencard.security.GPKeyProvider;
import de.cardcontact.opencard.security.GPKeyProviderDefault;
import de.cardcontact.opencard.security.GPKeySet;
import de.cardcontact.opencard.security.GPSCP02Authenticator;
import de.cardcontact.opencard.security.GPSCP02SecureChannel;
import de.cardcontact.opencard.security.GPSCP03Authenticator;
import de.cardcontact.opencard.security.GPSCP03SecureChannel;
import de.cardcontact.opencard.security.GPSCPAuthenticator;
import de.cardcontact.opencard.security.GPSecureChannel;
import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.globalplatform.apdu.ExternalAuthenticateCommandAPDU;
import de.cardcontact.opencard.service.globalplatform.apdu.InitializeUpdateCommandAPDU;
import de.cardcontact.opencard.service.globalplatform.apdu.PutKeyCommandAPDU;
import de.cardcontact.opencard.utils.CapFile;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.opt.applet.AppletID;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDomainCardService
extends CardService
implements SecureService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityDomainCardService.class);
    public static final AppletID ISD_AID = new AppletID("A000000151000000");
    private AppletID aid = ISD_AID;
    private GPSecureChannel secureChannel;
    private byte level = 0;

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        logger.debug("[initialize] called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU select(AppletID id, boolean next) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(64);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-92);
            com.append((byte)4);
            com.append(next ? (byte)2 : 0);
            if (id != null) {
                byte[] aid = id.getBytes();
                com.append((byte)aid.length);
                com.append(aid);
                this.aid = id;
            } else {
                this.aid = ISD_AID;
            }
            com.append((byte)0);
            res = channel.sendCommandAPDU(com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU installForInstall(byte[] loadFileAID, byte[] execModAID, byte[] appInsAID, byte[] privileges, byte[] installParam, byte[] installToken, boolean makeSelectable) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-26);
            com.append((byte)(4 | (makeSelectable ? 8 : 0)));
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)loadFileAID.length);
            com.append(loadFileAID);
            com.append((byte)execModAID.length);
            com.append(execModAID);
            com.append((byte)appInsAID.length);
            com.append(appInsAID);
            com.append((byte)privileges.length);
            com.append(privileges);
            com.append((byte)installParam.length);
            com.append(installParam);
            if (installToken != null) {
                com.append((byte)installToken.length);
                com.append(installToken);
            } else {
                com.append((byte)0);
            }
            com.setByte(4, com.getLength() - 5);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    public ResponseAPDU installForInstallAndSelectable(byte[] loadFileAID, byte[] execModAID, byte[] appInsAID, byte[] privileges, byte[] installParam, byte[] installToken) throws CardTerminalException {
        return this.installForInstall(loadFileAID, execModAID, appInsAID, privileges, installParam, installToken, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU installForLoad(byte[] loadFileAID, byte[] secDomAID, byte[] loadDBHash, byte[] loadParam, byte[] loadToken) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-26);
            com.append((byte)2);
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)loadFileAID.length);
            com.append(loadFileAID);
            if (secDomAID != null) {
                com.append((byte)secDomAID.length);
                com.append(secDomAID);
            } else {
                com.append((byte)0);
            }
            if (loadDBHash != null) {
                com.append((byte)loadDBHash.length);
                com.append(loadDBHash);
            } else {
                com.append((byte)0);
            }
            if (loadParam != null) {
                com.append((byte)loadParam.length);
                com.append(loadParam);
            } else {
                com.append((byte)0);
            }
            if (loadToken != null) {
                com.append((byte)loadToken.length);
                com.append(loadToken);
            } else {
                com.append((byte)0);
            }
            com.setByte(4, com.getLength() - 5);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU load(CapFile capFile) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        byte[] loadFile = capFile.getLoadFile(CapFile.CAPSEQUENCE);
        int length = loadFile.length;
        int offset = 0;
        int count = 0;
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            while (length > 0) {
                int block = length;
                if (block > 230) {
                    block = 230;
                }
                com.setQueueable((length -= block) > 0);
                com.setLength(0);
                com.append((byte)-128);
                com.append((byte)-24);
                com.append((byte)(com.isQueueable() ? 0 : 128));
                com.append((byte)count);
                com.append((byte)block);
                System.arraycopy(loadFile, offset, com.getBuffer(), 5, block);
                com.setLength(block + 5);
                com.append((byte)0);
                res = this.sendCommandAPDU(channel, com);
                if (res.sw() != 36864) {
                    break;
                }
                ++count;
                offset += block;
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU deleteAID(byte[] aid) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-28);
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)(aid.length + 2));
            com.append((byte)79);
            com.append((byte)aid.length);
            com.append(aid);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, CommandAPDU com) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU res;
        if (this.secureChannel != null) {
            SlotChannel slc = channel.getSlotChannel();
            APDUTracer tracer = slc.getAPDUTracer();
            if (tracer != null && com.getLength() > 5) {
                tracer.traceCommandAPDU(slc, com);
            }
            com = this.secureChannel.wrap(com, this.level);
            res = channel.sendCommandAPDU(com);
            res = this.secureChannel.unwrap(res, this.level);
            if (tracer != null && res.getLength() > 2) {
                tracer.traceResponseAPDU(slc, res);
            }
        } else {
            res = channel.sendCommandAPDU(com);
        }
        return res;
    }

    public int determineSCP() throws InvalidCardChannelException, CardTerminalException, CardServiceException {
        int scp;
        block9: {
            CommandAPDU com = new CommandAPDU(50);
            ResponseAPDU res = new ResponseAPDU(258);
            scp = 2;
            try {
                this.allocateCardChannel();
                CardChannel channel = this.getCardChannel();
                com.append((byte)-128);
                com.append((byte)-54);
                com.append((byte)0);
                com.append((byte)102);
                com.append((byte)0);
                res = channel.sendCommandAPDU(com);
                if (res.sw() != 36864) break block9;
                TLV cardData = TLV.factory(res.data());
                TLV cardRecoginitionData = (TLV)cardData.getChildAt(0);
                TLV secureChannelInfo = (TLV)cardRecoginitionData.getChildAt(3);
                byte[] v = secureChannelInfo.getValue();
                scp = v[v.length - 2];
                byte i = v[v.length - 1];
                if (scp == 2) {
                    if (!GPSCP02SecureChannel.scpOptionsSupported(i)) {
                        throw new CardServiceException("SCP02 " + scp + " with option " + i + " is not suppported");
                    }
                    break block9;
                }
                if (scp == 3) {
                    if (!GPSCP03SecureChannel.scpOptionsSupported(i)) {
                        throw new CardServiceException("SCP03 " + scp + " with option " + i + " is not suppported");
                    }
                    break block9;
                }
                throw new CardServiceException("SCP " + scp + " is not suppported");
            }
            catch (TLVEncodingException e) {
                throw new CardServiceException("Invalid encoding of card recognition data : " + e.getLocalizedMessage());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return scp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU initializeUpdate(byte keyVersionNumber, byte keyIndex, byte[] hostChallenge) throws InvalidCardChannelException, CardTerminalException, CardServiceException {
        ResponseAPDU res;
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            res = channel.sendCommandAPDU(new InitializeUpdateCommandAPDU(keyVersionNumber, hostChallenge));
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU externalAuthenticate(byte level, byte[] data) throws InvalidCardChannelException, CardTerminalException, CardServiceException {
        ResponseAPDU res;
        if (data.length != 16) {
            throw new CardServiceException("Wrong length of input data. Must be 16 bytes.");
        }
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            res = channel.sendCommandAPDU(new ExternalAuthenticateCommandAPDU(level, data));
        }
        finally {
            this.releaseCardChannel();
        }
        if (res.sw() == 36864) {
            this.level = level;
        }
        return res;
    }

    public void authenticate(GPKeySet keys, byte level) throws OpenCardException {
        GPKeyProviderDefault gpkp = new GPKeyProviderDefault();
        byte scp = keys.getEncKey().getAlgorithm() == "AES" ? (byte)3 : 2;
        gpkp.addKey(scp, keys);
        this.authenticate(gpkp, level);
    }

    public GPSCPAuthenticator authenticate(GPKeyProvider prov, byte level) throws OpenCardException {
        GPSCPAuthenticator gpa;
        SecureRandom sr = new SecureRandom();
        byte[] challenge = new byte[8];
        sr.nextBytes(challenge);
        ResponseAPDU rsp = this.initializeUpdate((byte)0, (byte)0, challenge);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("INITIALIZE UPDATE failed", rsp.sw());
        }
        byte scp = (byte)rsp.getByte(11);
        if (scp == 2) {
            gpa = new GPSCP02Authenticator(challenge);
        } else if (scp == 3) {
            gpa = new GPSCP03Authenticator(challenge);
        } else {
            throw new CardServiceException("Unknown SCP number protocol number " + rsp.getByte(11));
        }
        gpa.processInitializeUpdateResponse(rsp.data());
        GPKeySet keys = prov.getGPKeys(scp, gpa.getKeyVersion(), gpa.getKeyDiversificationData());
        gpa.deriveSessionKeys(keys);
        if (!gpa.isCardCryptogramValid()) {
            throw new CardServiceException("Card cryptogram verification failed");
        }
        byte[] cdata = gpa.calculateHostCryptogram(level);
        rsp = this.externalAuthenticate(level, cdata);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("INITIALIZE UPDATE failed", rsp.sw());
        }
        this.secureChannel = gpa.getSecureChannel();
        return gpa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putKey(byte replaceVersion, GPKeySet keys) throws OpenCardException {
        ResponseAPDU rsp;
        ByteBuffer bb = ByteBuffer.allocate(150);
        bb.put(keys.getVersion());
        byte[] cryptogram = this.secureChannel.encryptKey(keys.getEncKey());
        bb.put(cryptogram);
        cryptogram = this.secureChannel.encryptKey(keys.getMacKey());
        bb.put(cryptogram);
        cryptogram = this.secureChannel.encryptKey(keys.getDekKey());
        bb.put(cryptogram);
        bb.flip();
        byte[] cdata = new byte[bb.remaining()];
        bb.get(cdata);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            rsp = this.sendCommandAPDU(channel, new PutKeyCommandAPDU(replaceVersion, -127, cdata));
        }
        finally {
            this.releaseCardChannel();
        }
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("PUT KEY failed", rsp.sw());
        }
    }

    @Override
    public void provideCredentials(SecurityDomain domain, CredentialBag creds) throws CardServiceException {
        IsoCredentialStore credentialStore = (IsoCredentialStore)creds.getCredentialStore(null, IsoCredentialStore.class);
        SecureChannelCredential secureChannelCredential = credentialStore.getSecureChannelCredential(this.aid);
        this.secureChannel = (GPSecureChannel)secureChannelCredential.getSecureChannel();
    }
}

