/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service;

import de.cardcontact.tlv.HexString;
import java.util.Arrays;

public class KeyId {
    private byte[] keyId;
    private int hashCode;

    public KeyId(byte[] kid) {
        this.keyId = kid;
        this.hashCode = 0;
        for (int i = 0; i < 4 && i < kid.length; ++i) {
            this.hashCode = this.hashCode << 8 | kid[i] & 0xFF;
        }
    }

    public byte[] getId() {
        return this.keyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof KeyId)) {
            return false;
        }
        KeyId ki = (KeyId)o;
        return Arrays.equals(this.keyId, ki.keyId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString(int digits) {
        if (digits > this.keyId.length) {
            digits = this.keyId.length;
        }
        return HexString.hexifyByteArray(this.keyId, '\u0000', digits);
    }

    public String toString() {
        return HexString.hexifyByteArray(this.keyId);
    }
}

