/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.pkcs8;

import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.EllipticCurve;

public class Curve
extends Sequence {
    static final String NAME = "Curve";

    public Curve(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("Curve must contain 2 elements");
        }
        if (!(this.childs.get(0) instanceof OctetString)) {
            throw new TLVEncodingException("Field element must be OCTET-STRING");
        }
        if (!(this.childs.get(1) instanceof OctetString)) {
            throw new TLVEncodingException("Field element must be OCTET-STRING");
        }
    }

    public EllipticCurve getCurve(ECField field) {
        EllipticCurve curve = new EllipticCurve(field, new BigInteger(1, ((TLV)this.childs.get(0)).getValue()), new BigInteger(1, ((TLV)this.childs.get(1)).getValue()));
        return curve;
    }
}

