/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.smartcardio;

import de.cardcontact.opencard.terminal.smartcardio.PCSCIOControl;
import de.cardcontact.opencard.utils.Util;
import java.util.Arrays;
import java.util.Properties;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.ResponseAPDU;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ExtendedVerifiedAPDUInterface;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.SlotChannel;
import opencard.opt.terminal.TerminalCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardIOTerminal
extends opencard.core.terminal.CardTerminal
implements TerminalCommand,
Pollable,
ExtendedVerifiedAPDUInterface {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardIOTerminal.class);
    private boolean polling;
    private CardTerminal ct;
    private Card card = null;
    private boolean closed;
    private boolean cardInserted;

    public SmartCardIOTerminal(String name, String type, String address, CardTerminal ct) throws CardTerminalException {
        super(name, type, address);
        this.polling = !type.endsWith("-NOPOLL");
        this.ct = ct;
        this.card = null;
        this.addSlots(1);
    }

    @Override
    protected Properties internalFeatures(Properties features) {
        if (this.name.startsWith("Secure Flash Card")) {
            features.put("maxCAPDUSize", "478");
            features.put("maxRAPDUSize", "506");
        } else if (this.name.startsWith("REINER SCT cyberJack")) {
            features.put("maxCAPDUSize", "1014");
            features.put("maxRAPDUSize", "1014");
        } else if (this.name.startsWith("ACS APG8201")) {
            features.put("maxCAPDUSize", "1141");
            features.put("maxRAPDUSize", "1141");
        } else if (this.name.startsWith("Gemalto IDBridge")) {
            features.put("maxCAPDUSize", "262");
            features.put("maxRAPDUSize", "499");
        }
        return features;
    }

    @Override
    public void open() throws CardTerminalException {
        if (this.polling) {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
        this.closed = false;
        this.cardInserted = this.isCardPresent(0);
    }

    @Override
    public void close() throws CardTerminalException {
        try {
            this.disconnect(false);
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        this.cardRemoved(0);
        if (this.polling) {
            CardTerminalRegistry.getRegistry().removePollable(this);
        }
        this.closed = true;
    }

    @Override
    public CardID getCardID(int slotID) throws CardTerminalException {
        if (!this.isCardPresent(slotID)) {
            logger.debug("[getCardID] no card in reader");
            return null;
        }
        this.connect();
        CardID cardid = new CardID(this, slotID, this.card.getATR().getBytes());
        logger.debug("[getCardID] CardID: " + cardid);
        return cardid;
    }

    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        this.disconnect(true);
        return this.getCardID(slot);
    }

    @Override
    protected CardID internalReset(int slot, boolean warm) throws CardTerminalException {
        this.disconnect(true);
        return this.getCardID(slot);
    }

    @Override
    protected opencard.core.terminal.ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        ResponseAPDU xrapdu;
        this.connect();
        byte[] apdu = capdu.getBytes();
        javax.smartcardio.CommandAPDU xcapdu = new javax.smartcardio.CommandAPDU(apdu);
        Arrays.fill(apdu, (byte)0);
        capdu.clear();
        CardChannel ch = this.card.getBasicChannel();
        try {
            xrapdu = ch.transmit(xcapdu);
        }
        catch (CardException ce) {
            logger.error("[internalSendAPDU]" + ce);
            this.card = null;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isCardPresent(slot)) {
                throw new CardTerminalException("CardException in transmit(): " + ce.getMessage());
            }
            throw new CardNotPresentException("Card removed", (opencard.core.terminal.CardTerminal)this, slot);
        }
        return new opencard.core.terminal.ResponseAPDU(xrapdu.getBytes());
    }

    @Override
    public boolean isCardPresent(int slotID) throws CardTerminalException {
        boolean cardPresent;
        try {
            cardPresent = this.ct.isCardPresent();
        }
        catch (CardException ce) {
            logger.error("[isCardPresent]" + ce);
            return false;
        }
        if (!cardPresent) {
            this.card = null;
        }
        return cardPresent;
    }

    @Override
    public byte[] sendTerminalCommand(byte[] cmd) throws CardTerminalException {
        int i;
        int c = 0;
        for (i = 0; i < cmd.length && i < 4; ++i) {
            c <<= 8;
            c |= cmd[i] & 0xFF;
        }
        byte[] cmddata = new byte[cmd.length - i];
        System.arraycopy(cmd, i, cmddata, 0, cmd.length - i);
        byte[] resdata = null;
        try {
            resdata = this.card.transmitControlCommand(c, cmddata);
        }
        catch (CardException ce) {
            logger.error("[sendTerminalCommand]" + ce);
            throw new CardTerminalException("CardException in sendTerminalCommand(): " + ce.getMessage());
        }
        return resdata;
    }

    @Override
    public void poll() throws CardTerminalException {
        if (!this.closed && this.polling) {
            try {
                boolean newStatus = this.isCardPresent(0);
                if (this.cardInserted != newStatus) {
                    logger.debug("[poll] status change");
                    boolean bl = this.cardInserted = !this.cardInserted;
                    if (this.cardInserted) {
                        this.cardInserted(0);
                    } else {
                        this.cardRemoved(0);
                    }
                }
            }
            catch (CardTerminalException cte) {
                logger.debug("[poll]" + cte);
                this.cardInserted(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws CardTerminalException {
        if (this.card != null) {
            return;
        }
        boolean oldpolling = this.polling;
        try {
            this.polling = false;
            this.card = this.ct.connect("T=1");
        }
        catch (CardException ce) {
            logger.debug("[connect] second connect due to" + ce);
            try {
                this.card = this.ct.connect("*");
            }
            catch (CardException nce) {
                logger.error("[connect] final connect failed" + nce);
                throw new CardTerminalException("Error connecting to card: " + nce.getMessage());
            }
        }
        finally {
            this.polling = oldpolling;
        }
        logger.debug("[connect]" + this.card.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disconnect(boolean reset) throws CardTerminalException {
        if (this.card == null) return;
        try {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.7")) {
                this.card.disconnect(!reset);
            } else {
                this.card.disconnect(reset);
            }
            boolean oldpolling = this.polling;
            try {
                this.polling = false;
                Thread.sleep(500L);
                this.polling = oldpolling;
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.polling = oldpolling;
            }
        }
        catch (CardException ce) {
            logger.error("[disconnect]" + ce);
            throw new CardTerminalException("Error disconnecting from card: " + ce.getMessage());
        }
        finally {
            this.card = null;
        }
    }

    public opencard.core.terminal.ResponseAPDU sendModifyPINCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc) throws CardTerminalException {
        PCSCIOControl pcscio = new PCSCIOControl(this.card);
        javax.smartcardio.CommandAPDU xcapdu = new javax.smartcardio.CommandAPDU(capdu.getBytes());
        pcscio.setPinEncoding(vc.passwordEncoding());
        byte pinSize = (byte)vc.ioControl().maxInputChars();
        pcscio.setMaxPINSize(pinSize);
        pcscio.setMinPINSize((byte)1);
        byte timeOut = (byte)vc.ioControl().timeout();
        pcscio.setTimeOut(timeOut);
        pcscio.setTimeOut2(timeOut);
        if (xcapdu.getNc() > 8) {
            pcscio.setConfirmPIN((byte)3);
            pcscio.setInsertionOffsetNew((byte)8);
            pcscio.setNumberMessage((byte)3);
        } else {
            pcscio.setConfirmPIN((byte)1);
            pcscio.setInsertionOffsetNew((byte)0);
            pcscio.setNumberMessage((byte)2);
        }
        if (pcscio.hasModifyPinDirect()) {
            logger.debug("[sendVerifiedCommandAPDU] Class 3 card terminal found.");
            try {
                byte[] rsp = pcscio.modifyPINDirect(xcapdu);
                return new opencard.core.terminal.ResponseAPDU(rsp);
            }
            catch (CardException e) {
                throw new CardTerminalException("Error modifying PIN with class 3 reader: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public opencard.core.terminal.ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc) throws CardTerminalException {
        opencard.core.terminal.ResponseAPDU rapdu;
        logger.debug("[sendVerifiedCommandAPDU] PIN entry on card terminal");
        PCSCIOControl pcscio = new PCSCIOControl(this.card);
        try {
            String encoding = vc.passwordEncoding();
            if (encoding.equals("PACE")) {
                byte[] rsp = pcscio.establishPACEChannel(vc.chvNumber(), null, null, null);
                int result = (int)Util.extractLongFromByteArray(rsp, 0, 4);
                rapdu = new opencard.core.terminal.ResponseAPDU(rsp.length + 2);
                rapdu.append(rsp);
                switch (result) {
                    case 0: {
                        rapdu.append((byte)-112);
                        rapdu.append((byte)0);
                        break;
                    }
                    default: {
                        if ((result & 0xFFF00000) == -268435456) {
                            rapdu.append((byte)(result >> 8));
                            rapdu.append((byte)(result & 0xFF));
                            break;
                        }
                        rapdu.append((byte)111);
                        rapdu.append((byte)0);
                        break;
                    }
                }
            } else {
                javax.smartcardio.CommandAPDU xcapdu = new javax.smartcardio.CommandAPDU(capdu.getBytes());
                pcscio.setPinEncoding(vc.passwordEncoding());
                byte pinSize = (byte)vc.ioControl().maxInputChars();
                pcscio.setMaxPINSize(pinSize);
                pcscio.setMinPINSize((byte)1);
                byte timeOut = (byte)vc.ioControl().timeout();
                pcscio.setTimeOut(timeOut);
                pcscio.setTimeOut2(timeOut);
                byte[] rsp = pcscio.verifyPINDirect(xcapdu);
                rapdu = new opencard.core.terminal.ResponseAPDU(rsp);
            }
        }
        catch (CardException e) {
            throw new CardTerminalException("Error verifying PIN with class 3 reader: " + e.getMessage());
        }
        return rapdu;
    }

    @Override
    public boolean hasSendVerifiedCommandAPDU() {
        PCSCIOControl pcscio = new PCSCIOControl(this.card);
        return pcscio.hasVerifyPinDirect();
    }
}

