/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import opencard.core.terminal.CommandAPDU;

public class IsoCommandAPDU
extends CommandAPDU {
    public IsoCommandAPDU(byte cla, byte ins, byte p1, byte p2) {
        this(cla, ins, p1, p2, null, -1);
    }

    public IsoCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] cdata) {
        this(cla, ins, p1, p2, cdata, 0);
    }

    public IsoCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] cdata, int Ne) {
        super(9 + (cdata != null ? cdata.length : 0));
        this.apdu_buffer[0] = cla;
        this.apdu_buffer[1] = ins;
        this.apdu_buffer[2] = p1;
        this.apdu_buffer[3] = p2;
        this.apdu_length = 4;
        boolean extended = false;
        if (cdata != null) {
            if (cdata.length > 255 || Ne > 256) {
                this.apdu_buffer[this.apdu_length++] = 0;
                this.apdu_buffer[this.apdu_length++] = (byte)(cdata.length >> 8);
                extended = true;
            }
            this.apdu_buffer[this.apdu_length++] = (byte)(cdata.length & 0xFF);
            System.arraycopy(cdata, 0, this.apdu_buffer, this.apdu_length, cdata.length);
            this.apdu_length += cdata.length;
        }
        if (Ne > 0) {
            if (Ne <= 256 && !extended) {
                this.apdu_buffer[this.apdu_length++] = (byte)(Ne & 0xFF);
            } else {
                this.apdu_buffer[this.apdu_length++] = (byte)(Ne >> 8 & 0xFF);
                this.apdu_buffer[this.apdu_length++] = (byte)(Ne & 0xFF);
            }
        }
    }
}

