/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.GeneralizedTime;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.PrintableString;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.TreeNode;
import de.cardcontact.tlv.UTF8String;

public abstract class TLV
implements TreeNode {
    protected Tag tag = null;
    protected String name = null;
    protected boolean alternateLengthFormat = false;

    protected TLV() {
    }

    protected TLV(TLV p) {
        this.tag = p.tag;
        this.name = p.name;
        this.alternateLengthFormat = p.alternateLengthFormat;
    }

    protected abstract int toByteArray(byte[] var1, int var2);

    protected abstract int valueToByteArray(byte[] var1, int var2);

    public byte[] getValue() {
        byte[] buffer = new byte[this.getLength()];
        this.valueToByteArray(buffer, 0);
        return buffer;
    }

    public byte[] getBytes() {
        byte[] buffer = new byte[this.getSize()];
        this.toByteArray(buffer, 0);
        return buffer;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public abstract int getLength();

    public void useAlternateLengthEncoding() {
        this.alternateLengthFormat = true;
    }

    public int getSize() {
        int size = this.getLength();
        size += TLV.getLengthFieldSizeHelper(size, this.alternateLengthFormat);
        return size += this.tag.getSize();
    }

    public int getLengthFieldSize() {
        return TLV.getLengthFieldSizeHelper(this.getLength(), this.alternateLengthFormat);
    }

    protected static int getLengthFieldSizeHelper(int length, boolean altFormat) {
        int size = 1;
        if (!altFormat) {
            if (length >= 128) {
                ++size;
            }
            if (length >= 256) {
                ++size;
            }
            if (length >= 65536) {
                ++size;
            }
            if (length >= 0x1000000) {
                ++size;
            }
        } else if (length >= 255) {
            size = 3;
        }
        return size;
    }

    protected static int lengthToByteArray(int length, byte[] buffer, int offset, boolean altFormat) {
        int size = TLV.getLengthFieldSizeHelper(length, altFormat);
        int i = 0;
        if (!altFormat) {
            if (size > 1) {
                buffer[offset++] = (byte)(0x80 | size - 1);
                i = (size - 2) * 8;
            }
        } else if (size > 1) {
            buffer[offset++] = -1;
            i = 8;
        }
        while (i >= 0) {
            buffer[offset++] = (byte)(length >> i);
            i -= 8;
        }
        return offset;
    }

    public static byte[] getLengthFieldAsByteArray(int length, boolean altFormat) {
        byte[] v = new byte[TLV.getLengthFieldSizeHelper(length, altFormat)];
        TLV.lengthToByteArray(length, v, 0, altFormat);
        return v;
    }

    protected static int lengthFromByteArray(byte[] buffer, int offset, boolean altFormat) throws TLVEncodingException {
        int i = 1;
        if (!altFormat) {
            if ((buffer[offset] & 0x80) == 128) {
                i = buffer[offset] & 7;
                if (i > 3) {
                    throw new TLVEncodingException("Length field exceeds 24 bits. Probably not a TLV encoding.");
                }
                ++offset;
            }
        } else if (buffer[offset] == -1) {
            i = 2;
            ++offset;
        }
        int length = 0;
        while (i > 0) {
            length = length << 8 | buffer[offset++] & 0xFF;
            --i;
        }
        return length;
    }

    public static TLV factory(ParseBuffer pb) throws TLVEncodingException {
        TLV newTLV = null;
        Tag newTag = null;
        pb.mark();
        newTag = new Tag(pb);
        pb.reset();
        if (newTag.getClazz() == 0) {
            switch (newTag.getNumber()) {
                case 16: {
                    newTLV = new Sequence(pb);
                    break;
                }
                case 2: {
                    newTLV = new IntegerTLV(pb);
                    break;
                }
                case 19: {
                    newTLV = new PrintableString(pb);
                    break;
                }
                case 12: {
                    newTLV = new UTF8String(pb);
                    break;
                }
                case 4: {
                    if (newTag.isConstructed()) break;
                    newTLV = new OctetString(pb);
                    break;
                }
                case 24: {
                    newTLV = new GeneralizedTime(pb);
                    break;
                }
                case 6: {
                    newTLV = new ObjectIdentifier(pb);
                }
            }
        }
        if (newTLV == null) {
            newTLV = newTag.isConstructed() ? new ConstructedTLV(pb) : new PrimitiveTLV(pb);
        }
        return newTLV;
    }

    public static TLV factory(byte[] buffer, int offset, int length) throws TLVEncodingException {
        return TLV.factory(new ParseBuffer(buffer, offset, length));
    }

    public static TLV factory(byte[] buffer) throws TLVEncodingException {
        return TLV.factory(new ParseBuffer(buffer));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract String dump(int var1);

    protected String dumpSingleLine(int indent) {
        StringBuffer buffer = new StringBuffer(80);
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        buffer.append(this.toString());
        buffer.append('\n');
        return buffer.toString();
    }

    public String dump() {
        return this.dump(0);
    }

    public String toString() {
        if (this.name == null) {
            return this.tag.toString();
        }
        return this.name + " " + this.tag.toString();
    }
}

