/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.AuthenticatedRequest;
import de.cardcontact.opencard.eac.cvc.CVCGenerator;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPublicKey;

public class CVCertificateRequestGenerator
extends CVCGenerator {
    public CVCertificateRequestGenerator() {
    }

    public CVCertificateRequestGenerator(Provider provider) {
        this.provider = provider;
    }

    @Override
    protected CertificateBody getCertificateBody() {
        ECPublicKeyTLV pt = new ECPublicKeyTLV(this.pubAlgo, (ECPublicKey)this.pub, true);
        CertificateBody body = new CertificateBody(this.car, pt, this.chr);
        return body;
    }

    public AuthenticatedRequest authenticate(CVCertificate request, PrivateKey authenticationKey, String algo, CertificationAuthorityReference car) throws GeneralSecurityException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(request.getBytes());
            bos.write(car.getBytes());
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Failed to create signature input", e);
        }
        byte[] signature = this.sign(authenticationKey, algo, bos.toByteArray());
        return new AuthenticatedRequest(request, car, new SignatureTLV(signature));
    }
}

