/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.OpenCardRuntimeException;
import opencard.core.terminal.APDU;

public class ResponseAPDU
extends APDU {
    private boolean isQueued = false;

    public ResponseAPDU(byte[] apdu) {
        super(apdu);
        if (apdu.length < 2) {
            throw new OpenCardRuntimeException("invalid response adpu, length must be at least 2 bytes");
        }
        this.apdu_length = apdu.length;
    }

    public ResponseAPDU(int size) {
        super(size);
        if (size < 2) {
            throw new OpenCardRuntimeException("invalid response adpu, length must be at least 2 bytes");
        }
    }

    public void setQueued(boolean queued) {
        this.isQueued = queued;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    public byte[] data() {
        if (this.apdu_length > 2) {
            byte[] data = new byte[this.apdu_length - 2];
            System.arraycopy(this.apdu_buffer, 0, data, 0, this.apdu_length - 2);
            return data;
        }
        return null;
    }

    public final int sw() {
        return this.sw1() << 8 & 0xFF00 | this.sw2() & 0xFF;
    }

    public final byte sw1() {
        return this.apdu_buffer[this.apdu_length - 2];
    }

    public final byte sw2() {
        return this.apdu_buffer[this.apdu_length - 1];
    }
}

