/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.GPTLV_EMV;
import de.cardcontact.tlv.GPTLV_Generic;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.TLVDataSizeException;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.TagSizeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NativeTLVList {
    private List<GPTLV_Generic> entries = new ArrayList<GPTLV_Generic>();

    public NativeTLVList(GPTLV_Generic tlv) {
        this.entries.add(tlv);
    }

    public NativeTLVList(byte[] data) throws TLVEncodingException, TagSizeException, TLVDataSizeException {
        ParseBuffer pb = new ParseBuffer(data);
        while (pb.hasRemaining()) {
            int tag = pb.getTag();
            int length = pb.getDERLength();
            byte[] value = new byte[length];
            pb.get(value, 0, length);
            GPTLV_EMV emv = new GPTLV_EMV(tag, value);
            this.entries.add(emv);
        }
    }

    public GPTLV_Generic get(int i) {
        return this.entries.get(i);
    }

    public int getLength() {
        return this.entries.size();
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (GPTLV_Generic tlv : this.entries) {
            try {
                bos.write(tlv.getTLV());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bos.toByteArray();
    }
}

