/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service;

import opencard.core.util.HexString;

public class StatusWordTable {
    public static String StringForSW(int sw) {
        Object str = null;
        if ((sw & 0xFFF0) == 25536) {
            str = "Warning processing: Counter at " + (sw & 0xF);
        } else {
            block0 : switch (sw & 0xFF00) {
                case 36864: {
                    str = "Normal processing: No error";
                    break;
                }
                case 24832: {
                    str = "Normal processing: " + (sw & 0xFF) + " additional bytes available";
                    break;
                }
                case 27648: {
                    str = "Checking error: Invalid Le, " + (sw & 0xFF) + " bytes are available";
                    break;
                }
                case 27904: {
                    str = "Checking error: Invalid instruction (" + (sw & 0xFF) + ")";
                    break;
                }
                case 26368: {
                    str = "Checking error: Wrong length";
                    break;
                }
                default: {
                    switch (sw) {
                        case 25218: {
                            str = "Warning processing: End of file reached before reading Ne bytes ";
                            break block0;
                        }
                        case 25219: {
                            str = "Warning processing: Selected file deactivated";
                            break block0;
                        }
                        case 25344: {
                            str = "Warning processing: State of non-volatile memory changed";
                            break block0;
                        }
                        case 26624: {
                            str = "Checking error: Function in CLA byte not supported";
                            break block0;
                        }
                        case 26753: {
                            str = "Checking error: Logical channel not supported";
                            break block0;
                        }
                        case 26754: {
                            str = "Checking error: Secure Messaging not supported";
                            break block0;
                        }
                        case 26755: {
                            str = "Checking error: Last command of the chain expected";
                            break block0;
                        }
                        case 26756: {
                            str = "Checking error: Command chaining not supported";
                            break block0;
                        }
                        case 26880: {
                            str = "Checking error: Command not allowed";
                            break block0;
                        }
                        case 27009: {
                            str = "Checking error: Command incompatible with file structure";
                            break block0;
                        }
                        case 27010: {
                            str = "Checking error: Security condition not satisfied";
                            break block0;
                        }
                        case 27011: {
                            str = "Checking error: Authentication method locked";
                            break block0;
                        }
                        case 27012: {
                            str = "Checking error: Reference data not usable";
                            break block0;
                        }
                        case 27013: {
                            str = "Checking error: Condition of use not satisfied";
                            break block0;
                        }
                        case 27014: {
                            str = "Checking error: Command not allowed (no current EF)";
                            break block0;
                        }
                        case 27015: {
                            str = "Checking error: Expected secure messaging object missing";
                            break block0;
                        }
                        case 27016: {
                            str = "Checking error: Incorrect secure messaging data object";
                            break block0;
                        }
                        case 27136: {
                            str = "Checking error: Wrong parameter P1-P2";
                            break block0;
                        }
                        case 27264: {
                            str = "Checking error: Incorrect parameter in the command data field";
                            break block0;
                        }
                        case 27265: {
                            str = "Checking error: Function not supported";
                            break block0;
                        }
                        case 27266: {
                            str = "Checking error: File not found";
                            break block0;
                        }
                        case 27267: {
                            str = "Checking error: Record not found";
                            break block0;
                        }
                        case 27268: {
                            str = "Checking error: Not enough memory space in the file";
                            break block0;
                        }
                        case 27269: {
                            str = "Checking error: Nc inconsistent with TLV structure";
                            break block0;
                        }
                        case 27270: {
                            str = "Checking error: Incorrect P1-P2";
                            break block0;
                        }
                        case 27271: {
                            str = "Checking error: Lc inconsistent with P1-P2";
                            break block0;
                        }
                        case 27272: {
                            str = "Checking error: Reference data not found";
                            break block0;
                        }
                        case 27273: {
                            str = "Checking error: File already exists";
                            break block0;
                        }
                        case 27274: {
                            str = "Checking error: DF name already exists";
                            break block0;
                        }
                        case 27392: {
                            str = "Checking error: Wrong parameter P1-P2";
                            break block0;
                        }
                        case 28160: {
                            str = "Checking error: Class not supported";
                            break block0;
                        }
                        case 28416: {
                            str = "Checking error: No precise diagnosis";
                        }
                    }
                }
            }
        }
        return str;
    }

    public static String MessageForSW(int sw) {
        String str = StatusWordTable.StringForSW(sw);
        if (str == null) {
            return "SW1/SW2=" + HexString.hexifyShort((short)sw);
        }
        return "SW1/SW2=" + HexString.hexifyShort((short)sw) + " (" + str + ")";
    }
}

