/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMCardServiceFactory
extends CardServiceFactory {
    private static final byte[] SMARTCARDHSM = new byte[]{-128, 49, -127, 84, 72, 83, 77, 49, 115, -128, 33, 64, -127, 7};
    private static final Logger logger = LoggerFactory.getLogger(SmartCardHSMCardServiceFactory.class);

    @Override
    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        Vector<Class<SmartCardHSMCardService>> serviceClasses = new Vector<Class<SmartCardHSMCardService>>();
        byte[] hb = cid.getHistoricals();
        int i = 0;
        if (hb != null && SmartCardHSMCardServiceFactory.partialMatch(hb, SMARTCARDHSM)) {
            i = 2304;
            serviceClasses.addElement(SmartCardHSMCardService.class);
        }
        CardType cardType = new CardType(i);
        cardType.setInfo(serviceClasses);
        return cardType;
    }

    @Override
    protected Enumeration getClasses(CardType type) {
        logger.debug("[getClasses] card type is " + type.getType());
        Vector serviceClasses = (Vector)type.getInfo();
        return serviceClasses.elements();
    }

    private static boolean partialMatch(byte[] hb, byte[] ref) {
        int i;
        if (hb.length < ref.length) {
            return false;
        }
        for (i = 0; i < ref.length && hb[i] == ref[i]; ++i) {
        }
        return i == ref.length;
    }
}

