/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;

public class CHVUtils {
    public static byte[] encodeCHV(CHVControl control, String password) throws CardTerminalException {
        byte[] passbytes;
        if (!control.passwordEncoding().equals("String encoding") && !control.passwordEncoding().equals("Format 2 Block")) {
            throw new CardTerminalException("verification type not supported: " + control.toString());
        }
        if (control.passwordEncoding().equals("String encoding")) {
            int length;
            passbytes = password.getBytes();
            if (passbytes.length < (length = control.ioControl().maxInputChars())) {
                length = passbytes.length;
            }
        } else {
            int i;
            int length = 8;
            passbytes = new byte[length];
            for (i = 1; i < length; ++i) {
                passbytes[i] = -1;
            }
            for (i = 0; i < password.length() && i < 14; ++i) {
                char ch = password.charAt(i);
                if (ch < '0' || ch > '9') {
                    throw new CardTerminalException("CHV must only contain digits");
                }
                passbytes[1 + (i >> 1)] = (i & 1) == 0 ? (byte)(ch - 48 << 4 | 0xF) : (byte)(passbytes[1 + (i >> 1)] & 0xF0 | ch - 48);
            }
            passbytes[0] = (byte)(0x20 | i);
        }
        return passbytes;
    }
}

