/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.ChipAuthentication;
import de.cardcontact.opencard.eac.StandardizedDomainParameter;
import de.cardcontact.opencard.eac.TerminalAuthenticationSigner;
import de.cardcontact.opencard.security.IsoSecureChannelCredential;
import de.cardcontact.opencard.service.isocard.IsoCommandAPDU;
import de.cardcontact.opencard.service.isocard.apdu.ChipAuthenticationCommandData;
import de.cardcontact.opencard.service.isocard.apdu.ChipAuthenticationResponseData;
import de.cardcontact.opencard.service.isocard.apdu.GeneralAuthenticateCommandAPDU;
import de.cardcontact.opencard.service.isocard.apdu.GetChallengeCommandAPDU;
import de.cardcontact.opencard.service.isocard.apdu.ManageSECommandAPDU;
import de.cardcontact.opencard.service.isocard.apdu.VerifyCertificateCommandAPDU;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EACCardService
extends CardService {
    final Logger logger = LoggerFactory.getLogger(EACCardService.class);
    String rootCHR = null;
    ChipAuthentication ca;
    byte[] idPICC = new byte[0];
    PublicKey caPublicKey;

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, card, blocking);
    }

    public void setRootCHR(String rootCHR) {
        this.rootCHR = rootCHR;
    }

    public void setChipAuthenticationParameter(ObjectIdentifier protocol, StandardizedDomainParameter domainParameter) {
        this.ca = new ChipAuthentication(protocol, domainParameter);
    }

    public void setChipAuthenticationPublicKey(PublicKey caPublicKey) {
        this.caPublicKey = caPublicKey;
    }

    private CardVerifiableCertificate[] getCVCChain(TerminalAuthenticationSigner tasigner) throws CertificateException {
        byte[][] chainbin = tasigner.getCertificateChain(this.rootCHR);
        CardVerifiableCertificate[] chain = new CardVerifiableCertificate[chainbin.length];
        for (int i = 0; i < chainbin.length; ++i) {
            chain[i] = new CardVerifiableCertificate(chainbin[i]);
        }
        return chain;
    }

    private boolean selectPublicKey(byte[] chr, boolean queueable) throws OpenCardException {
        Sequence tlv = new Sequence();
        tlv.add(new PrimitiveTLV(new Tag(3, -128, false), chr));
        ManageSECommandAPDU cmd = new ManageSECommandAPDU(129, 182, tlv);
        cmd.setQueueable(queueable);
        CardChannel channel = this.getCardChannel();
        ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
        return rsp.sw() == 36864;
    }

    private void verifyCertificate(CardVerifiableCertificate cvc) throws OpenCardException {
        VerifyCertificateCommandAPDU cmd = new VerifyCertificateCommandAPDU(cvc);
        cmd.setQueueable(true);
        CardChannel channel = this.getCardChannel();
        ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
        if (rsp.sw() != 36864) {
            throw new CardServiceException("Could not verify certificate (SW=" + Integer.toHexString(rsp.sw()) + ")");
        }
    }

    private void verifyCertificateChain(CardVerifiableCertificate[] chain) throws OpenCardException {
        int i;
        for (i = chain.length - 1; i >= 0 && !this.selectPublicKey(chain[i].getCertificationAuthorityReference().getValue(), false); --i) {
        }
        if (i < 0) {
            throw new CardServiceException("Could not select a public key for verification.");
        }
        while (i < chain.length) {
            this.verifyCertificate(chain[i]);
            if (++i >= chain.length || this.selectPublicKey(chain[i].getCertificationAuthorityReference().getValue(), true)) continue;
            throw new CardServiceException("Could not select a public key " + new String(chain[i].getCertificationAuthorityReference().getValue()) + " for verification.");
        }
    }

    public byte[] prepareTerminalAuthentication(ChipAuthentication ca, CardVerifiableCertificate terminalCert, TLV auxdata) throws OpenCardException {
        Sequence tlv = new Sequence();
        ObjectIdentifier taOID = terminalCert.getCVCertificate().getCertificateBody().getPublicKeyTLV().getObjectIdentifier();
        tlv.add(new PrimitiveTLV(new Tag(0, -128, false), taOID.getValue()));
        byte[] chr = terminalCert.getCertificateHolderReference().getValue();
        tlv.add(new PrimitiveTLV(new Tag(3, -128, false), chr));
        if (auxdata != null) {
            tlv.add(tlv);
        }
        byte[] idIFD = ca.getCompressedPublicKey();
        tlv.add(new PrimitiveTLV(new Tag(17, -128, false), idIFD));
        IsoCommandAPDU cmd = new ManageSECommandAPDU(-127, -92, tlv);
        CardChannel channel = this.getCardChannel();
        ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
        if (rsp.sw() != 36864) {
            throw new CardServiceException("Could not verify certificate (SW=" + Integer.toHexString(rsp.sw()) + ")");
        }
        cmd = new GetChallengeCommandAPDU(8);
        channel = this.getCardChannel();
        rsp = channel.sendCommandAPDU(cmd);
        if (rsp.sw() != 36864) {
            throw new CardServiceException("Could not obtain challenge");
        }
        ByteBuffer buf = ByteBuffer.allocate(256);
        buf.put(this.idPICC);
        buf.put(rsp.data());
        buf.put(idIFD);
        if (auxdata != null) {
            buf.put(auxdata.getBytes());
        }
        this.logger.debug("Hash input" + HexString.dump(buf.array(), 0, buf.position()));
        buf.flip();
        byte[] dataTBS = new byte[buf.remaining()];
        buf.get(dataTBS);
        return dataTBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTerminalAuthentication(TerminalAuthenticationSigner tasigner) throws OpenCardException {
        CardVerifiableCertificate[] chain = null;
        try {
            chain = this.getCVCChain(tasigner);
        }
        catch (CertificateException ce) {
            this.logger.error("Certificates returned from TA-Signer invalid", (Throwable)ce);
            throw new CardServiceException("Certificates returned from TA-Signer invalid: " + ce.getMessage());
        }
        this.ca.generateEphemeralCAKeyPair();
        try {
            this.allocateCardChannel();
            this.verifyCertificateChain(chain);
            CardVerifiableCertificate terminalCert = chain[chain.length - 1];
            byte[] hash = this.prepareTerminalAuthentication(this.ca, terminalCert, null);
            String chr = new String(terminalCert.getCertificateHolderReference().getValue());
            byte[] signature = tasigner.getTASignature(hash, chr);
            IsoCommandAPDU cmd = new IsoCommandAPDU(0, -126, 0, 0, signature);
            CardChannel channel = this.getCardChannel();
            ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
            if (rsp.sw() != 36864) {
                throw new CardServiceException("Terminal authentication failed");
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private void selectChipAuthenticationParameter() throws OpenCardException {
        Sequence tlv = new Sequence();
        tlv.add(new PrimitiveTLV(new Tag(0, -128, false), this.ca.getProtocol()));
        ManageSECommandAPDU cmd = new ManageSECommandAPDU(65, 164, tlv);
        cmd.setQueueable(true);
        CardChannel channel = this.getCardChannel();
        ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
        if (rsp.sw() != 36864) {
            throw new CardServiceException("Terminal authentication failed");
        }
    }

    public void generateEphemeralCAKeyPair() {
        this.ca.generateEphemeralCAKeyPair();
    }

    public void performChipAuthentication() throws OpenCardException {
        try {
            this.allocateCardChannel();
            this.selectChipAuthenticationParameter();
            ChipAuthenticationCommandData cdata = new ChipAuthenticationCommandData(this.ca.getEncodedPublicKey());
            GeneralAuthenticateCommandAPDU cmd = new GeneralAuthenticateCommandAPDU(cdata);
            CardChannel channel = this.getCardChannel();
            ResponseAPDU rsp = channel.sendCommandAPDU(cmd);
            if (rsp.sw() != 36864) {
                throw new CardServiceException("Chip authentication failed");
            }
            ChipAuthenticationResponseData dad = ChipAuthenticationResponseData.parse(rsp.data());
            this.ca.performKeyAgreement(this.caPublicKey, dad.getNonce());
            if (!this.ca.verifyAuthenticationToken(dad.getAuthenticationToken())) {
                throw new CardServiceException("Authentication token verification failed");
            }
        }
        catch (TLVEncodingException te) {
            this.logger.error("Failed to parse GENERAL AUTHENTICATE R-Data", (Throwable)te);
            throw new CardServiceException("Failed to parse GENERAL AUTHENTICATE R-Data: " + te.getMessage());
        }
        finally {
            this.releaseCardChannel();
        }
    }

    public IsoSecureChannelCredential getSecureMessagingCredential() {
        return new IsoSecureChannelCredential(65535, this.ca.getIsoSecureChannel());
    }
}

