/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class GeneralizedTime
extends PrimitiveTLV {
    static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssX");

    public GeneralizedTime(ZonedDateTime zdt) {
        super(new Tag(24, 0, false), null);
        this.value = zdt.format(formatter).getBytes();
    }

    public GeneralizedTime(ParseBuffer pb) throws TLVEncodingException {
        super(pb);
    }

    public GeneralizedTime(TLV tlv) throws TLVEncodingException {
        super(tlv);
    }

    public LocalDate getLocalDate() {
        LocalDate ld = LocalDate.parse(new String(this.value, 0, 8), DateTimeFormatter.BASIC_ISO_DATE);
        return ld;
    }

    public ZonedDateTime getZonedDateTime() {
        ZonedDateTime zdt = ZonedDateTime.parse(new String(this.value), formatter);
        return zdt;
    }

    @Override
    public String toString() {
        return new String(this.value);
    }
}

