/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.TrustStore;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.eac20.EAC20;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.isocard.CHVManagementCardService;
import de.cardcontact.opencard.service.isocard.FileSystemSendAPDU;
import de.cardcontact.opencard.service.isocard.IsoFileControlInformation;
import de.cardcontact.opencard.service.remoteclient.HttpURLConnectionFactory;
import de.cardcontact.opencard.service.remoteclient.RemoteClient;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteUpdateService;
import de.cardcontact.opencard.service.smartcardhsm.CHVManager;
import de.cardcontact.opencard.service.smartcardhsm.CertificateDescription;
import de.cardcontact.opencard.service.smartcardhsm.DecipherCardService;
import de.cardcontact.opencard.service.smartcardhsm.EMSAPSSEncoder;
import de.cardcontact.opencard.service.smartcardhsm.InitializeConfiguration;
import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.KeyGenerationCardServiceWithSpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMAppletState;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKeySpec;
import de.cardcontact.tlv.ByteBuffer;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.APDU;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ExtendedVerifiedAPDUInterface;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.applet.BasicAppletCardService;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileSystemCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.PrivateKeyRef;
import opencard.opt.security.PublicKeyRef;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import opencard.opt.service.CardServiceObjectNotAvailableException;
import opencard.opt.service.CardServiceResourceNotFoundException;
import opencard.opt.service.CardServiceUnexpectedResponseException;
import opencard.opt.util.APDUInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMCardService
extends BasicAppletCardService
implements FileSystemCardService,
CHVCardServiceWithControl,
CHVManagementCardService,
SecureService,
KeyGenerationCardServiceWithSpec,
DecipherCardService,
FileSystemSendAPDU,
RemoteUpdateService,
APDUInterface {
    final Logger log = LoggerFactory.getLogger(SmartCardHSMCardService.class);
    private static final CardFilePath mf = new CardFilePath("#E82B0601040181C31F0201");
    private static final AppletID AID = new AppletID(new byte[]{-24, 43, 6, 1, 4, 1, -127, -61, 31, 2, 1});
    public static final String ALGO_PADDING_PKCS1_PSS = "PKCS1_PSS";
    private static HashMap<String, HashMap<String, Byte>> ALGORITHM_PADDING = new HashMap();
    private static byte ECDH = (byte)-128;
    private static byte NONE_WITH_RSA_DECRIPTION = (byte)33;
    private static final byte WRAP = -110;
    private static final byte UNWRAP = -109;
    private static final int USER_PIN = 129;
    private static final int SO_PIN = 136;
    private final HashMap<String, SmartCardHSMEntry> namemap = new HashMap(200);
    private final HashMap<Byte, SmartCardHSMKey> idmap = new HashMap(100);
    private final HashMap<Byte, Certificate> certIDMap = new HashMap(100);
    private final Vector<Byte> caid = new Vector();
    private byte[] lastobjectlist = null;
    private ArrayList<KeyDomain> keyDomains = null;
    private static final int KEY_CAPACITY = 60;
    public static final byte KEYPREFIX = -52;
    public static final byte PRKDPREFIX = -60;
    public static final byte EECERTIFICATEPREFIX = -50;
    public static final byte CACERTIFICATEPREFIX = -54;
    public static final byte CERTDESCRIPTIONPREFIX = -56;
    private static final int MAX_APDU = 1232;
    public static final ObjectIdentifier ID_KEY_DOMAIN_UID = new ObjectIdentifier(new int[]{1, 3, 6, 1, 4, 1, 24991, 3, 2, 2});
    private static final byte[] rootCert = new byte[]{127, 33, -126, 1, -76, 127, 78, -126, 1, 108, 95, 41, 1, 0, 66, 14, 68, 69, 83, 82, 67, 65, 67, 67, 49, 48, 48, 48, 48, 49, 127, 73, -126, 1, 29, 6, 10, 4, 0, 127, 0, 7, 2, 2, 2, 2, 3, -127, 32, -87, -5, 87, -37, -95, -18, -87, -68, 62, 102, 10, -112, -99, -125, -115, 114, 110, 59, -10, 35, -43, 38, 32, 40, 32, 19, 72, 29, 31, 110, 83, 119, -126, 32, 125, 90, 9, 117, -4, 44, 48, 87, -18, -10, 117, 48, 65, 122, -1, -25, -5, -128, 85, -63, 38, -36, 92, 108, -23, 74, 75, 68, -13, 48, -75, -39, -125, 32, 38, -36, 92, 108, -23, 74, 75, 68, -13, 48, -75, -39, -69, -41, 124, -65, -107, -124, 22, 41, 92, -9, -31, -50, 107, -52, -36, 24, -1, -116, 7, -74, -124, 65, 4, -117, -46, -82, -71, -53, 126, 87, -53, 44, 75, 72, 47, -4, -127, -73, -81, -71, -34, 39, -31, -29, -67, 35, -62, 58, 68, 83, -67, -102, -50, 50, 98, 84, 126, -8, 53, -61, -38, -60, -3, -105, -8, 70, 26, 20, 97, 29, -55, -62, 119, 69, 19, 45, -19, -114, 84, 92, 29, 84, -57, 47, 4, 105, -105, -123, 32, -87, -5, 87, -37, -95, -18, -87, -68, 62, 102, 10, -112, -99, -125, -115, 113, -116, 57, 122, -93, -75, 97, -90, -9, -112, 30, 14, -126, -105, 72, 86, -89, -122, 65, 4, 109, 2, 90, -128, 38, -51, -70, 36, 95, 16, -33, 27, 114, -23, -120, 15, -1, 116, 109, -85, 64, -92, 58, 61, 92, 107, -21, -14, 119, 7, -61, 15, 109, -22, 114, 67, 14, -29, 40, 123, 6, 101, -63, -22, -90, -22, -92, -6, 38, -60, 99, 3, 0, 25, -125, -8, 43, -47, -86, 49, -32, 61, -96, 98, -121, 1, 1, 95, 32, 14, 68, 69, 83, 82, 67, 65, 67, 67, 49, 48, 48, 48, 48, 49, 127, 76, 16, 6, 11, 43, 6, 1, 4, 1, -127, -61, 31, 3, 1, 1, 83, 1, -64, 95, 37, 6, 1, 2, 1, 1, 0, 9, 95, 36, 6, 3, 2, 1, 1, 0, 8, 95, 55, 64, -99, -69, 56, 43, 23, 17, -46, -70, -84, -80, -58, 35, -44, 12, 98, 103, -48, -75, 43, -92, 85, -64, 31, 86, 51, 61, -55, 85, 72, 16, -71, -78, -121, -115, -81, -98, -61, -83, -95, -100, 123, 6, 93, 120, 13, 108, -100, 60, 46, -50, -33, -41, -115, -21, 24, -81, 64, 119, -118, -33, -119, -24, 97, -54};
    private static final byte[] utCert = new byte[]{127, 33, -126, 1, -76, 127, 78, -126, 1, 108, 95, 41, 1, 0, 66, 14, 85, 84, 83, 82, 67, 65, 67, 67, 49, 48, 48, 48, 48, 49, 127, 73, -126, 1, 29, 6, 10, 4, 0, 127, 0, 7, 2, 2, 2, 2, 3, -127, 32, -87, -5, 87, -37, -95, -18, -87, -68, 62, 102, 10, -112, -99, -125, -115, 114, 110, 59, -10, 35, -43, 38, 32, 40, 32, 19, 72, 29, 31, 110, 83, 119, -126, 32, 125, 90, 9, 117, -4, 44, 48, 87, -18, -10, 117, 48, 65, 122, -1, -25, -5, -128, 85, -63, 38, -36, 92, 108, -23, 74, 75, 68, -13, 48, -75, -39, -125, 32, 38, -36, 92, 108, -23, 74, 75, 68, -13, 48, -75, -39, -69, -41, 124, -65, -107, -124, 22, 41, 92, -9, -31, -50, 107, -52, -36, 24, -1, -116, 7, -74, -124, 65, 4, -117, -46, -82, -71, -53, 126, 87, -53, 44, 75, 72, 47, -4, -127, -73, -81, -71, -34, 39, -31, -29, -67, 35, -62, 58, 68, 83, -67, -102, -50, 50, 98, 84, 126, -8, 53, -61, -38, -60, -3, -105, -8, 70, 26, 20, 97, 29, -55, -62, 119, 69, 19, 45, -19, -114, 84, 92, 29, 84, -57, 47, 4, 105, -105, -123, 32, -87, -5, 87, -37, -95, -18, -87, -68, 62, 102, 10, -112, -99, -125, -115, 113, -116, 57, 122, -93, -75, 97, -90, -9, -112, 30, 14, -126, -105, 72, 86, -89, -122, 65, 4, -96, 65, -2, -78, -3, 17, 107, 42, -47, -100, -90, -73, -22, -51, 113, -55, -119, 47, -108, 27, -72, -115, 103, -36, -18, -55, 37, 1, -16, 112, 1, 25, 87, -30, 33, 34, -70, 108, 44, -11, -1, 2, -109, 111, 72, 46, 53, -90, 18, -100, -53, -70, -114, -109, -125, -125, 109, 49, 6, -121, -100, 64, -114, -16, -121, 1, 1, 95, 32, 14, 85, 84, 83, 82, 67, 65, 67, 67, 49, 48, 48, 48, 48, 49, 127, 76, 16, 6, 11, 43, 6, 1, 4, 1, -127, -61, 31, 3, 1, 1, 83, 1, -64, 95, 37, 6, 1, 2, 1, 1, 0, 9, 95, 36, 6, 3, 2, 1, 1, 0, 8, 95, 55, 64, -111, 77, -48, -6, 0, 97, 92, 68, 4, -115, 20, 103, 67, 84, 0, 66, 58, 74, -47, -67, 55, -3, -104, -42, -34, -124, -3, -128, 55, 72, -107, -126, 50, 92, 114, -107, 109, 79, -33, -85, -58, -19, -70, 72, 24, 74, 117, 79, 55, -15, -66, 81, 66, -35, 28, 39, -42, 101, 105, 48, -116, -31, -102, -81};
    private SmartCardHSMAppletState state = null;
    private RemoteClient remoteClient = null;
    private HttpURLConnectionFactory connectionFactory = null;
    private int maxCAPDU = 1232;
    private int maxRAPDU = 1232;
    private int maxCData;
    private int maxRData;
    private boolean limitedAPDU = false;
    private int fastDeleteThreshold = 0;
    private int fastDeleteCount = 0;
    private String id = null;
    private boolean usePinPad = true;
    private boolean addDeviceCertificateToAliases = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, card, blocking);
        try {
            Properties features;
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            Hashtable channelState = (Hashtable)channel.getState();
            this.state = (SmartCardHSMAppletState)channelState.get(AID);
            if (this.state == null) {
                this.state = new SmartCardHSMAppletState();
                channelState.put(AID, this.state);
            }
            if ((features = channel.getCardTerminal().features()).containsKey("maxRAPDUSize")) {
                this.maxRAPDU = Integer.valueOf(features.getProperty("maxRAPDUSize"));
                this.limitedAPDU = true;
            }
            if (features.containsKey("maxCAPDUSize")) {
                this.maxCAPDU = Integer.valueOf(features.getProperty("maxCAPDUSize"));
                this.limitedAPDU = true;
            }
            this.maxCData = (this.maxCAPDU - 9 - 19) / 16 * 16 - 1;
            this.maxRData = (this.maxRAPDU - 18 - 2) / 16 * 16 - 1;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    protected void checkSelectResponse(AppletInfo info) {
        ResponseAPDU rsp = (ResponseAPDU)info.getData();
        IsoFileControlInformation fci = new IsoFileControlInformation(rsp.data());
        byte[] pd = fci.getProprietary();
        int version = pd[pd.length - 2] << 8 | pd[pd.length - 1] & 0xFF;
        this.state.setVersion(version);
    }

    public void useClassThreePinPad(boolean usePinPad) {
        this.usePinPad = usePinPad;
    }

    public void addDeviceCertificateToAliases(boolean addDeviceCertificateToAliases) {
        this.addDeviceCertificateToAliases = addDeviceCertificateToAliases;
    }

    @Override
    protected boolean isSelected(CardChannel channel) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(40);
        ResponseAPDU res = new ResponseAPDU(2);
        com.setLength(0);
        com.append((byte)0);
        com.append((byte)32);
        com.append((byte)0);
        com.append((byte)-127);
        res = channel.sendCommandAPDU(com);
        return res.sw() == 36864;
    }

    public void initSecureMessaging() throws CardServiceException, CardTerminalException, CertPathBuilderException {
        ECPublicKey devAutPubKey = this.getDevAutPK();
        EAC20 eac = new EAC20(this, devAutPubKey);
        this.state.setSecureChannelCredential(eac.performChipAuthentication());
    }

    public String getId() throws OpenCardException, CertPathBuilderException {
        if (this.id == null) {
            this.getDevAutPK();
        }
        return this.id;
    }

    public String getProvisioningURL() {
        try {
            byte[] trustedConfig = this.read(new CardFilePath(":CB00"), 0, -1);
            ConstructedTLV tlv = (ConstructedTLV)TLV.factory(trustedConfig);
            TLV t80 = tlv.findTag(new Tag(128), null);
            if (t80 == null) {
                return null;
            }
            return new String(t80.getValue());
        }
        catch (TLVEncodingException | OpenCardException e) {
            this.log.debug("Could not read trusted configuration", (Throwable)e);
            return null;
        }
    }

    public int getVersion() throws CardTerminalException, CardServiceException {
        int version = this.state.getVersion();
        if (version != 0) {
            return version;
        }
        CommandAPDU com = new CommandAPDU(5);
        com.append((byte)-128);
        com.append((byte)80);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        ResponseAPDU res = this.sendCommandAPDU(com);
        if (res.sw() != 36864 || res.getLength() < 4) {
            return 0;
        }
        version = res.getByte(res.getLength() - 4) << 8 | res.getByte(res.getLength() - 3);
        this.state.setVersion(version);
        return version;
    }

    public void deactivateSecureMessaging() {
        this.state.setSecureChannelCredential(null);
    }

    public boolean hasSendVerifiedCommandAPDU() {
        this.allocateCardChannel();
        CardTerminal ct = this.getCardChannel().getCardTerminal();
        boolean hasSendVerifiedCommandAPDU = ct instanceof VerifiedAPDUInterface;
        if (ct instanceof ExtendedVerifiedAPDUInterface) {
            ExtendedVerifiedAPDUInterface terminal = (ExtendedVerifiedAPDUInterface)((Object)ct);
            hasSendVerifiedCommandAPDU = terminal.hasSendVerifiedCommandAPDU();
        }
        this.releaseCardChannel();
        return hasSendVerifiedCommandAPDU;
    }

    private ResponseAPDU sendSecMsgCommand(CommandAPDU com) throws CardTerminalException, CardServiceException {
        ResponseAPDU res = null;
        SecureChannelCredential credential = this.state.getSecureChannelCredential();
        SecureChannel sc = credential.getSecureChannel();
        com = sc.wrap(com, credential.getUsageQualifier());
        res = this.sendCommandAPDU(AID, com);
        if (res.getLength() == 2) {
            this.state.setSecureChannelCredential(null);
            return res;
        }
        res = sc.unwrap(res, credential.getUsageQualifier());
        return res;
    }

    @Override
    public ResponseAPDU sendCommandAPDU(CommandAPDU com) throws CardTerminalException, CardServiceException {
        if ((com.getByte(0) & 8) == 8) {
            this.state.setSecureChannelCredential(null);
        }
        ResponseAPDU res = this.state.useSecureChannel() ? this.sendSecMsgCommand(com) : this.sendCommandAPDU(AID, com);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeApplication(SecurityDomain domain) throws CardServiceException, CardTerminalException {
        this.deactivateSecureMessaging();
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            AppletSelector selector = this.getAppletSelector();
            selector.selectApplet(channel, AID);
        }
        finally {
            this.releaseCardChannel();
        }
    }

    public CHVDialog createCHVManager() {
        CHVManager dialog = null;
        try {
            Class<?> clazz = Class.forName("de.cardcontact.opencard.ui.smartcardhsm.DefaultCHVManager");
            dialog = (CHVManager)clazz.getDeclaredConstructor(SmartCardHSMCardService.class).newInstance(this);
            dialog.useClassThreePinPad(this.usePinPad);
            this.setCHVDialog(dialog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dialog;
    }

    @Override
    public int getPasswordLength(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        return 0;
    }

    public boolean verifyBio(byte id, byte[] template) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(300);
        ResponseAPDU res = new ResponseAPDU(2);
        com.setLength(0);
        com.append((byte)-128);
        com.append((byte)32);
        com.append((byte)0);
        com.append(id);
        com.append((byte)template.length);
        System.arraycopy(template, 0, com.getBuffer(), 5, template.length);
        com.setLength(5 + template.length);
        this.sendCommandAPDU(com);
        return this.getSecurityStatus();
    }

    public boolean getSecurityStatus() throws CardServiceException, CardTerminalException {
        CHVCardServiceWithControl.PasswordStatus pws = this.getPasswordStatus(null, 1);
        return pws == CHVCardServiceWithControl.PasswordStatus.VERIFIED;
    }

    public boolean verifyPassword() throws CardServiceException, CardTerminalException {
        return this.verifyPassword(null, -1, null);
    }

    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, byte[] password) throws CardServiceException, CardTerminalException {
        if (this.getSecurityStatus()) {
            return true;
        }
        if (password == null) {
            CHVDialog dialog = this.getCHVDialog();
            if (dialog == null) {
                dialog = this.createCHVManager();
            }
            if (dialog == null) {
                throw new CardServiceException("Password can not be null if no AuthenticationManager is available");
            }
            if (dialog instanceof CHVManager) {
                return ((CHVManager)dialog).verifyPassword();
            }
            String pin = dialog.getCHV(-1);
            if (pin == null) {
                return false;
            }
            password = pin.getBytes();
        }
        boolean result = false;
        CommandAPDU com = new CommandAPDU(40);
        ResponseAPDU res = new ResponseAPDU(2);
        com.setLength(0);
        com.append((byte)0);
        com.append((byte)32);
        com.append((byte)0);
        com.append((byte)-127);
        com.append((byte)password.length);
        System.arraycopy(password, 0, com.getBuffer(), 5, password.length);
        com.setLength(5 + password.length);
        if (this.state.useSecureChannel()) {
            com.append((byte)0);
            res = this.sendSecMsgCommand(com);
        } else {
            res = this.sendCommandAPDU(AID, com);
        }
        com.clear();
        if (res.sw() == 36864) {
            result = true;
        } else if ((res.sw() & 0xFFF0) == 25536 || res.sw() == 27011) {
            result = false;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
        }
        return result;
    }

    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, CHVControl cc, byte[] password) throws CardServiceException, CardTerminalException {
        boolean result = false;
        CommandAPDU com = new CommandAPDU(40);
        ResponseAPDU res = new ResponseAPDU(2);
        com.setLength(0);
        com.append((byte)0);
        com.append((byte)32);
        com.append((byte)0);
        com.append((byte)-127);
        try {
            res = this.sendVerifiedAPDU(this.getChannel(), AID, com, cc, -1);
        }
        catch (CardServiceException e) {
            throw e;
        }
        finally {
            this.releaseCardChannel();
        }
        if (this.state.useSecureChannel()) {
            this.state.setSecureChannelCredential(null);
            try {
                this.initSecureMessaging();
            }
            catch (CertPathBuilderException e) {
                this.log.error("Could not start secure messaging", (Throwable)e);
                throw new CardServiceException(e.getMessage());
            }
        }
        if (res.sw() == 36864) {
            result = true;
        } else if ((res.sw() & 0xFFF0) == 25536 || res.sw() == 27011) {
            result = false;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
        }
        return result;
    }

    @Override
    public CHVCardServiceWithControl.PasswordStatus getPasswordStatus(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        CHVCardServiceWithControl.PasswordStatus status;
        CommandAPDU com = new CommandAPDU(40);
        ResponseAPDU res = new ResponseAPDU(2);
        if (number == 1) {
            CHVCardServiceWithControl.PasswordStatus status2 = this.getPasswordStatus(domain, 129);
            if ((status2 == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE || status2 == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) && this.getPasswordStatus(domain, 136) == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                return CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED;
            }
            return status2;
        }
        com.setLength(0);
        com.append((byte)0);
        com.append((byte)32);
        com.append((byte)0);
        com.append((byte)number);
        if (this.state.useSecureChannel()) {
            com.append((byte)0);
            res = this.sendSecMsgCommand(com);
        } else {
            res = this.sendCommandAPDU(AID, com);
        }
        if (res.sw() == 36864) {
            status = CHVCardServiceWithControl.PasswordStatus.VERIFIED;
        } else if (res.sw() == 25537) {
            status = CHVCardServiceWithControl.PasswordStatus.LASTTRY;
        } else if (res.sw() == 25538) {
            status = CHVCardServiceWithControl.PasswordStatus.RETRYCOUNTERLOW;
        } else if ((res.sw() & 0xFFF0) == 25536) {
            status = CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED;
        } else if (res.sw() == 25344) {
            status = CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED;
        } else if (res.sw() == 27011) {
            status = CHVCardServiceWithControl.PasswordStatus.BLOCKED;
        } else if (res.sw() == 27012) {
            status = CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE;
        } else if (res.sw() == 27272 || res.sw() == 27270) {
            status = CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
        }
        return status;
    }

    @Override
    @Deprecated
    public void appendRecord(CardFilePath file, byte[] data) throws CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("appendRecord() ist not implemented");
    }

    @Override
    public boolean exists(CardFilePath file) throws CardServiceException, CardTerminalException {
        try {
            this.getFileInfo(file);
        }
        catch (CardServiceObjectNotAvailableException e) {
            return false;
        }
        return true;
    }

    @Override
    public CardFileInfo getFileInfo(CardFilePath file) throws CardServiceException, CardTerminalException {
        ResponseAPDU rsp;
        CommandAPDU com = new CommandAPDU(32);
        CardFilePathComponent path = file.tail();
        boolean isAID = path instanceof CardFileAppID;
        byte[] pathBytes = isAID ? ((CardFileAppID)path).toByteArray() : ((CardFileFileID)path).toByteArray();
        com.append((byte)0);
        com.append((byte)-92);
        com.append(isAID ? (byte)4 : 2);
        com.append((byte)0);
        com.append((byte)pathBytes.length);
        com.append(pathBytes);
        com.append((byte)0);
        if (this.state.useSecureChannel()) {
            if (isAID) {
                this.deactivateSecureMessaging();
                rsp = this.sendCommandAPDU(AID, com);
                try {
                    this.initSecureMessaging();
                }
                catch (CertPathBuilderException e) {
                    this.log.error("Could not start secure messaging", (Throwable)e);
                    throw new CardServiceException(e.getMessage());
                }
            } else {
                rsp = this.sendSecMsgCommand(com);
            }
        } else {
            rsp = this.sendCommandAPDU(AID, com);
        }
        if (rsp.sw() == 27266) {
            throw new CardServiceObjectNotAvailableException(path + " not found.");
        }
        return new IsoFileControlInformation(rsp.data());
    }

    @Override
    public CardFilePath getRoot() {
        return mf;
    }

    @Override
    public byte[] read(CardFilePath file, int offset, int length) throws CardServiceException, CardTerminalException {
        if (offset < 0 || length != -1 && length < 0) {
            throw new CardServiceInvalidParameterException("read: offset = " + offset + ", length = " + length);
        }
        int chunksize = this.maxRData;
        if (length == -1 || length == 0) {
            length = 65535;
        }
        APDU rsp = null;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (buffer.size() < length) {
            CommandAPDU com = new CommandAPDU(14);
            com.append((byte)0);
            com.append((byte)-79);
            CardFileFileID fid = (CardFileFileID)file.tail();
            com.append(fid.toByteArray());
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)4);
            com.append((byte)84);
            com.append((byte)2);
            com.append((byte)(offset >> 8));
            com.append((byte)offset);
            com.append((byte)(chunksize >> 8));
            com.append((byte)chunksize);
            rsp = this.sendCommandAPDU(com);
            byte[] data = ((ResponseAPDU)rsp).data();
            if (data != null) {
                buffer.write(data, 0, data.length);
                offset += data.length;
            }
            if (((ResponseAPDU)rsp).sw() == 25218 && (data == null || this.state.getVersion() >= 772 || data.length == 0)) break;
            if (((ResponseAPDU)rsp).sw() == 36864 || ((ResponseAPDU)rsp).sw() == 25218) continue;
            int sw = ((ResponseAPDU)rsp).sw();
            rsp.clear();
            throw new CardServiceUnexpectedStatusWordException("READ BINARY", sw);
        }
        if (rsp != null) {
            rsp.clear();
        }
        return buffer.toByteArray();
    }

    @Override
    @Deprecated
    public byte[] readRecord(CardFilePath file, int recordNumber) throws CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("readRecord(CardFilePath file, int recordNumber) is not implemented");
    }

    @Override
    @Deprecated
    public byte[][] readRecords(CardFilePath file, int number) throws CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("readRecords(CardFilePath file, int number) is not implemented");
    }

    @Override
    @Deprecated
    public void write(CardFilePath file, int foffset, byte[] source, int soffset, int length) throws CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("write(CardFilePath file, int foffset, byte[] source, int soffset, int length) is not implemented");
    }

    @Override
    public void write(CardFilePath file, int offset, byte[] data) throws CardServiceException, CardTerminalException {
        ResponseAPDU rsp = null;
        if (offset < 0 || offset > 65535) {
            throw new CardServiceInvalidParameterException("write: offset = " + offset);
        }
        if (data == null) {
            data = new byte[]{};
        }
        int chunksize = this.maxCData - 8;
        CardFileFileID fid = (CardFileFileID)file.tail();
        int chunkOffs = 0;
        do {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(84);
            buffer.write(2);
            buffer.write(offset >> 8);
            buffer.write(offset);
            try {
                byte[] chunk;
                if (data.length <= chunksize) {
                    chunk = data;
                } else if (data.length - chunkOffs < chunksize) {
                    chunk = new byte[data.length - chunkOffs];
                    System.arraycopy(data, chunkOffs, chunk, 0, chunk.length);
                } else {
                    chunk = new byte[chunksize];
                    System.arraycopy(data, chunkOffs, chunk, 0, chunksize);
                }
                offset += chunk.length;
                chunkOffs += chunk.length;
                PrimitiveTLV payload = new PrimitiveTLV(83, chunk);
                buffer.write(payload.getBytes());
            }
            catch (TLVEncodingException | IOException exception) {
                // empty catch block
            }
            CommandAPDU com = new CommandAPDU(11 + buffer.size());
            com.append((byte)0);
            com.append((byte)-41);
            com.append(fid.toByteArray());
            com.append((byte)0);
            com.append((byte)(buffer.size() >> 8));
            com.append((byte)buffer.size());
            com.append(buffer.toByteArray());
            rsp = this.sendCommandAPDU(com);
            if (rsp.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("UPDATE BINARY", rsp.sw());
            }
            if (rsp.getLength() <= 2) continue;
            throw new CardServiceUnexpectedResponseException("No response expected");
        } while (chunkOffs < data.length);
    }

    @Override
    @Deprecated
    public void writeRecord(CardFilePath file, int recordNumber, byte[] data) throws CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("writeRecord() is not implemented");
    }

    @Override
    @Deprecated
    public void provideCredentials(SecurityDomain domain, CredentialBag creds) throws CardServiceException {
    }

    protected static int getLengthFieldSizeHelper(int length) {
        int size = 1;
        if (length >= 128) {
            ++size;
        }
        if (length >= 256) {
            ++size;
        }
        return size;
    }

    protected static void lengthToByteArrayOutputStream(int length, ByteArrayOutputStream bos) {
        int size = SmartCardHSMCardService.getLengthFieldSizeHelper(length);
        int i = 0;
        if (size > 1) {
            bos.write((byte)(0x80 | size - 1));
            i = (size - 2) * 8;
        }
        while (i >= 0) {
            bos.write((byte)(length >> i));
            i -= 8;
        }
    }

    @Override
    public void create(CardFilePath parent, byte[] data) throws CardServiceException, CardTerminalException {
        if (data.length != 4) {
            throw new CardServiceException("Unknown data encoding");
        }
        CardFilePath path = new CardFilePath(new byte[]{data[2], data[3]});
        this.write(path, 0, null);
    }

    public void setFastDeleteThreshold(int threshold) {
        this.fastDeleteThreshold = threshold;
        this.fastDeleteCount = threshold;
    }

    @Override
    public void delete(CardFilePath file) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(7);
        byte p2 = 0;
        if (this.fastDeleteCount > 0) {
            p2 = -128;
            --this.fastDeleteCount;
        } else {
            this.fastDeleteCount = this.fastDeleteThreshold;
        }
        CardFileFileID data = (CardFileFileID)file.tail();
        byte[] fid = data.toByteArray();
        com.append((byte)0);
        com.append((byte)-28);
        com.append((byte)2);
        com.append(p2);
        com.append((byte)2);
        System.arraycopy(fid, 0, com.getBuffer(), com.getLength(), fid.length);
        com.setLength(5 + fid.length);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864 && rsp.sw() != 27266) {
            throw new CardServiceUnexpectedStatusWordException("DELETE FILE", rsp.sw());
        }
        if (rsp.getLength() > 2) {
            throw new CardServiceUnexpectedResponseException("No response expected");
        }
    }

    @Override
    @Deprecated
    public void invalidate(CardFilePath file) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("invalidate(CardFilePath file) is not implemented");
    }

    @Override
    @Deprecated
    public void rehabilitate(CardFilePath file) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        throw new CardServiceInabilityException("rehabilitate(CardFilePath file) is not implemented");
    }

    @Override
    public boolean changeReferenceData(SecurityDomain domain, int number, CHVControl cc, byte[] currentPassword, byte[] newPassword) throws CardTerminalException, CardServiceException {
        if (number != 129 && number != 136) {
            throw new CardServiceInvalidParameterException("Parameter \"number\" must be one of 0x81 or 0x88");
        }
        CommandAPDU com = new CommandAPDU(5 + currentPassword.length + newPassword.length);
        boolean result = false;
        com.append((byte)0);
        com.append((byte)36);
        com.append((byte)0);
        com.append((byte)number);
        com.append((byte)(currentPassword.length + newPassword.length));
        com.append(currentPassword);
        com.append(newPassword);
        ResponseAPDU res = this.sendCommandAPDU(com);
        if (res.sw() == 36864) {
            result = true;
        } else if ((res.sw() & 0xFFF0) == 25536) {
            result = false;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
        }
        return result;
    }

    @Override
    public boolean resetRetryCounter(SecurityDomain domain, int number, CHVControl cc, byte[] unblockingCode, byte[] newPassword) throws CardTerminalException, CardServiceException {
        ResponseAPDU rsp;
        if (number != 129 && number != 136) {
            throw new CardServiceInvalidParameterException("Parameter \"number\" must be one of 0x81 or 0x88");
        }
        CommandAPDU com = new CommandAPDU(40);
        Boolean result = false;
        com.append((byte)0);
        com.append((byte)44);
        com.append(newPassword == null ? (byte)1 : 0);
        com.append((byte)number);
        com.append(newPassword == null ? (byte)8 : (byte)(newPassword.length + unblockingCode.length));
        com.append(unblockingCode);
        if (newPassword != null) {
            com.append(newPassword);
        }
        if ((rsp = this.sendCommandAPDU(com)).sw() == 36864) {
            result = true;
        } else if ((rsp.sw() & 0xFFF0) == 25536) {
            result = false;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", rsp.sw());
        }
        return result;
    }

    public void initialize(byte[] config, byte[] initPin, byte[] initCode, byte retryCounter) throws CardTerminalException, CardServiceException, TLVEncodingException {
        CommandAPDU com = new CommandAPDU(40);
        ConstructedTLV data = new ConstructedTLV(48);
        data.add(new PrimitiveTLV(128, config));
        data.add(new PrimitiveTLV(129, initPin));
        data.add(new PrimitiveTLV(130, initCode));
        data.add(new PrimitiveTLV(145, new byte[]{retryCounter}));
        com.append((byte)-128);
        com.append((byte)80);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)data.getLength());
        com.append(data.getValue());
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("INITIALIZE", rsp.sw());
        }
    }

    public void initialize(byte[] config, byte[] initPin, byte[] initCode, byte retryCounter, byte noOfShares) throws CardTerminalException, CardServiceException, TLVEncodingException {
        CommandAPDU com = new CommandAPDU(40);
        ConstructedTLV data = new ConstructedTLV(48);
        data.add(new PrimitiveTLV(128, config));
        data.add(new PrimitiveTLV(129, initPin));
        data.add(new PrimitiveTLV(130, initCode));
        data.add(new PrimitiveTLV(145, new byte[]{retryCounter}));
        data.add(new PrimitiveTLV(146, new byte[]{noOfShares}));
        com.append((byte)-128);
        com.append((byte)80);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)data.getLength());
        com.append(data.getValue());
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("INITIALIZE", rsp.sw());
        }
    }

    public void initialize(InitializeConfiguration config) throws CardTerminalException, CardServiceException, TLVEncodingException {
        CommandAPDU com = new CommandAPDU(40);
        byte[] cdata = config.getCData();
        com.append((byte)-128);
        com.append((byte)80);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)cdata.length);
        com.append(cdata);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("INITIALIZE", rsp.sw());
        }
    }

    @Deprecated
    public byte[] generateKeyPair(byte keyId, byte signingId, SmartCardHSMPrivateKeySpec spec) throws CardTerminalException, CardServiceException, TLVEncodingException {
        byte[] rsp;
        try {
            rsp = this.generateKeyPair(keyId, spec);
        }
        catch (OpenCardException e) {
            throw new CardServiceException(e.getMessage());
        }
        return rsp;
    }

    @Override
    public byte[] generateKeyPair(byte keyId, SmartCardHSMPrivateKeySpec spec) throws OpenCardException {
        ResponseAPDU rsp;
        CommandAPDU com = new CommandAPDU(1024);
        com.append((byte)0);
        com.append((byte)70);
        com.append(keyId);
        com.append((byte)0);
        byte[] data = spec.getCData();
        int length = data.length;
        com.append((byte)0);
        com.append((byte)(length >> 8));
        com.append((byte)length);
        System.arraycopy(data, 0, com.getBuffer(), com.getLength(), data.length);
        com.setLength(7 + data.length);
        if (!this.limitedAPDU) {
            com.append((byte)0);
            com.append((byte)0);
        }
        if ((rsp = this.sendCommandAPDU(com)).sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("GENERATE ASYMMETRIC KEY PAIR", rsp.sw());
        }
        if (this.limitedAPDU) {
            data = this.read(new CardFilePath(new byte[]{-50, keyId}), 0, -1);
            spec.setStorePublicKey(false);
        } else {
            data = rsp.data();
        }
        return data;
    }

    @Override
    public byte[] generateKey(byte newKeyId, SmartCardHSMSecretKeySpec spec) throws OpenCardException {
        CommandAPDU com = new CommandAPDU(512);
        com.append((byte)0);
        com.append((byte)72);
        com.append(newKeyId);
        byte algo = -80;
        switch (spec.getKeySize()) {
            case 128: {
                algo = -80;
                break;
            }
            case 192: {
                algo = -79;
                break;
            }
            case 256: {
                algo = -78;
            }
        }
        com.append(algo);
        byte[] data = spec.getCData();
        com.append((byte)data.length);
        com.append(data);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("GENERATE SYMMETRIC KEY failed", rsp.sw());
        }
        data = rsp.data();
        return data;
    }

    public byte[] importDKEKShare(byte[] keyShare) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(300);
        if (keyShare.length != 32) {
            throw new CardServiceInvalidParameterException("The DKEK share must have a length of 32 bytes.");
        }
        com.append((byte)-128);
        com.append((byte)82);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)keyShare.length);
        com.append(keyShare);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("IMPORT DKEK SHARE", rsp.sw());
        }
        return rsp.data();
    }

    public byte[] wrapKey(byte kid) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(300);
        com.append((byte)-128);
        com.append((byte)114);
        com.append(kid);
        com.append((byte)-110);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("WRAP KEY", rsp.sw());
        }
        return rsp.data();
    }

    public boolean unwrapKey(byte kid, byte[] key) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(7 + key.length);
        com.append((byte)-128);
        com.append((byte)116);
        com.append(kid);
        com.append((byte)-109);
        com.append((byte)0);
        com.append((byte)(key.length >> 8));
        com.append((byte)key.length);
        com.append(key);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("UNWRAP KEY", rsp.sw());
        }
        return true;
    }

    @Override
    @Deprecated
    public void generateKeyPair(PrivateKeyRef privateDest, PublicKeyRef publicDest, int strength, String keyAlgorithm) throws CardServiceException, InvalidKeyException, CardTerminalException {
    }

    @Override
    @Deprecated
    public PublicKey readPublicKey(PublicKeyRef pulicKey, String keyAlgorithm) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return null;
    }

    @Override
    public byte[] signData(PrivateKeyRef privateKey, String signAlgorithm, byte[] data) throws CardServiceException, CardTerminalException {
        return this.signData(privateKey, signAlgorithm, "DEFAULT", data);
    }

    private byte[] normalizeECDSASignature(byte[] sig) throws CardServiceOperationFailedException {
        ConstructedTLV ntlv;
        try {
            ConstructedTLV tlv = new ConstructedTLV(sig);
            ntlv = new ConstructedTLV(new Tag(16, 0, true));
            for (int i = 0; i < 2; ++i) {
                int ofs;
                PrimitiveTLV x = (PrimitiveTLV)tlv.get(i);
                byte[] buf = x.getValue();
                for (ofs = 0; ofs < buf.length && buf[ofs] == 0 && (buf[ofs + 1] & 0xFF) < 128; ++ofs) {
                }
                if (ofs > 0) {
                    byte[] nbuf = new byte[buf.length - ofs];
                    System.arraycopy(buf, ofs, nbuf, 0, nbuf.length);
                    buf = nbuf;
                }
                PrimitiveTLV nx = new PrimitiveTLV(2, buf);
                ntlv.add(nx);
            }
        }
        catch (TLVEncodingException e) {
            throw new CardServiceOperationFailedException("ECDSA signature invalid format");
        }
        return ntlv.getBytes();
    }

    @Override
    public byte[] signData(PrivateKeyRef privateKey, String signAlgorithm, String padAlgorithm, byte[] data) throws CardServiceException, CardTerminalException {
        int length = data.length;
        CommandAPDU com = new CommandAPDU(9 + length);
        if (signAlgorithm.contains("RSA") && !(privateKey instanceof SmartCardHSMKey) || signAlgorithm.contains("ECDSA") && !(privateKey instanceof SmartCardHSMKey)) {
            throw new CardServiceOperationFailedException("Algorithm and key don't match.");
        }
        if (ALGORITHM_PADDING.containsKey(padAlgorithm) && ALGORITHM_PADDING.get(padAlgorithm).containsKey(signAlgorithm)) {
            com.append((byte)-128);
            com.append((byte)104);
            byte keyNo = ((SmartCardHSMKey)((Object)privateKey)).getKeyRef();
            com.append(keyNo);
            com.append(ALGORITHM_PADDING.get(padAlgorithm).get(signAlgorithm));
            com.append((byte)0);
            com.append((byte)(length >> 8));
            com.append((byte)length);
            com.append(data);
            com.append((byte)0);
            com.append((byte)0);
            ResponseAPDU rsp = this.sendCommandAPDU(com);
            if (rsp.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("SIGN", rsp.sw());
            }
            if (signAlgorithm.contains("RSA")) {
                return rsp.data();
            }
            return this.normalizeECDSASignature(rsp.data());
        }
        throw new CardServiceOperationFailedException("There is no matching algorithm.");
    }

    @Override
    public byte[] signHash(PrivateKeyRef privateKey, String signAlgorithm, byte[] hash) throws CardServiceException, InvalidKeyException, CardTerminalException {
        if (signAlgorithm.equals("NONEwithECDSA")) {
            return this.signData(privateKey, "NONEwithECDSA", hash);
        }
        if (signAlgorithm.equals("SHA1withRSA") || signAlgorithm.equals("SHA256withRSA")) {
            return this.signHash(privateKey, signAlgorithm, "PKCS1_V15", hash);
        }
        if (signAlgorithm.equals("NONEwithRSA")) {
            return this.signHash(privateKey, signAlgorithm, "PKCS1_V15", hash);
        }
        throw new CardServiceOperationFailedException("Algorithm for hash object required.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] signHash(PrivateKeyRef privateKey, String signAlgorithm, String padAlgorithm, byte[] hash) throws CardServiceException, CardTerminalException {
        if (padAlgorithm.equals("PKCS1_V15")) {
            if (!(privateKey instanceof SmartCardHSMKey)) throw new CardServiceOperationFailedException("Algorithm and key don't match.");
            ObjectIdentifier oid = null;
            if (signAlgorithm.equals("SHA1withRSA")) {
                oid = new ObjectIdentifier("1.3.14.3.2.26");
            } else if (signAlgorithm.equals("SHA256withRSA")) {
                oid = new ObjectIdentifier("2.16.840.1.101.3.4.2.1");
            } else if (signAlgorithm.equals("SHA384withRSA")) {
                oid = new ObjectIdentifier("2.16.840.1.101.3.4.2.2");
            } else if (signAlgorithm.equals("SHA512withRSA")) {
                oid = new ObjectIdentifier("2.16.840.1.101.3.4.2.3");
            } else {
                if (!signAlgorithm.equals("NONEwithRSA")) throw new CardServiceOperationFailedException("There is no matching algorithm.");
                byte[] em = this.padWithPKCS1v15(hash, ((SmartCardHSMKey)((Object)privateKey)).getKeySize());
                return this.signData(privateKey, "NONEwithRSA", "NONE", em);
            }
            try {
                byte[] digestInfo = this.buildDigestInfo(oid, hash);
                byte[] em = this.padWithPKCS1v15(digestInfo, ((SmartCardHSMKey)((Object)privateKey)).getKeySize());
                return this.signData(privateKey, "NONEwithRSA", "NONE", em);
            }
            catch (TLVEncodingException e) {
                this.log.error("signHash", (Throwable)e);
                return null;
            }
        }
        if (padAlgorithm.equals(ALGO_PADDING_PKCS1_PSS)) {
            if (!(privateKey instanceof SmartCardHSMKey)) throw new CardServiceOperationFailedException("Algorithm and key don't match.");
            String id = "";
            MessageDigest md = null;
            if (signAlgorithm.equals("SHA1withRSA")) {
                id = "SHA1";
            } else if (signAlgorithm.equals("SHA256withRSA")) {
                id = "SHA256";
            } else if (signAlgorithm.equals("SHA384withRSA")) {
                id = "SHA384";
            } else {
                if (!signAlgorithm.equals("SHA512withRSA")) throw new CardServiceOperationFailedException("There is no matching algorithm.");
                id = "SHA512";
                if (((SmartCardHSMKey)((Object)privateKey)).getKeySize() < 1033) {
                    throw new CardServiceOperationFailedException("Key size too small for specified hash algorithm.");
                }
            }
            if (this.state.getVersion() >= 512 && (id.equals("SHA1") || id.equals("SHA256"))) {
                return this.signData(privateKey, "NONEwithRSA", ALGO_PADDING_PKCS1_PSS, hash);
            }
            try {
                md = MessageDigest.getInstance(id);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CardServiceOperationFailedException("Unable to get instance of message digest : " + e.getLocalizedMessage());
            }
            EMSAPSSEncoder encoder = new EMSAPSSEncoder(md, ((SmartCardHSMKey)((Object)privateKey)).getKeySize());
            byte[] pssblock = null;
            try {
                pssblock = encoder.encode(hash);
                return this.signData(privateKey, "NONEwithRSA", "NONE", pssblock);
            }
            catch (IOException e) {
                throw new CardServiceOperationFailedException("Unable to create PSS encoding : " + e.getLocalizedMessage());
            }
        }
        if (!padAlgorithm.equals("NONE")) throw new CardServiceOperationFailedException("There is no matching algorithm.");
        if (!signAlgorithm.equals("NONEwithECDSA")) throw new CardServiceOperationFailedException("There is no matching algorithm.");
        if (!(privateKey instanceof SmartCardHSMKey)) throw new CardServiceOperationFailedException("Alogrithm and key don't match.");
        hash = this.verifyHashLength(((SmartCardHSMKey)((Object)privateKey)).getKeySize(), hash);
        return this.signData(privateKey, "NONEwithECDSA", "NONE", hash);
    }

    private byte[] verifyHashLength(int keySize, byte[] hash) {
        int length = keySize / 8;
        byte[] paddedHash = new byte[length];
        if (hash.length == length) {
            return hash;
        }
        if (hash.length < length) {
            System.arraycopy(hash, 0, paddedHash, paddedHash.length - hash.length, hash.length);
            return paddedHash;
        }
        System.arraycopy(hash, 0, paddedHash, 0, paddedHash.length);
        return paddedHash;
    }

    private byte[] buildDigestInfo(ObjectIdentifier oid, byte[] hash) throws TLVEncodingException {
        ConstructedTLV digestInfo = new ConstructedTLV(48);
        ConstructedTLV algorithmID = new ConstructedTLV(48);
        algorithmID.add(oid);
        algorithmID.add(new PrimitiveTLV(5, null));
        PrimitiveTLV digest = new PrimitiveTLV(4, hash);
        digestInfo.add(algorithmID);
        digestInfo.add(digest);
        byte[] t = digestInfo.getBytes();
        return t;
    }

    private byte[] padWithPKCS1v15(byte[] t, int keySize) throws CardServiceOperationFailedException {
        int emLen = keySize / 8;
        if (emLen < t.length + 11) {
            throw new CardServiceOperationFailedException("Intended encoded message length too short.");
        }
        byte[] em = new byte[emLen];
        em[0] = 0;
        em[1] = 1;
        int psLen = emLen - t.length - 3;
        int j = 2;
        int i = 0;
        while (i < psLen) {
            em[j] = -1;
            ++i;
            ++j;
        }
        em[j] = 0;
        System.arraycopy(t, 0, em, j + 1, t.length);
        return em;
    }

    @Override
    @Deprecated
    public boolean verifySignedData(PublicKeyRef publicKey, String signAlgorithm, byte[] data, byte[] signature) throws CardServiceException, InvalidKeyException, CardTerminalException {
        throw new CardServiceInabilityException("verifySignedData(PublicKeyRef publicKey, String signAlgorithm, byte[] data, byte[] signature)");
    }

    @Override
    @Deprecated
    public boolean verifySignedData(PublicKeyRef publicKey, String signAlgorithm, String padAlgorithm, byte[] data, byte[] signature) throws CardServiceException, InvalidKeyException, CardTerminalException {
        throw new CardServiceInabilityException("verifySignedData(PublicKeyRef publicKey, String signAlgorithm, String padAlgorithm, byte[] data, byte[] signature)");
    }

    @Override
    @Deprecated
    public boolean verifySignedHash(PublicKeyRef publicKey, String signAlgorithm, byte[] hash, byte[] signature) throws CardServiceException, InvalidKeyException, CardTerminalException {
        throw new CardServiceInabilityException("verifySignedHash(PublicKeyRef publicKey, String signAlgorithm, byte[] hash, byte[] signature)");
    }

    @Override
    @Deprecated
    public boolean verifySignedHash(PublicKeyRef publicKey, String signAlgorithm, String padAlgorithm, byte[] hash, byte[] signature) throws CardServiceException, InvalidKeyException, CardTerminalException {
        throw new CardServiceInabilityException("verifySignedHash(PublicKeyRef publicKey, String signAlgorithm, String padAlgorithm, byte[] hash, byte[] signature)");
    }

    public byte[] enumerateObjects() throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(7);
        com.append((byte)-128);
        com.append((byte)88);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("ENUMERATE OBJECTS", rsp.sw());
        }
        return rsp.data();
    }

    public byte[] generateRandom(int length) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(7);
        com.append((byte)0);
        com.append((byte)-124);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)(length >> 8));
        com.append((byte)length);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("GET CHALLENGE", rsp.sw());
        }
        return rsp.data();
    }

    @Override
    public byte[] decipher(SmartCardHSMKey privateKey, byte[] cryptogram, byte algorithmID) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(530);
        com.append((byte)-128);
        com.append((byte)98);
        com.append(privateKey.getKeyRef());
        com.append(algorithmID);
        com.append((byte)0);
        com.append((byte)(cryptogram.length >> 8));
        com.append((byte)cryptogram.length);
        com.append(cryptogram);
        com.append((byte)0);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            rsp.clear();
            throw new CardServiceUnexpectedStatusWordException("DECIPHER", rsp.sw());
        }
        byte[] data = rsp.data();
        rsp.clear();
        return data;
    }

    @Override
    public byte[] decipher(SmartCardHSMKey privateKey, byte[] cryptogram) throws CardTerminalException, CardServiceException {
        return this.decipher(privateKey, cryptogram, (byte)33);
    }

    @Override
    public byte[] performECCDH(SmartCardHSMKey privateKey, byte[] pkComponents) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(200);
        com.append((byte)-128);
        com.append((byte)98);
        com.append(privateKey.getKeyRef());
        com.append(ECDH);
        com.append((byte)0);
        com.append((byte)(pkComponents.length >> 8));
        com.append((byte)pkComponents.length);
        com.append(pkComponents);
        com.append((byte)0);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            rsp.clear();
            throw new CardServiceUnexpectedStatusWordException("PERFORM ECCDH", rsp.sw());
        }
        byte[] data = rsp.data();
        rsp.clear();
        return data;
    }

    public void verifyCertificate(CardVerifiableCertificate cvc) throws CardTerminalException, CardServiceException {
        byte[] certificateBody = cvc.getCVCertificate().getCertificateBody().getBytes();
        byte[] certificateSignature = cvc.getCVCertificate().getSignatureTLV().getBytes();
        int length = certificateBody.length + certificateSignature.length;
        CommandAPDU com = new CommandAPDU(9 + length);
        com.append((byte)0);
        com.append((byte)42);
        com.append((byte)0);
        com.append((byte)-66);
        if (length > 255) {
            com.append((byte)0);
            com.append((byte)(length >> 8));
            com.append((byte)length);
        } else {
            com.append((byte)length);
        }
        com.append(certificateBody);
        com.append(certificateSignature);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("VERIFY CERTIFICATE", rsp.sw());
        }
    }

    public boolean selectPubKeyForSignature(PublicKeyReference chr) throws OpenCardException {
        PrimitiveTLV tlv = new PrimitiveTLV(new Tag(3, -128, false), chr.getValue());
        byte[] cdata = tlv.getBytes();
        byte p1 = -127;
        byte p2 = -74;
        return this.manageSE(p1, p2, cdata);
    }

    public void verifyCertificateChain(CardVerifiableCertificate[] chain) throws OpenCardException {
        int i = 0;
        PublicKeyReference car = chain[i].getOuterCertificationAuthorityReference();
        while (!this.selectPubKeyForSignature(car)) {
            if (++i >= chain.length) {
                throw new CardServiceException("Invalid certificate chain: CAR " + car + " not found");
            }
            car = chain[i].getCertificationAuthorityReference();
        }
        while (i > 0) {
            this.verifyCertificate(chain[i]);
            car = chain[i].getCertificateHolderReference();
            if (!this.selectPubKeyForSignature(car)) {
                throw new CardServiceException("Invalid certificate chain: CAR " + car + " not found");
            }
            --i;
        }
    }

    public boolean selectPubKeyForAuthentication(byte[] chr) throws CardTerminalException, CardServiceException {
        PrimitiveTLV tlv = new PrimitiveTLV(new Tag(3, -128, false), chr);
        byte[] cdata = tlv.getBytes();
        byte p1 = -127;
        byte p2 = -92;
        return this.manageSE(p1, p2, cdata);
    }

    public boolean manageSE(byte p1, byte p2, byte[] cdata) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(100);
        com.append((byte)0);
        com.append((byte)34);
        com.append(p1);
        com.append(p2);
        com.append((byte)cdata.length);
        com.append(cdata);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864 && rsp.sw() != 27272) {
            throw new CardServiceUnexpectedStatusWordException("MANAGE SE", rsp.sw());
        }
        return rsp.sw() == 36864;
    }

    public void manageSE(byte[] data) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(100);
        com.append((byte)0);
        com.append((byte)34);
        com.append((byte)65);
        com.append((byte)-92);
        com.append((byte)12);
        com.append(data);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("MANAGE SE", rsp.sw());
        }
    }

    public void deriveXKEK(byte keyId, CardVerifiableCertificate puk) throws OpenCardException {
        byte[] cvc = puk.getCVCertificate().getBytes();
        byte[] ocar = puk.getAuthenticatedRequest().getCertificationAuthorityReference().getBytes();
        byte[] osig = puk.getAuthenticatedRequest().getSignatureTLV().getBytes();
        int length = cvc.length + ocar.length + osig.length;
        ByteBuffer bb = new ByteBuffer(length);
        bb.append(cvc);
        bb.append(ocar);
        bb.append(osig);
        if (length > this.maxCData) {
            this.write(new CardFilePath(":2F10"), 0, bb.getBytes());
        }
        CommandAPDU com = new CommandAPDU(9 + length);
        com.append((byte)-128);
        com.append((byte)98);
        com.append(keyId);
        com.append((byte)-124);
        if (length <= this.maxCData) {
            com.append((byte)0);
            com.append((byte)(length >> 8));
            com.append((byte)length);
            com.append(bb.getBytes());
            com.append((byte)0);
            com.append((byte)0);
        } else {
            com.append((byte)0);
        }
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("DERIVE XKEK", rsp.sw());
        }
    }

    public byte[] importPublicKey(CardVerifiableCertificate cert) throws CardTerminalException, CardServiceException {
        byte[] cvc = cert.getCVCertificate().getBytes();
        byte[] ocar = cert.getOuterCertificationAuthorityReference().getBytes();
        byte[] osig = cert.getCVCertificate().getSignatureTLV().getBytes();
        int length = cvc.length + ocar.length + osig.length;
        ByteBuffer bb = new ByteBuffer(length);
        bb.append(cvc);
        bb.append(ocar);
        bb.append(osig);
        if (length > this.maxCData) {
            this.write(new CardFilePath(":2F10"), 0, bb.getBytes());
        }
        CommandAPDU com = new CommandAPDU(9 + length);
        com.append((byte)-128);
        com.append((byte)84);
        com.append((byte)0);
        com.append((byte)0);
        if (length <= this.maxCData) {
            com.append((byte)0);
            com.append((byte)(length >> 8));
            com.append((byte)length);
            com.append(bb.getBytes());
            com.append((byte)0);
            com.append((byte)0);
        } else {
            com.append((byte)0);
        }
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("MANAGE PKA", rsp.sw());
        }
        return rsp.data();
    }

    public boolean externalAuthenticate(byte[] signature) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(9 + signature.length);
        com.append((byte)0);
        com.append((byte)-126);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)signature.length);
        com.append(signature);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() == 36864) {
            return true;
        }
        if (rsp.sw() == 25344) {
            return false;
        }
        throw new CardServiceUnexpectedStatusWordException("EXTERNAL AUTHENTICATE", rsp.sw());
    }

    public byte[] generalAuthenticate(byte[] data) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(100);
        com.append((byte)0);
        com.append((byte)-122);
        com.append((byte)0);
        com.append((byte)0);
        com.append((byte)data.length);
        com.append(data);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("GENERAL AUTHENTICATE", rsp.sw());
        }
        return rsp.data();
    }

    public byte[] deriveSymmetricKey(byte keyId, byte algo, byte[] data) throws CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(100);
        com.append((byte)-128);
        com.append((byte)120);
        com.append(keyId);
        com.append(algo);
        com.append((byte)data.length);
        com.append(data);
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            throw new CardServiceUnexpectedStatusWordException("DERIVE SYMMETRIC KEY", rsp.sw());
        }
        return rsp.data();
    }

    public Vector<String> getAliases() throws OpenCardException, CertificateException, TLVEncodingException {
        if (this.namemap.isEmpty()) {
            this.enumerateEntries();
        }
        Set<String> set = this.namemap.keySet();
        Vector<String> v = new Vector<String>(set);
        return v;
    }

    public void addKeyToMap(SmartCardHSMKey key) {
        key.setCardService(this);
        String label = key.getLabel();
        byte id = key.getKeyRef();
        SmartCardHSMEntry entry = this.namemap.get(label);
        if (entry == null) {
            entry = new SmartCardHSMEntry(key);
            this.namemap.put(label, entry);
        } else {
            entry.setKey(key);
        }
        this.idmap.put(id, key);
    }

    public void addCertToMap(Certificate cert, boolean isEECertificate, byte id, String label) {
        SmartCardHSMEntry entry = this.namemap.get(label);
        if (entry == null) {
            entry = new SmartCardHSMEntry(cert, isEECertificate, id);
            this.namemap.put(label, entry);
        } else {
            entry.setCert(cert, isEECertificate, id);
        }
    }

    public void removeEntry(String label) throws CardServiceException, CardTerminalException, CardIOException {
        SmartCardHSMEntry entry = this.namemap.get(label);
        if (entry == null) {
            throw new CardServiceResourceNotFoundException("Entry " + label + " not found.");
        }
        if (entry.isKeyEntry()) {
            byte keyID = entry.getKey().getKeyRef();
            this.delete(new CardFilePath(new byte[]{-52, keyID}));
            this.delete(new CardFilePath(new byte[]{-60, keyID}));
        }
        if (entry.isCertificateEntry()) {
            byte certID = entry.getId();
            if (entry.isEECertificate()) {
                this.delete(new CardFilePath(new byte[]{-50, certID}));
            } else {
                this.delete(new CardFilePath(new byte[]{-54, certID}));
                this.delete(new CardFilePath(new byte[]{-56, certID}));
            }
            this.certIDMap.remove(certID);
        }
        this.idmap.remove(entry.getId());
        this.namemap.remove(label);
    }

    public void renameEntry(String oldlabel, String newlabel) throws CardServiceResourceNotFoundException {
        SmartCardHSMEntry entry = this.namemap.get(oldlabel);
        if (entry == null) {
            throw new CardServiceResourceNotFoundException("Entry " + oldlabel + " not found.");
        }
        this.namemap.remove(oldlabel);
        this.namemap.put(newlabel, entry);
    }

    public boolean containsLabel(String label) throws OpenCardException {
        if (this.namemap.isEmpty()) {
            this.enumerateEntries();
        }
        return this.namemap.containsKey(label);
    }

    public SmartCardHSMEntry getSmartCardHSMEntry(String label) {
        try {
            if (this.namemap.isEmpty()) {
                this.enumerateEntries();
            }
        }
        catch (Exception e) {
            this.log.error("Inconsistent PKCS#15 structure: ", (Throwable)e);
            return null;
        }
        SmartCardHSMEntry entry = this.namemap.get(label);
        return entry;
    }

    public SmartCardHSMKey addKey(byte kid) throws OpenCardException {
        SmartCardHSMKey key;
        CardFilePath file = new CardFilePath(new byte[]{-60, kid});
        KeyDescription desc = null;
        try {
            byte[] descbin = this.read(file, 0, -1);
            desc = new KeyDescription(descbin);
            desc.setKeyRef(kid);
        }
        catch (Exception e) {
            this.log.debug("Error reading key description" + e.getMessage());
        }
        if (desc == null) {
            key = new SmartCardHSMKey(kid, "(" + kid + ")", 0);
        } else {
            switch (desc.getType()) {
                case RSA: {
                    key = new SmartCardHSMRSAKey(kid, desc.getTranslatedLabel(), (short)desc.getSize());
                    break;
                }
                case EC: {
                    key = new SmartCardHSMECKey(kid, desc.getTranslatedLabel(), (short)desc.getSize());
                    break;
                }
                case AES: {
                    key = new SmartCardHSMSecretKey(kid, desc.getTranslatedLabel(), (short)desc.getSize(), "AES");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown key type");
                }
            }
        }
        this.addKeyToMap(key);
        IsoFileControlInformation cfi = (IsoFileControlInformation)this.getFileInfo(new CardFilePath(new byte[]{-52, kid}));
        byte[] a5 = cfi.getProprietary();
        if (a5 != null) {
            key.processKeyInfo(this.keyDomains, a5);
        }
        this.idmap.put(kid, key);
        this.log.debug("Added key #" + kid + " " + key);
        file = new CardFilePath(new byte[]{-50, kid});
        try {
            PublicKey pk;
            Certificate cert;
            byte[] certBin = this.read(file, 0, -1);
            if (certBin[0] == 48) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(certBin);
                CertificateFactory cf = null;
                cf = CertificateFactory.getInstance("X.509");
                cert = cf.generateCertificate(inStream);
            } else {
                cert = new CardVerifiableCertificate(certBin);
            }
            if (key instanceof SmartCardHSMRSAKey) {
                pk = (RSAPublicKey)((Certificate)cert).getPublicKey();
                ((SmartCardHSMRSAKey)key).setModulus(pk.getModulus());
            }
            if (key instanceof SmartCardHSMECKey) {
                pk = (ECPublicKey)((Certificate)cert).getPublicKey();
                ((SmartCardHSMECKey)key).setParams(pk.getParams());
            }
            if (key instanceof SmartCardHSMPrivateKey && key.getKeySize() == -1) {
                ((SmartCardHSMPrivateKey)key).deriveKeySizeFromPublicKey(cert);
            }
            this.addCertToMap(cert, true, kid, key.getLabel());
        }
        catch (Exception e) {
            this.log.debug("Error reading and parsing certificate : " + e.getMessage());
        }
        return key;
    }

    private void enumerateEntries() throws OpenCardException {
        Certificate cert;
        int i;
        byte[] fobs = this.enumerateObjects();
        if (Arrays.equals(fobs, this.lastobjectlist)) {
            return;
        }
        this.lastobjectlist = fobs;
        if (this.keyDomains == null) {
            this.enumerateKeyDomains();
        }
        if (this.addDeviceCertificateToAliases) {
            try {
                byte[] certBin = this.read(new CardFilePath(":2F02"), 0, -1);
                CardVerifiableCertificate cert2 = new CardVerifiableCertificate(certBin);
                this.addCertToMap(cert2, true, (byte)0, "DeviceAuthenticationCertificate");
                int cvcofs = cert2.getEncoded().length;
                int cvclen = certBin.length - cvcofs;
                if (cvclen > 0) {
                    byte[] dicacert = new byte[cvclen];
                    System.arraycopy(certBin, cvcofs, dicacert, 0, cvclen);
                    cert2 = new CardVerifiableCertificate(dicacert);
                    this.addCertToMap(cert2, false, (byte)0, "DeviceIssuerCertificate");
                }
            }
            catch (CardServiceUnexpectedStatusWordException | CertificateException e) {
                this.log.error("Decode DevAut certificates", (Throwable)e);
                throw new CardServiceException("Decoding device certificate failed: " + e.getMessage());
            }
        }
        for (i = 0; i < fobs.length; i += 2) {
            if (fobs[i] != -52 || fobs[i + 1] == 0) continue;
            byte kid = fobs[i + 1];
            this.addKey(kid);
        }
        for (i = 0; i < fobs.length; i += 2) {
            if (fobs[i] != -54) continue;
            byte id = fobs[i + 1];
            this.caid.add(id);
            CardFilePath file = new CardFilePath(new byte[]{-54, id});
            byte[] certBin = this.read(file, 0, -1);
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(certBin);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(inStream);
                inStream.close();
                this.certIDMap.put(id, cert);
                continue;
            }
            catch (Exception e) {
                this.log.error("Parsing certificate", (Throwable)e);
            }
        }
        for (i = 0; i < fobs.length; i += 2) {
            if (fobs[i] != -56) continue;
            byte id = fobs[i + 1];
            CardFilePath file = new CardFilePath(new byte[]{-56, id});
            byte[] encLabel = this.read(file, 0, -1);
            CertificateDescription cd = new CertificateDescription();
            String label = "not found";
            try {
                label = cd.getLabel(encLabel);
            }
            catch (TLVEncodingException e) {
                this.log.error("Error parsing certificate description", (Throwable)e);
            }
            cert = this.certIDMap.get(id);
            if (cert == null) {
                throw new CardServiceException("No corresponding CA certificate for this certificate description found");
            }
            this.addCertToMap(cert, false, id, label);
        }
    }

    public byte determineFreeCAId() throws OpenCardException {
        if (this.namemap.isEmpty()) {
            this.enumerateEntries();
        }
        if (this.caid.isEmpty()) {
            return 0;
        }
        int id = (this.caid.lastElement() & 0xFF) + 1;
        if (id > 255) {
            return -1;
        }
        return (byte)id;
    }

    public byte determineFreeKeyId() throws OpenCardException {
        if (this.namemap.isEmpty()) {
            this.enumerateEntries();
        }
        for (int i = 1; i < 60; ++i) {
            if (this.idmap.get((byte)i) != null) continue;
            return (byte)i;
        }
        return -1;
    }

    public void storePRKD(byte kid, KeyDescription prkd) throws CardServiceException, CardTerminalException, CardIOException {
        this.write(new CardFilePath(new byte[]{-60, kid}), 0, prkd.getEncoded());
    }

    private void enumerateKeyDomains() throws OpenCardException {
        if (this.keyDomains == null) {
            this.keyDomains = new ArrayList();
        }
        byte kid = 0;
        while (true) {
            CommandAPDU com = new CommandAPDU(5);
            com.append((byte)-128);
            com.append((byte)82);
            com.append((byte)0);
            com.append(kid);
            com.append((byte)0);
            ResponseAPDU rsp = this.sendCommandAPDU(com);
            if (rsp.sw() == 27270 || rsp.sw1() == 109) {
                return;
            }
            KeyDomain kd = kid >= this.keyDomains.size() ? new KeyDomain(kid) : this.keyDomains.get(kid);
            kd.update(rsp.data());
            if (kid >= this.keyDomains.size()) {
                this.keyDomains.add(kd);
            }
            kid = (byte)(kid + 1);
        }
    }

    public List<KeyDomain> getKeyDomains() throws OpenCardException {
        this.enumerateKeyDomains();
        return this.keyDomains;
    }

    public boolean deleteKeyDomain(KeyDomain kd) throws OpenCardException {
        CommandAPDU com = new CommandAPDU(5);
        com.append((byte)-128);
        com.append((byte)82);
        com.append((byte)3);
        com.append(kd.getId());
        com.append((byte)0);
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        if (rsp.sw() != 36864) {
            return false;
        }
        kd.update(rsp.data());
        return true;
    }

    private CardChannel getChannel() {
        this.allocateCardChannel();
        return this.getCardChannel();
    }

    @Override
    public ResponseAPDU sendCommandAPDU(CardFilePath path, CommandAPDU com, int usageQualifier) throws CardServiceException, CardTerminalException {
        ResponseAPDU rsp = this.sendCommandAPDU(com);
        return rsp;
    }

    private CardVerifiableCertificate[] getCertificateChain() throws CardServiceException, CardTerminalException {
        CardVerifiableCertificate[] certs;
        CardVerifiableCertificate devAutCert;
        byte[] devAutEnc;
        byte[] certBytes = this.read(new CardFilePath(":2F02"), 0, -1);
        try {
            devAutEnc = new ConstructedTLV(certBytes).getBytes();
        }
        catch (TLVEncodingException e) {
            this.log.error("Parsing CVC", (Throwable)e);
            throw new CardServiceException("Unexptected TLV encoding error");
        }
        try {
            devAutCert = new CardVerifiableCertificate(devAutEnc);
        }
        catch (CertificateException e) {
            this.log.error("Parsing CVC", (Throwable)e);
            throw new CardServiceException("Unexptected CardVerifiableCertificate error");
        }
        if (devAutEnc.length == certBytes.length) {
            certs = new CardVerifiableCertificate[]{devAutCert};
        } else {
            CardVerifiableCertificate issuerCert;
            certs = new CardVerifiableCertificate[2];
            certs[0] = devAutCert;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(certBytes, devAutEnc.length, certBytes.length - devAutEnc.length);
            try {
                issuerCert = new CardVerifiableCertificate(bos.toByteArray());
            }
            catch (CertificateException e) {
                this.log.error("Parsing CVC", (Throwable)e);
                throw new CardServiceException("Unexpected CardVerifiableCertificate error");
            }
            certs[1] = issuerCert;
        }
        return certs;
    }

    public TrustStore getTrustStore() {
        if (TrustStore.isEmpty()) {
            try {
                CardVerifiableCertificate rootCVC = new CardVerifiableCertificate(rootCert);
                TrustStore.getInstance().addTrustedCertificate(rootCVC);
                rootCVC = new CardVerifiableCertificate(utCert);
                TrustStore.getInstance().addTrustedCertificate(rootCVC);
            }
            catch (CertificateException e) {
                this.log.error("Error adding default SRCA certificates to trust store", (Throwable)e);
            }
        }
        return TrustStore.getInstance();
    }

    public ECPublicKey getDevAutPK() throws CardServiceException, CardTerminalException, CertPathBuilderException {
        CardVerifiableCertificate[] certs = this.getCertificateChain();
        if (certs.length != 2) {
            throw new CardServiceException("Unsupported PKI structure");
        }
        CertificationAuthorityReference car = certs[1].getCertificationAuthorityReference();
        CardVerifiableCertificate rootCVC = this.getTrustStore().getTrustedCertificate(car);
        if (rootCVC == null) {
            throw new CertPathBuilderException("SRCA certificate for " + new String(car.getValue()) + " not found in trust store");
        }
        PublicKey rootPK = rootCVC.getPublicKey();
        try {
            certs[1].verify(rootPK);
            certs[0].verify(certs[1].getPublicKey());
            this.id = "/" + rootCVC.getCertificateHolderReference().getHolder() + "/" + certs[1].getCertificateHolderReference().getHolder() + "/" + certs[0].getCertificateHolderReference().getHolder();
        }
        catch (CertificateException e) {
            this.log.error("Verify certificate", (Throwable)e);
            throw new CardServiceException("The Device Authentication Certificate isn't valid.");
        }
        catch (InvalidKeyException e) {
            this.log.error("Verify certificate", (Throwable)e);
            throw new CardServiceException("Unexpected InvalidKeyException");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Verify certificate", (Throwable)e);
            throw new CardServiceException("Unexpected NoSuchAlgorithmException");
        }
        catch (NoSuchProviderException e) {
            this.log.error("Verify certificate", (Throwable)e);
            throw new CardServiceException("Unexpected NoSuchProviderException");
        }
        catch (SignatureException e) {
            e.printStackTrace();
            this.log.error("Verify certificate", (Throwable)e);
            throw new CardServiceException("Unexpected SignatureException");
        }
        return (ECPublicKey)certs[0].getPublicKey();
    }

    @Override
    public void update(String url, String sessionId, RemoteNotificationListener notificationListener) throws CardServiceException {
        boolean smactive = this.state.getSecureChannelCredential() != null;
        this.remoteClient = new RemoteClient(this, url, sessionId, this.connectionFactory);
        this.remoteClient.update(notificationListener);
        this.remoteClient = null;
        if (smactive) {
            try {
                this.initSecureMessaging();
            }
            catch (CertPathBuilderException | CardTerminalException cte) {
                throw new CardServiceException("Could not reestablish secure channel");
            }
        }
    }

    @Override
    public void cancel() {
        if (this.remoteClient != null) {
            this.remoteClient.cancel();
            this.remoteClient = null;
        }
    }

    @Override
    public void setHttpURLConnectionFactory(HttpURLConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    static {
        HashMap<String, Byte> v15 = new HashMap<String, Byte>();
        v15.put("SHA1withRSA", (byte)49);
        v15.put("SHA256withRSA", (byte)51);
        HashMap<String, Byte> pss = new HashMap<String, Byte>();
        pss.put("NONEwithRSA", (byte)64);
        pss.put("SHA1withRSA", (byte)65);
        pss.put("SHA256withRSA", (byte)67);
        HashMap<String, Byte> none = new HashMap<String, Byte>();
        none.put("NONEwithRSA", (byte)32);
        none.put("NONEwithECDSA", (byte)112);
        none.put("SHA1withECDSA", (byte)113);
        none.put("SHA224withECDSA", (byte)114);
        none.put("SHA256withECDSA", (byte)115);
        none.put("DEFAULT_ALGORITHM", (byte)-96);
        HashMap<String, Byte> defaultAlg = new HashMap<String, Byte>();
        defaultAlg.put("SHA1withRSA", (byte)49);
        defaultAlg.put("SHA256withRSA", (byte)51);
        defaultAlg.put("NONEwithRSA", (byte)32);
        defaultAlg.put("NONEwithECDSA", (byte)112);
        defaultAlg.put("SHA1withECDSA", (byte)113);
        defaultAlg.put("SHA224withECDSA", (byte)114);
        defaultAlg.put("SHA256withECDSA", (byte)115);
        defaultAlg.put("DEFAULT_ALGORITHM", (byte)-96);
        ALGORITHM_PADDING.put("PKCS1_V15", v15);
        ALGORITHM_PADDING.put(ALGO_PADDING_PKCS1_PSS, pss);
        ALGORITHM_PADDING.put("NONE", none);
        ALGORITHM_PADDING.put("DEFAULT", defaultAlg);
    }
}

