/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.service.isocard.IsoCommandAPDU;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class GPSCP03SecureChannel
implements SecureChannel {
    public static final byte PSEUDO_RANDOM_CARD_CHALLENGE = 16;
    public static final byte RESPONSE_MAC_ENC_MASK = 96;
    public static final byte RESPONSE_NO_ENC_NO_MAC = 0;
    public static final byte RESPONSE_NO_ENC_BUT_MAC = 32;
    public static final byte RESPONSE_ENC_AND_MAC = 96;
    public static final byte NONE = 0;
    public static final byte C_MAC = 1;
    public static final byte C_ENC = 2;
    public static final byte R_MAC = 16;
    public static final byte R_ENC = 32;
    protected String provider;
    private Key senc;
    private Key smac;
    private Key srmac;
    private Key dek;
    private byte[] chain = new byte[16];
    private byte securitylevel = 0;
    private int enccnt = 1;
    private Mac cmac = null;
    private Cipher aesecb = null;
    private Cipher aescbc = null;

    public GPSCP03SecureChannel(Key senc, Key smac, Key srmac, Key dek, byte[] chain, byte securityLevel, String provider) throws GeneralSecurityException {
        this.provider = provider;
        this.senc = senc;
        this.smac = smac;
        this.srmac = srmac;
        this.dek = dek;
        this.chain = chain;
        this.securitylevel = securityLevel;
        this.cmac = Mac.getInstance("AESCMAC", provider);
        this.aesecb = Cipher.getInstance("AES/ECB/NoPadding", provider);
        this.aescbc = Cipher.getInstance("AES/CBC/NoPadding", provider);
    }

    private byte[] isoPadding(byte[] input) {
        int paddedLength = (input.length & 0xFFF0) + 16;
        byte[] padded = new byte[paddedLength];
        System.arraycopy(input, 0, padded, 0, input.length);
        padded[input.length] = -128;
        return padded;
    }

    private IvParameterSpec calcIV(boolean forWrap) throws GeneralSecurityException {
        byte[] input = new byte[16];
        if (!forWrap) {
            input[0] = -128;
        }
        byte[] c = BigInteger.valueOf(this.enccnt).toByteArray();
        System.arraycopy(c, 0, input, input.length - c.length, c.length);
        this.aesecb.init(1, this.senc);
        byte[] iv = this.aesecb.doFinal(input);
        return new IvParameterSpec(iv);
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU apduToUnwrap, int usageQualifier) {
        if ((this.securitylevel & 0x10) == 16 && apduToUnwrap.getLength() > 2) {
            byte[] macStripped;
            byte[] mac;
            try {
                this.cmac.init(this.srmac);
                this.cmac.update(this.chain);
                this.cmac.update(apduToUnwrap.getBuffer(), 0, apduToUnwrap.getLength() - 10);
                this.cmac.update(apduToUnwrap.getBuffer(), apduToUnwrap.getLength() - 2, 2);
                mac = this.cmac.doFinal();
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException("MAC calculation failed : " + e.getMessage());
            }
            if (Arrays.compare(mac, 0, 8, apduToUnwrap.getBuffer(), apduToUnwrap.getLength() - 10, apduToUnwrap.getLength() - 2) != 0) {
                throw new CardServiceInvalidParameterException("MAC verification failed");
            }
            if ((this.securitylevel & 0x20) == 32 && apduToUnwrap.getLength() > 10) {
                try {
                    int i;
                    this.aescbc.init(2, this.senc, this.calcIV(false));
                    byte[] plain = this.aescbc.update(apduToUnwrap.getBuffer(), 0, apduToUnwrap.getLength() - 10);
                    this.aescbc.doFinal();
                    for (i = plain.length - 1; i > 0 && plain[i] == 0; --i) {
                    }
                    if (plain[i] != -128) {
                        throw new CardServiceInvalidCredentialException("Invalid padding in enciphered block");
                    }
                    macStripped = new byte[i + 2];
                    System.arraycopy(plain, 0, macStripped, 0, i);
                    System.arraycopy(apduToUnwrap.getBuffer(), apduToUnwrap.getLength() - 2, macStripped, i, 2);
                }
                catch (Exception e) {
                    throw new CardServiceInvalidParameterException(e.getMessage());
                }
            } else {
                macStripped = new byte[apduToUnwrap.getLength() - 8];
                System.arraycopy(apduToUnwrap.getBuffer(), 0, macStripped, 0, apduToUnwrap.getLength() - 10);
                System.arraycopy(apduToUnwrap.getBuffer(), apduToUnwrap.getLength() - 2, macStripped, apduToUnwrap.getLength() - 10, 2);
            }
            apduToUnwrap = new ResponseAPDU(macStripped);
        }
        ++this.enccnt;
        return apduToUnwrap;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU apduToWrap, int usageQualifier) {
        if ((this.securitylevel & 3) == 0) {
            return apduToWrap;
        }
        int le = -1;
        byte[] body = new byte[]{};
        boolean extended = false;
        int l = apduToWrap.getLength() - 4;
        if (l > 0) {
            int n;
            int i = 4;
            if ((n = apduToWrap.getByte(i++)) == 0 && --l > 0) {
                extended = true;
                if (l < 2) {
                    throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                }
                n = (apduToWrap.getByte(i) << 8) + apduToWrap.getByte(i + 1);
                i += 2;
                l -= 2;
            }
            if (l > 0) {
                if (l < n) {
                    throw new CardServiceInvalidParameterException("Invalid Lc in APDU");
                }
                body = new byte[n];
                System.arraycopy(apduToWrap.getBuffer(), i, body, 0, n);
                i += n;
                if ((l -= n) > 0) {
                    le = apduToWrap.getByte(i++);
                    --l;
                    if (extended) {
                        if (l < 1) {
                            throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                        }
                        le = (le << 8) + apduToWrap.getByte(i++);
                        --l;
                    }
                }
            } else {
                le = n == 0 ? (extended ? 65536 : 256) : n;
            }
            if (l > 0) {
                throw new CardServiceInvalidParameterException("Unexpected bytes in APDU");
            }
        }
        if (body.length > 0 && (this.securitylevel & 2) == 2) {
            try {
                this.aescbc.init(1, this.senc, this.calcIV(true));
                body = this.aescbc.doFinal(this.isoPadding(body));
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException(e.getMessage());
            }
        }
        if (body.length + 8 >= 256) {
            extended = true;
        }
        byte[] macInput = new byte[4 + (extended ? 3 : 1)];
        int i = 0;
        macInput[i++] = (byte)(apduToWrap.getByte(0) | 4);
        macInput[i++] = (byte)apduToWrap.getByte(1);
        macInput[i++] = (byte)apduToWrap.getByte(2);
        macInput[i++] = (byte)apduToWrap.getByte(3);
        if (extended) {
            macInput[i++] = 0;
            macInput[i++] = (byte)(body.length + 8 >> 8);
        }
        macInput[i++] = (byte)(body.length + 8);
        try {
            this.cmac.init(this.smac);
            this.cmac.update(this.chain);
            this.cmac.update(macInput);
            this.chain = this.cmac.doFinal(body);
        }
        catch (Exception e) {
            throw new CardServiceInvalidParameterException("MAC calculation failed : " + e.getMessage());
        }
        byte[] bodyWithMac = new byte[body.length + 8];
        System.arraycopy(body, 0, bodyWithMac, 0, body.length);
        System.arraycopy(this.chain, 0, bodyWithMac, body.length, 8);
        IsoCommandAPDU patchedApdu = new IsoCommandAPDU((byte)(apduToWrap.getByte(0) | 4), (byte)apduToWrap.getByte(1), (byte)apduToWrap.getByte(2), (byte)apduToWrap.getByte(3), bodyWithMac, le);
        patchedApdu.setQueueable(apduToWrap.isQueueable());
        return patchedApdu;
    }

    public static boolean scpOptionsSupported(byte options) {
        return true;
    }
}

