/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;

public class EMSAPSSEncoder {
    private Random rng = new SecureRandom();
    private MessageDigest digest;
    private MGF1 mgf1;
    byte[] mHash;
    private int sLen = 0;
    public byte[] salt;
    private int hLen = 0;
    private int keySize;
    private static final byte TRAILER = -68;

    public EMSAPSSEncoder(MessageDigest digest, int keySizeInBits) {
        this.hLen = digest.getDigestLength();
        this.digest = digest;
        this.mHash = new byte[8 + this.hLen];
        this.sLen = this.hLen;
        this.salt = new byte[this.sLen];
        this.mgf1 = new MGF1(digest);
        this.rng.nextBytes(this.salt);
        this.keySize = keySizeInBits - 1;
    }

    public byte[] encode(byte[] hash) throws IOException {
        byte[] H;
        short emLen = (short)((short)(this.keySize + 7) >>> 3);
        System.arraycopy(hash, 0, this.mHash, 8, hash.length);
        if (this.sLen > 0) {
            this.digest.update(this.mHash, 0, (short)this.mHash.length);
            this.digest.update(this.salt, 0, this.sLen);
            H = this.digest.digest();
        } else {
            this.digest.update(this.mHash, 0, (short)this.mHash.length);
            H = this.digest.digest();
        }
        short maskLen = (short)(emLen - H.length - 1);
        byte[] DB = new byte[maskLen];
        DB[(short)(maskLen - H.length - 1)] = 1;
        if (this.sLen > 0) {
            System.arraycopy(this.salt, 0, DB, (short)(maskLen - H.length), H.length);
        }
        byte[] mask = this.mgf1.createMaskBuffer(H, maskLen);
        for (short i = 0; i < maskLen; i = (short)(i + 1)) {
            short s = i;
            DB[s] = (byte)(DB[s] ^ mask[i]);
        }
        int bitmask = 255;
        bitmask = (short)(bitmask >>> (short)(emLen << 3) - this.keySize);
        DB[0] = (byte)(DB[0] & (byte)(bitmask & 0xFFFFFFFF));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(DB);
        bos.write(H);
        bos.write(-68);
        return bos.toByteArray();
    }

    private class MGF1 {
        MessageDigest digest;
        int hLen;

        private MGF1(MessageDigest digest) {
            this.digest = digest;
            this.hLen = digest.getDigestLength();
        }

        public byte[] createMaskBuffer(byte[] mgfSeed, short maskLen) throws IOException {
            byte[] tempBuffer;
            byte[] C = new byte[4];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(maskLen);
            C[0] = 0;
            C[1] = 0;
            C[2] = 0;
            C[3] = 0;
            this.digest.reset();
            short counter = -1;
            short boundary = (short)((short)(maskLen << 3) + 7);
            boundary = (short)(boundary / (short)(this.hLen << 3));
            while (++counter < boundary) {
                C[0] = (byte)(counter >>> 24);
                C[1] = (byte)(counter >>> 16);
                C[2] = (byte)(counter >>> 8);
                C[3] = (byte)counter;
                if (mgfSeed != null && mgfSeed.length > 0) {
                    this.digest.update(mgfSeed, 0, mgfSeed.length);
                }
                this.digest.update(C, 0, 4);
                tempBuffer = this.digest.digest();
                bos.write(tempBuffer);
            }
            boundary = (short)(maskLen - counter * this.hLen);
            if (boundary > 0) {
                C[0] = (byte)(counter >>> 24);
                C[1] = (byte)(counter >>> 16);
                C[2] = (byte)(counter >>> 8);
                C[3] = (byte)counter;
                if (mgfSeed != null && mgfSeed.length > 0) {
                    this.digest.update(mgfSeed, 0, mgfSeed.length);
                }
                this.digest.update(C, 0, 4);
                tempBuffer = this.digest.digest();
                bos.write(tempBuffer, 0, boundary);
            }
            return bos.toByteArray();
        }
    }
}

