/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class CertificationAuthorityReference
extends PublicKeyReference {
    static final Tag TAG = new Tag(2, 64, false);
    static final String NAME = "Certification Authority Reference";

    public CertificationAuthorityReference(String car) {
        super(TAG, null);
        if (car == null || car.length() < 8 || car.length() > 16) {
            throw new IllegalArgumentException("Certification Authority Reference must be at least 8 and at maximum 16 char long");
        }
        this.value = car.getBytes();
        this.setName(NAME);
    }

    public CertificationAuthorityReference(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certification Authority Reference with wrong tag " + tlv.getTag());
        }
        this.setName(NAME);
    }
}

