/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.lang.reflect.Array;
import java.util.Vector;
import opencard.core.terminal.CardID;
import opencard.opt.security.CredentialStore;

public class CredentialBag {
    protected Vector credentialBag = new Vector();

    public void addCredentialStore(CredentialStore credstore) {
        if (credstore != null && !this.credentialBag.contains(credstore)) {
            this.credentialBag.addElement(credstore);
        }
    }

    public final CredentialStore getCredentialStore(CardID cardID, Class clazz) {
        if (clazz == null) {
            clazz = CredentialStore.class;
        }
        CredentialStore store = null;
        int size = this.credentialBag.size();
        for (int i = 0; store == null && i < size; ++i) {
            CredentialStore cs = (CredentialStore)this.credentialBag.elementAt(i);
            if (!clazz.isInstance(cs) || !cs.supports(cardID)) continue;
            store = cs;
        }
        return store;
    }

    public final CredentialStore[] getCredentialStores(CardID cardID, Class clazz) {
        if (clazz == null) {
            clazz = CredentialStore.class;
        }
        int size = this.credentialBag.size();
        CredentialStore[] csa = new CredentialStore[size];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            CredentialStore cs = (CredentialStore)this.credentialBag.elementAt(i);
            if (!clazz.isInstance(cs) || !cs.supports(cardID)) continue;
            csa[count++] = cs;
        }
        CredentialStore[] stores = null;
        if (count > 0) {
            stores = (CredentialStore[])Array.newInstance(clazz, count);
            for (int i = 0; i < count; ++i) {
                stores[i] = csa[i];
            }
        }
        return stores;
    }
}

