/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.utils;

import de.cardcontact.tlv.HexString;
import java.io.PrintStream;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUFormatter;
import opencard.core.util.APDUTracer;

public class StreamingAPDUTracer
implements APDUTracer {
    PrintStream stream = null;

    public StreamingAPDUTracer(PrintStream stream) {
        this.stream = stream;
    }

    @Override
    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        int slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
        String s = HexString.hexifyByte(slotId);
        s = s.concat(" ");
        s = s.concat(APDUFormatter.commandAPDUToString(capdu));
        this.stream.println(s);
    }

    @Override
    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        String s = APDUFormatter.responseAPDUToString(rapdu);
        this.stream.println(s);
    }

    @Override
    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        this.stream.println(" ATR: " + HexString.hexifyByteArray(cardID.getATR()));
    }
}

