/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.Tag;
import java.security.spec.KeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartCardHSMKeySpec
implements KeySpec {
    Logger logger = LoggerFactory.getLogger(SmartCardHSMKeySpec.class);
    private long keyUseCounter = -1L;
    private byte[] algorithmList;
    private KeyDomain keyDomain = null;

    public boolean hasKeyUseCounter() {
        return this.keyUseCounter != -1L;
    }

    public void setKeyUseCounter(int counter) {
        this.keyUseCounter = counter;
    }

    public long getKeyUseCounter() {
        return this.keyUseCounter;
    }

    public boolean hasAlgorithmList() {
        return this.algorithmList != null;
    }

    public void setAlgorithmList(byte[] list) {
        this.algorithmList = list;
    }

    public byte[] getAlgorithmList() {
        return this.algorithmList;
    }

    public boolean hasKeyDomain() {
        return this.keyDomain != null;
    }

    public void setKeyDomain(KeyDomain keyDomain) {
        this.keyDomain = keyDomain;
    }

    public KeyDomain getKeyDomain() {
        return this.keyDomain;
    }

    protected void encodeSpecParams(Sequence cdata) {
    }

    protected void encodeKeyParams(Sequence cdata) {
        if (this.hasKeyUseCounter()) {
            byte[] bytes = new byte[]{(byte)((this.keyUseCounter & 0xFFFFFFFFFF000000L) >> 24), (byte)((this.keyUseCounter & 0xFF0000L) >> 16), (byte)((this.keyUseCounter & 0xFF00L) >> 8), (byte)(this.keyUseCounter & 0xFFL)};
            cdata.add(new PrimitiveTLV(new Tag(16, -128, false), bytes));
        }
        if (this.hasAlgorithmList()) {
            cdata.add(new PrimitiveTLV(new Tag(17, -128, false), this.getAlgorithmList()));
        }
        if (this.hasKeyDomain()) {
            cdata.add(new PrimitiveTLV(new Tag(18, -128, false), new byte[]{this.getKeyDomain().getId()}));
        }
    }

    public byte[] getCData() {
        Sequence cdata = new Sequence();
        this.encodeSpecParams(cdata);
        this.encodeKeyParams(cdata);
        this.logger.debug(cdata.dump());
        return cdata.getValue();
    }
}

