/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;

public class IntegerTLV
extends PrimitiveTLV {
    public IntegerTLV(long val) {
        super(new Tag(2, 0, false), null);
        long v = val >= 0L ? val : val ^ 0xFFFFFFFFFFFFFFFFL;
        int l = 1;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            v >>= 8;
            ++l;
        }
        this.value = new byte[l];
        v = val;
        --l;
        while (l >= 0) {
            this.value[l] = (byte)(v & 0xFFL);
            v >>= 8;
            --l;
        }
    }

    public IntegerTLV(BigInteger bi) {
        super(new Tag(2, 0, false), null);
        this.value = bi.toByteArray();
    }

    public IntegerTLV(ParseBuffer pb) throws TLVEncodingException {
        super(pb);
    }

    public IntegerTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
    }

    public static IntegerTLV getInstance(TLV tlv, Tag et) throws TLVEncodingException {
        if (!tlv.getTag().equals(et)) {
            throw new TLVEncodingException("Tag must be " + et);
        }
        if (tlv instanceof IntegerTLV) {
            return (IntegerTLV)tlv;
        }
        return new IntegerTLV(tlv);
    }

    public static IntegerTLV getInstance(TLV tlv) throws TLVEncodingException {
        return IntegerTLV.getInstance(tlv, Tag.TAG_INTEGER);
    }

    public BigInteger getBigInteger() {
        return new BigInteger(this.value);
    }

    public long getLong() {
        if (this.value.length > 8) {
            throw new UnsupportedOperationException("Byte array out of range");
        }
        long v = this.value[0] < 0 ? -1L : 0L;
        for (int i = 0; i < this.value.length; ++i) {
            v = v << 8 & 0xFFFFFFFFFFFFFF00L | (long)(this.value[i] & 0xFF);
        }
        return v;
    }
}

