/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.smartcardio;

import de.cardcontact.opencard.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;

public class PCSCIOControl {
    private static final byte FEATURE_VERIFY_PIN_DIRECT = 6;
    private static final byte FEATURE_MODIFY_PIN_DIRECT = 7;
    private static final byte FEATURE_EXECUTE_PACE = 32;
    private Card card;
    private byte timeOut = (byte)48;
    private byte timeOut2 = (byte)48;
    private byte formatString = (byte)-119;
    private byte pinBlockString = (byte)71;
    private byte pinLengthFormat = (byte)4;
    private byte maxPINSize = (byte)8;
    private byte minPINSize = (byte)4;
    private byte confirmPIN = 1;
    private byte entryValidationCondition = (byte)2;
    private byte numberMessage = 1;
    private byte langId = (byte)19;
    private byte langId2 = (byte)8;
    private byte msgIndex = 0;
    private byte msgIndex2 = 1;
    private byte msgIndex3 = (byte)2;
    private byte teoPrologue = 0;
    private byte teoPrologue2 = 0;
    private byte teoPrologue3 = 0;
    private byte insertionOffsetOld = 0;
    private byte insertionOffsetNew = 0;

    public PCSCIOControl(Card card) {
        this.card = card;
    }

    public void setPinEncoding(String encoding) throws CardTerminalException {
        if (encoding.equals("Format 2 Block")) {
            this.formatString = (byte)-119;
            this.pinBlockString = (byte)71;
            this.pinLengthFormat = (byte)4;
        } else if (encoding.equals("Packed BCD")) {
            this.formatString = (byte)-127;
            this.pinBlockString = 0;
            this.pinLengthFormat = 0;
        } else if (encoding.equals("String encoding")) {
            this.formatString = (byte)-126;
            this.pinBlockString = 0;
            this.pinLengthFormat = 0;
        } else {
            throw new CardTerminalException("Encoding: " + encoding + " is not supported.");
        }
    }

    public void setTimeOut(byte timeOut) {
        this.timeOut = timeOut;
    }

    public void setTimeOut2(byte timeOut2) {
        this.timeOut2 = timeOut2;
    }

    public void setFormatString(byte formatString) {
        this.formatString = formatString;
    }

    public void setPinBlockString(byte pinBlockString) {
        this.pinBlockString = pinBlockString;
    }

    public void setPinLengthFormat(byte pinLengthFormat) {
        this.pinLengthFormat = pinLengthFormat;
    }

    public void setMaxPINSize(byte maxPINSize) {
        this.maxPINSize = maxPINSize;
    }

    public void setMinPINSize(byte minPINSize) {
        this.minPINSize = minPINSize;
    }

    public void setConfirmPIN(byte confirmPIN) {
        this.confirmPIN = confirmPIN;
    }

    public void setEntryValidationCondition(byte entryValidationCondition) {
        this.entryValidationCondition = entryValidationCondition;
    }

    public void setNumberMessage(byte numberMessage) {
        this.numberMessage = numberMessage;
    }

    public void setLangId(byte langId) {
        this.langId = langId;
    }

    public void setLangId2(byte langId2) {
        this.langId2 = langId2;
    }

    public void setMsgIndex(byte msgIndex) {
        this.msgIndex = msgIndex;
    }

    public void setMsgIndex2(byte msgIndex2) {
        this.msgIndex2 = msgIndex2;
    }

    public void setMsgIndex3(byte msgIndex3) {
        this.msgIndex3 = msgIndex3;
    }

    public void setTeoPrologue(byte teoPrologue) {
        this.teoPrologue = teoPrologue;
    }

    public void setTeoPrologue2(byte teoPrologue2) {
        this.teoPrologue2 = teoPrologue2;
    }

    public void setTeoPrologue3(byte teoPrologue3) {
        this.teoPrologue3 = teoPrologue3;
    }

    public void setInsertionOffsetOld(byte insertionOffsetOld) {
        this.insertionOffsetOld = insertionOffsetOld;
    }

    public void setInsertionOffsetNew(byte insertionOffsetNew) {
        this.insertionOffsetNew = insertionOffsetNew;
    }

    public boolean hasVerifyPinDirect() {
        return this.getFeatureControlCode(6) != -1;
    }

    public boolean hasModifyPinDirect() {
        return this.getFeatureControlCode(7) != -1;
    }

    public boolean hasExecutePace() {
        return this.getFeatureControlCode(32) != -1;
    }

    public byte[] verifyPINDirect(CommandAPDU xcapdu) throws CardException {
        byte[] commandData = new byte[]{this.timeOut, this.timeOut2, this.formatString, this.pinBlockString, this.pinLengthFormat, this.maxPINSize, this.minPINSize, this.entryValidationCondition, this.numberMessage, this.langId, this.langId2, this.msgIndex, this.teoPrologue, this.teoPrologue2, this.teoPrologue3};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] commandBlock = null;
        int pcc = this.getFeatureControlCode(6);
        try {
            bos.write(commandData);
            bos.write((byte)xcapdu.getBytes().length);
            bos.write(0);
            bos.write(0);
            bos.write(0);
            bos.write(xcapdu.getBytes());
        }
        catch (IOException e) {
            throw new CardException("Error creating terminal command: " + e.getMessage());
        }
        commandBlock = bos.toByteArray();
        System.out.println(HexString.hexify(commandBlock));
        byte[] rsp = this.card.transmitControlCommand(pcc, commandBlock);
        return rsp;
    }

    public byte[] modifyPINDirect(CommandAPDU xcapdu) throws CardException {
        byte[] commandData = new byte[]{this.timeOut, this.timeOut2, this.formatString, this.pinBlockString, this.pinLengthFormat, this.insertionOffsetOld, this.insertionOffsetNew, this.maxPINSize, this.minPINSize, this.confirmPIN, this.entryValidationCondition, this.numberMessage, this.langId, this.langId2, this.msgIndex, this.msgIndex2, this.msgIndex3, this.teoPrologue, this.teoPrologue2, this.teoPrologue3};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] commandBlock = null;
        int pcc = this.getFeatureControlCode(7);
        try {
            bos.write(commandData);
            bos.write((byte)xcapdu.getBytes().length);
            bos.write(0);
            bos.write(0);
            bos.write(0);
            bos.write(xcapdu.getBytes());
        }
        catch (IOException e) {
            throw new CardException("Error creating terminal command: " + e.getMessage());
        }
        commandBlock = bos.toByteArray();
        byte[] rsp = this.card.transmitControlCommand(pcc, commandBlock);
        return rsp;
    }

    public int getFeatureControlCode(int feature) {
        byte[] features;
        int ioctl = 3224864;
        byte[] empty = new byte[]{};
        try {
            features = this.card.transmitControlCommand(ioctl, empty);
        }
        catch (CardException e) {
            return -1;
        }
        for (int i = 0; i < features.length; i += 6) {
            if (features[i] != feature) continue;
            int c = 0;
            i += 2;
            for (int l = 0; i < features.length && l < 4; ++i, ++l) {
                c <<= 8;
                c |= features[i] & 0xFF;
            }
            return c;
        }
        return -1;
    }

    public long getReadersPACECapabilities() throws CardException {
        int PACEControlCode = this.getFeatureControlCode(32);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        bos.write(0);
        bos.write(0);
        byte[] commandBlock = bos.toByteArray();
        byte[] rpc = this.card.transmitControlCommand(PACEControlCode, commandBlock);
        long result = Util.extractLongFromByteArray(rpc, 0, 4);
        if (result == 0L) {
            long outputData = Util.extractLongFromByteArray(rpc, 6, 1);
            return outputData;
        }
        return -1L;
    }

    public byte[] establishPACEChannel(int pinid, byte[] chat, byte[] pin, byte[] certdesc) throws CardException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(2);
        bos.write(0);
        bos.write(0);
        bos.write(pinid);
        if (chat != null) {
            bos.write(chat.length);
            bos.write(chat, 0, chat.length);
        } else {
            bos.write(0);
        }
        if (pin != null) {
            bos.write(pin.length);
            bos.write(pin, 0, pin.length);
        } else {
            bos.write(0);
        }
        if (certdesc != null) {
            bos.write((byte)(certdesc.length & 0xFF));
            bos.write((byte)(certdesc.length >> 8));
            bos.write(certdesc, 0, certdesc.length);
        } else {
            bos.write(0);
            bos.write(0);
        }
        int inputLength = bos.size() - 3;
        byte[] inputData = bos.toByteArray();
        inputData[1] = (byte)(inputLength & 0xFF);
        inputData[2] = (byte)(inputLength >> 8);
        int PACEControlCode = this.getFeatureControlCode(32);
        byte[] rpc = this.card.transmitControlCommand(PACEControlCode, inputData);
        long result = Util.extractLongFromByteArray(rpc, 0, 4);
        return rpc;
    }
}

