/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class CertificateHolderAuthorizationTemplate
extends ConstructedTLV {
    static final Tag TAG = new Tag(76, 64, true);
    static final String NAME = "Certificate Holder Authorization Template";
    static final Tag TAG_RA = new Tag(19, 64, false);
    public static final ObjectIdentifier ID_IS_OID = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 3, 1, 2, 1});
    public static final ObjectIdentifier ID_AT_OID = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 3, 1, 2, 2});
    public static final ObjectIdentifier ID_ST_OID = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 3, 1, 2, 3});
    public static final ObjectIdentifier ID_CC_ROLE_SC_HSM = new ObjectIdentifier(new int[]{1, 3, 6, 1, 4, 1, 24991, 3, 1, 1});

    public CertificateHolderAuthorizationTemplate(ObjectIdentifier oid, byte[] relativeAuthorization) {
        super(TAG);
        this.setName(NAME);
        this.add(oid);
        this.add(new PrimitiveTLV(TAG_RA, relativeAuthorization));
    }

    public CertificateHolderAuthorizationTemplate(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certificate Holder Authorization Template with wrong tag " + tlv.getTag());
        }
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("Certificate Holder Authorization Template must contain 2 elements");
        }
        TLV t = (TLV)this.childs.get(0);
        if (!(t instanceof ObjectIdentifier)) {
            throw new TLVEncodingException("Certificate Holder Authorization Template first element must be an Object Identifier");
        }
        t = (TLV)this.childs.get(1);
        if (!t.getTag().equals(TAG_RA)) {
            throw new TLVEncodingException("Relative authorization in Certificate Holder Authorization Template with wrong tag " + tlv.getTag());
        }
    }
}

