/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import java.util.HashSet;
import java.util.prefs.Preferences;

public class ClientProperties {
    private static ClientProperties instance;
    private Preferences preferences = Preferences.userRoot().node("OCFClient");
    private static final String KEY_READER = "reader";
    private static final String KEY_IGNORE = "ignore";
    private static final String KEY_SERVER_URL = "url";
    private static final String DELIMITER = " ; ";

    private ClientProperties() {
    }

    public static ClientProperties getClientProperties() {
        if (instance == null) {
            instance = new ClientProperties();
        }
        return instance;
    }

    private void save(String key, String value) {
        this.preferences.put(key, value);
    }

    public void saveReaderName(String reader) {
        this.preferences.put(KEY_READER, reader);
    }

    public String getReaderName() {
        return this.preferences.get(KEY_READER, "");
    }

    public void appendToIgnored(HashSet<String> reader) {
        HashSet<String> ignored = this.getIgnoredReader();
        String ignoreList = "";
        for (String r : reader) {
            if (ignored.contains(r)) continue;
            ignoreList = ignoreList + r + DELIMITER;
        }
        String propertyList = this.preferences.get(KEY_IGNORE, "");
        propertyList = propertyList + ignoreList;
        this.preferences.put(KEY_IGNORE, propertyList);
    }

    public HashSet<String> getIgnoredReader() {
        String[] ignored;
        HashSet<String> readerSet = new HashSet<String>();
        String readerList = this.preferences.get(KEY_IGNORE, null);
        if (readerList == null) {
            return readerSet;
        }
        for (String reader : ignored = readerList.split(DELIMITER)) {
            if (reader.equals("")) continue;
            readerSet.add(reader);
        }
        return readerSet;
    }

    public void saveIgnoredReader(HashSet<String> ignored) {
        String ignoreList = "";
        for (String r : ignored) {
            ignoreList = ignoreList + r + DELIMITER;
        }
        this.preferences.put(KEY_IGNORE, ignoreList);
    }

    public void saveServerURL(HashSet<String> urlSet) {
        String urlList = "";
        for (String url : urlSet) {
            urlList = urlList + url + DELIMITER;
        }
        this.preferences.put(KEY_SERVER_URL, urlList);
    }

    public void appendServerURL(String newUrl) {
        HashSet<String> urlSet = this.getServerURL();
        if (urlSet.contains(newUrl)) {
            return;
        }
        String list = "";
        for (String url : urlSet) {
            list = list + url + DELIMITER;
        }
        list = list + newUrl + DELIMITER;
        this.preferences.put(KEY_SERVER_URL, list);
    }

    public HashSet<String> getServerURL() {
        String[] approved;
        HashSet<String> urlSet = new HashSet<String>();
        String urlList = this.preferences.get(KEY_SERVER_URL, null);
        if (urlList == null) {
            return urlSet;
        }
        for (String url : approved = urlList.split(DELIMITER)) {
            if (url.equals("")) continue;
            urlSet.add(url);
        }
        return urlSet;
    }
}

