/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import java.util.Enumeration;
import java.util.HashSet;
import opencard.core.service.CardIDFilter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalRegistry;

public abstract class ReaderConfigurationModel
implements CardIDFilter {
    private String selectedTerminal;
    protected HashSet<String> ignored;

    public String getSelectedTerminal() {
        return this.selectedTerminal;
    }

    public void setSelectedTerminal(String terminal) {
        this.selectedTerminal = terminal;
    }

    public HashSet<String> getAllTerminals() {
        HashSet<String> all = this.getValidTerminals();
        all.addAll(this.ignored);
        return all;
    }

    public HashSet<String> getValidTerminals() {
        HashSet<String> valid = new HashSet<String>();
        Enumeration ctlist = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (ctlist.hasMoreElements()) {
            CardTerminal ct = (CardTerminal)ctlist.nextElement();
            String reader = ct.getName();
            if (this.ignored.contains(reader)) continue;
            valid.add(reader);
        }
        return valid;
    }

    public HashSet<String> getIgnoredTerminals() {
        return this.ignored;
    }

    public void setIgnoredTerminals(HashSet<String> ignored) {
        this.ignored = ignored;
    }

    public void ignoreTerminal(String terminal) {
        this.ignored.add(terminal);
    }

    public void approveTerminal(String terminal) {
        this.ignored.remove(terminal);
    }

    @Override
    public boolean isCandidate(CardID cardID) {
        CardTerminal terminal = cardID.getCardTerminal();
        String name = terminal.getName();
        if (this.ignored.contains(name)) {
            return false;
        }
        if (this.selectedTerminal == null) {
            return true;
        }
        return name.startsWith(this.selectedTerminal);
    }

    public abstract void saveSettings();

    public abstract void discardChanges();
}

