/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.remoteclient;

import de.cardcontact.opencard.service.remoteclient.RemoteCardSpec;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolUnit;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.GPTLV_Generic;
import de.cardcontact.tlv.NativeTLVList;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLVDataSizeException;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.TagSizeException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class RemoteProtocolScript {
    private static final int COMMAND_SCRIPTING_TEMPLATE = 170;
    private static final int COMMAND_APDU = 34;
    private static final int RESPONSE_SCRIPTING_TEMPLATE = 171;
    private static final int INITIATION_TEMPLATE = 232;
    private static final int EXECUTED_COMMANDS = 128;
    private static final int RESPONSE_APDU = 35;
    private static final int INTEGER = 2;
    private static final int UTF8String = 12;
    private static final int TTC = 195;
    private static final int RESET = 192;
    private static final int ATR = 192;
    private static final int MAXCAPDU = 193;
    private static final int MAXRAPDU = 194;
    private static final int NOTIFY = 224;
    private static final int CLOSE = 225;
    private static final int VERSION = 226;
    private int executedCommands = 0;
    private boolean closing = false;
    private ArrayList<RemoteProtocolUnit> rpus = new ArrayList(1);

    public void setClosing() {
        this.closing = true;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isEmpty() {
        return this.rpus.isEmpty();
    }

    public void setExecutedCommands(int executedCommands) {
        this.executedCommands = executedCommands;
    }

    public int getExecutedCommands() {
        return this.executedCommands;
    }

    public void add(RemoteProtocolUnit rpu) {
        this.rpus.add(rpu);
    }

    public List<RemoteProtocolUnit> getRemoteProtocolUnits() {
        return this.rpus;
    }

    private RemoteProtocolUnit decodeRPU(RemoteProtocolUnit.Action action, byte[] rpu) throws TLVEncodingException {
        int id = 0;
        int ttc = 0;
        String str = null;
        try {
            NativeTLVList list = new NativeTLVList(rpu);
            block9: for (int i = 0; i < list.getLength(); ++i) {
                GPTLV_Generic rpuenc = list.get(i);
                switch (rpuenc.getTag()) {
                    case 2: {
                        id = new BigInteger(rpuenc.getValue()).intValue();
                        continue block9;
                    }
                    case 12: {
                        str = new String(rpuenc.getValue(), "UTF-8");
                        continue block9;
                    }
                    case 195: {
                        ttc = new BigInteger(rpuenc.getValue()).intValue();
                    }
                }
            }
        }
        catch (TagSizeException e) {
            throw new TLVEncodingException();
        }
        catch (TLVDataSizeException e) {
            throw new TLVEncodingException();
        }
        catch (UnsupportedEncodingException e) {
            throw new TLVEncodingException();
        }
        return new RemoteProtocolUnit(action, id, str, ttc);
    }

    public byte[] encodeCommandScriptingTemplate() {
        ConstructedTLV cst;
        try {
            cst = new ConstructedTLV(170);
            for (RemoteProtocolUnit rpu : this.rpus) {
                switch (rpu.getAction()) {
                    case APDU: {
                        CommandAPDU com = (CommandAPDU)rpu.getPayload();
                        cst.add(new PrimitiveTLV(34, com.getBytes()));
                        break;
                    }
                    case RESET: {
                        cst.add(new PrimitiveTLV(192, new byte[0]));
                        break;
                    }
                    case NOTIFY: {
                        ConstructedTLV notify = new ConstructedTLV(224);
                        notify.add(new PrimitiveTLV(2, BigInteger.valueOf(rpu.getId()).toByteArray()));
                        notify.add(new PrimitiveTLV(12, rpu.getMessage().getBytes("UTF-8")));
                        if (rpu.getTimeToCompletion() > 0) {
                            notify.add(new PrimitiveTLV(195, BigInteger.valueOf(rpu.getTimeToCompletion()).toByteArray()));
                        }
                        cst.add(notify);
                        break;
                    }
                    case CLOSE: {
                        ConstructedTLV closemsg = new ConstructedTLV(225);
                        closemsg.add(new PrimitiveTLV(12, rpu.getMessage().getBytes("UTF-8")));
                        cst.add(closemsg);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return cst.getBytes();
    }

    public void decodeCommandScriptingTemplate(byte[] cst) throws TLVEncodingException {
        try {
            NativeTLVList list = new NativeTLVList(cst);
            GPTLV_Generic csttlv = list.get(0);
            if (csttlv.getTag() != 170) {
                throw new TLVEncodingException("Expected tag 'AA' in Command Scripting Template");
            }
            list = new NativeTLVList(csttlv.getValue());
            block9: for (int i = 0; i < list.getLength(); ++i) {
                GPTLV_Generic rpuenc = list.get(i);
                switch (rpuenc.getTag()) {
                    case 34: {
                        CommandAPDU apdu = new CommandAPDU(rpuenc.getValue());
                        this.rpus.add(new RemoteProtocolUnit(apdu));
                        continue block9;
                    }
                    case 192: {
                        this.rpus.add(new RemoteProtocolUnit(RemoteProtocolUnit.Action.RESET));
                        continue block9;
                    }
                    case 224: {
                        this.rpus.add(this.decodeRPU(RemoteProtocolUnit.Action.NOTIFY, rpuenc.getValue()));
                        continue block9;
                    }
                    case 225: {
                        this.rpus.add(this.decodeRPU(RemoteProtocolUnit.Action.CLOSE, rpuenc.getValue()));
                    }
                }
            }
        }
        catch (TagSizeException e) {
            throw new TLVEncodingException();
        }
        catch (TLVDataSizeException e) {
            throw new TLVEncodingException();
        }
    }

    public byte[] encodeResponseScriptingTemplate() {
        ConstructedTLV cst;
        try {
            cst = new ConstructedTLV(171);
            for (RemoteProtocolUnit rpu : this.rpus) {
                switch (rpu.getAction()) {
                    case APDU: {
                        ResponseAPDU com = (ResponseAPDU)rpu.getPayload();
                        cst.add(new PrimitiveTLV(35, com.getBytes()));
                        break;
                    }
                    case RESET: {
                        cst.add(new PrimitiveTLV(192, ((RemoteCardSpec)rpu.getPayload()).getCardID().getATR()));
                        break;
                    }
                    case CLOSE: {
                        ConstructedTLV closemsg = new ConstructedTLV(225);
                        closemsg.add(new PrimitiveTLV(12, rpu.getMessage().getBytes("UTF-8")));
                        cst.add(closemsg);
                    }
                }
            }
            cst.add(new PrimitiveTLV(128, new byte[]{(byte)this.executedCommands}));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return cst.getBytes();
    }

    public void decodeResponseScriptingTemplate(byte[] cst) throws TLVEncodingException {
        try {
            NativeTLVList list = new NativeTLVList(cst);
            GPTLV_Generic csttlv = list.get(0);
            if (csttlv.getTag() != 171) {
                throw new TLVEncodingException("Expected tag 'AB' in Response Scripting Template");
            }
            list = new NativeTLVList(csttlv.getValue());
            block10: for (int i = 0; i < list.getLength(); ++i) {
                GPTLV_Generic rpuenc = list.get(i);
                switch (rpuenc.getTag()) {
                    case 35: {
                        ResponseAPDU apdu = new ResponseAPDU(rpuenc.getValue());
                        this.rpus.add(new RemoteProtocolUnit(apdu));
                        continue block10;
                    }
                    case 128: {
                        this.executedCommands = rpuenc.getValue()[0] & 0xFF;
                        continue block10;
                    }
                    case 192: {
                        CardID cardid = new CardID(rpuenc.getValue());
                        this.rpus.add(new RemoteProtocolUnit(new RemoteCardSpec(cardid)));
                        continue block10;
                    }
                    case 225: {
                        this.rpus.add(this.decodeRPU(RemoteProtocolUnit.Action.CLOSE, rpuenc.getValue()));
                    }
                }
            }
        }
        catch (TagSizeException e) {
            throw new TLVEncodingException();
        }
        catch (CardTerminalException e) {
            throw new TLVEncodingException();
        }
        catch (TLVDataSizeException e) {
            throw new TLVEncodingException();
        }
    }

    public byte[] encodeInitiationTemplate() {
        ConstructedTLV pit;
        try {
            pit = new ConstructedTLV(232);
            for (RemoteProtocolUnit rpu : this.rpus) {
                switch (rpu.getAction()) {
                    case RESET: {
                        int i;
                        RemoteCardSpec rcs = (RemoteCardSpec)rpu.getPayload();
                        CardID cardId = rcs.getCardID();
                        pit.add(new PrimitiveTLV(192, cardId.getATR()));
                        Properties features = cardId.getCardTerminal().features();
                        if (features.containsKey("maxCAPDUSize")) {
                            i = Integer.parseInt(features.getProperty("maxCAPDUSize"));
                            pit.add(new PrimitiveTLV(193, BigInteger.valueOf(i).toByteArray()));
                        }
                        if (!features.containsKey("maxRAPDUSize")) break;
                        i = Integer.parseInt(features.getProperty("maxRAPDUSize"));
                        pit.add(new PrimitiveTLV(194, BigInteger.valueOf(i).toByteArray()));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pit.getBytes();
    }

    public void decodeInitiationTemplate(byte[] pit) throws TLVEncodingException {
        try {
            NativeTLVList list = new NativeTLVList(pit);
            GPTLV_Generic pittlv = list.get(0);
            if (pittlv.getTag() != 232) {
                throw new TLVEncodingException("Expected tag 'E8' in Initiation Template");
            }
            list = new NativeTLVList(pittlv.getValue());
            RemoteCardSpec rcs = null;
            block9: for (int i = 0; i < list.getLength(); ++i) {
                GPTLV_Generic rpuenc = list.get(i);
                switch (rpuenc.getTag()) {
                    case 192: {
                        CardID cardid = new CardID(rpuenc.getValue());
                        rcs = new RemoteCardSpec(cardid);
                        this.rpus.add(new RemoteProtocolUnit(rcs));
                        continue block9;
                    }
                    case 193: {
                        if (rcs == null) {
                            throw new TLVEncodingException("MAXCAPU out of sequence");
                        }
                        int len = new BigInteger(rpuenc.getValue()).intValue();
                        rcs.setMaxCAPDU(len);
                        continue block9;
                    }
                    case 194: {
                        if (rcs == null) {
                            throw new TLVEncodingException("MAXRAPU out of sequence");
                        }
                        int len = new BigInteger(rpuenc.getValue()).intValue();
                        rcs.setMaxRAPDU(len);
                    }
                }
            }
        }
        catch (TagSizeException e) {
            throw new TLVEncodingException();
        }
        catch (CardTerminalException e) {
            throw new TLVEncodingException();
        }
        catch (TLVDataSizeException e) {
            throw new TLVEncodingException();
        }
    }

    public static boolean isInitiation(byte[] pit) {
        return (pit[0] & 0xFF) == 232;
    }

    public String toString() {
        if (this.closing) {
            return "Closing";
        }
        StringBuffer bb = new StringBuffer();
        if (this.executedCommands > 0) {
            bb.append("" + this.executedCommands + " commands executed\n");
        }
        for (RemoteProtocolUnit rpu : this.rpus) {
            bb.append(rpu.toString() + "\n");
        }
        return bb.toString();
    }
}

