/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import de.cardcontact.opencard.eac.cvc.Extension;
import de.cardcontact.opencard.eac.cvc.Extensions;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class CVCertificateGenerator {
    private CertificationAuthorityReference car;
    private CertificateHolderReference chr;
    private ObjectIdentifier pubalgo = ECPublicKeyTLV.id_TA_ECDSA_SHA_256;
    private PublicKey pub;
    private CertificateHolderAuthorizationTemplate chat;
    private CertificateEffectiveDate notBefore;
    private CertificateExpirationDate notAfter;
    private Extensions extensions = null;
    private boolean withDomainParameter = true;

    public void withDomainParameter(boolean withDomainParameter) {
        this.withDomainParameter = withDomainParameter;
    }

    public void setCertificationAuthorityReference(CertificationAuthorityReference car) {
        this.car = car;
    }

    public void setPublicKey(PublicKey pub) {
        this.pub = pub;
    }

    public void setPublicKey(PublicKey pub, ObjectIdentifier algo) {
        this.pub = pub;
        this.pubalgo = algo;
    }

    public void setCertificateHolderReference(CertificateHolderReference chr) {
        this.chr = chr;
    }

    public void setCertificateHolderAuthorizationTemplate(CertificateHolderAuthorizationTemplate chat) {
        this.chat = chat;
    }

    public void setCertificateEffectiveDate(CertificateEffectiveDate notBefore) {
        this.notBefore = notBefore;
    }

    public void setCertificateExpirationDate(CertificateExpirationDate notAfter) {
        this.notAfter = notAfter;
    }

    public void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new Extensions();
        }
        this.extensions.add(extension);
    }

    public CVCertificate generate(PrivateKey signerkey, String algo) throws GeneralSecurityException {
        ECPublicKeyTLV pt = new ECPublicKeyTLV(this.pubalgo, (ECPublicKey)this.pub, this.withDomainParameter);
        CertificateBody body = new CertificateBody(this.car, pt, this.chr, this.chat, this.notBefore, this.notAfter);
        if (this.extensions != null) {
            body.add(this.extensions);
        }
        Signature signer = Signature.getInstance(algo);
        signer.initSign(signerkey);
        signer.update(body.getBytes());
        byte[] signature = signer.sign();
        if (signerkey instanceof ECPrivateKey) {
            int keysize = ((ECPrivateKey)signerkey).getParams().getCurve().getField().getFieldSize();
            keysize = keysize + 7 >> 3;
            signature = ECSignature.unwrapSignature(signature, keysize);
        }
        return new CVCertificate(body, new SignatureTLV(signature));
    }

    public CVCertificate generate(PrivateKey signerkey) throws GeneralSecurityException {
        return this.generate(signerkey, "SHA256withECDSA");
    }
}

