/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class CVCertificate
extends ConstructedTLV {
    static final Tag TAG = new Tag(33, 64, true);
    static final String NAME = "CV Certificate";

    public CVCertificate(CertificateBody body, SignatureTLV signature) {
        super(TAG);
        this.setName(NAME);
        this.add(body);
        this.add(signature);
    }

    public CVCertificate(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("CV Certificate with wrong tag " + tlv.getTag());
        }
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("CV Certificate must contain 2 elements");
        }
        this.childs.set(0, new CertificateBody((TLV)this.childs.get(0)));
        this.childs.set(1, new SignatureTLV((TLV)this.childs.get(1)));
    }

    public CertificateBody getCertificateBody() {
        return (CertificateBody)this.childs.get(0);
    }

    public SignatureTLV getSignatureTLV() {
        return (SignatureTLV)this.childs.get(1);
    }
}

