/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac;

import de.cardcontact.opencard.eac.cvc.AuthenticatedRequest;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifiableCertificate
extends Certificate {
    final Logger log = LoggerFactory.getLogger(CardVerifiableCertificate.class);
    byte[] encoded;
    AuthenticatedRequest req = null;
    CVCertificate cvc;
    ECParameterSpec domain = null;

    public CardVerifiableCertificate(byte[] certificate) throws CertificateException {
        super("CVC");
        try {
            TLV tlv = TLV.factory(certificate);
            if (tlv.getTag().equals(AuthenticatedRequest.TAG)) {
                this.req = new AuthenticatedRequest(tlv);
                this.cvc = this.req.getCVCertificate();
            } else {
                this.cvc = new CVCertificate(tlv);
            }
            int size = tlv.getSize();
            this.encoded = new byte[size];
            System.arraycopy(certificate, 0, this.encoded, 0, size);
        }
        catch (TLVEncodingException e) {
            this.log.error("Decoding CVC failed with ", (Throwable)e);
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encoded;
    }

    public static String signAlgoForOID(ObjectIdentifier oid) {
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_256.equals(oid)) {
            return "SHA256withECDSA";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_384.equals(oid)) {
            return "SHA384withECDSA";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_512.equals(oid)) {
            return "SHA512withECDSA";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_224.equals(oid)) {
            return "SHA224withECDSA";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_1.equals(oid)) {
            return "SHA1withECDSA";
        }
        return null;
    }

    public static String hashAlgoForOID(ObjectIdentifier oid) {
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_256.equals(oid)) {
            return "SHA-256";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_384.equals(oid)) {
            return "SHA-384";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_512.equals(oid)) {
            return "SHA-512";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_224.equals(oid)) {
            return "SHA-224";
        }
        if (ECPublicKeyTLV.id_TA_ECDSA_SHA_1.equals(oid)) {
            return "SHA-1";
        }
        return null;
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, (String)null);
    }

    public void verify(PublicKey key, String algo, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        byte[] wrappedSignature;
        Signature verifier = sigProvider == null ? Signature.getInstance(algo) : Signature.getInstance(algo, sigProvider);
        verifier.initVerify(key);
        if (this.req != null) {
            verifier.update(this.cvc.getBytes());
            verifier.update(this.req.getCertificationAuthorityReference().getBytes());
            wrappedSignature = ECSignature.wrapSignature(this.req.getSignatureTLV().getValue());
        } else {
            verifier.update(this.cvc.getCertificateBody().getBytes());
            wrappedSignature = ECSignature.wrapSignature(this.cvc.getSignatureTLV().getValue());
        }
        boolean verified = verifier.verify(wrappedSignature);
        if (!verified) {
            throw new CertificateException("Certificate verification failed.");
        }
        this.domain = ((ECPublicKey)key).getParams();
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "SHA256withECDSA", sigProvider);
    }

    public String getSignatureAlgorithm() {
        return CardVerifiableCertificate.signAlgoForOID(this.getCVCertificate().getCertificateBody().getPublicKeyTLV().getObjectIdentifier());
    }

    public void verify(CardVerifiableCertificate ca) throws GeneralSecurityException {
        this.verify(ca.getPublicKey(), ca.getSignatureAlgorithm(), null);
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cvc.getCertificateBody().getPublicKeyTLV().getPublicKey(this.domain);
    }

    public byte[] getCurveOID() {
        if (!(this.cvc.getCertificateBody().getPublicKeyTLV() instanceof ECPublicKeyTLV)) {
            throw new IllegalArgumentException("getCurveOID() only supported for ECPublicKey");
        }
        return ((ECPublicKeyTLV)this.cvc.getCertificateBody().getPublicKeyTLV()).getCurveOID();
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        return this.cvc.getCertificateBody().getCertificationAuthorityReference();
    }

    public CertificationAuthorityReference getOuterCertificationAuthorityReference() {
        return this.req.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return this.cvc.getCertificateBody().getCertificateHolderReference();
    }

    public CVCertificate getCVCertificate() {
        return this.cvc;
    }

    public AuthenticatedRequest getAuthenticatedRequest() {
        return this.req;
    }

    public TLV getExtension(Class clazz) {
        return this.cvc.getCertificateBody().getExtensions().getExtension(clazz);
    }

    public byte[] getSubjectPublicKeyIdentifier() {
        byte[] spki = null;
        try {
            byte[] hashinp = null;
            PublicKeyTLV puk = this.getCVCertificate().getCertificateBody().getPublicKeyTLV();
            hashinp = puk.getEncodedForSPKI();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(hashinp, 0, hashinp.length);
            spki = md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("getSubjectPublicKeyIdentifier() failed", e);
        }
        return spki;
    }

    @Override
    public String toString() {
        return this.cvc.dump();
    }
}

