/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class MessageAuthenticationCode {
    public static MessageAuthenticationCode getInstance(String algo, String provider) throws GeneralSecurityException {
        MessageAuthenticationCode mac;
        try {
            mac = new NativeMAC(algo, provider);
        }
        catch (Exception e) {
            mac = new CBCBasedCMAC(algo, provider);
        }
        return mac;
    }

    public abstract void init(Key var1);

    public abstract byte[] doFinal(byte[] var1);

    private static class CBCBasedCMAC
    extends MessageAuthenticationCode {
        private Cipher aes;
        private static final byte[] zero = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private static final byte[] rb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -121};
        private static final IvParameterSpec iv = new IvParameterSpec(zero);
        private byte[] k1 = new byte[16];
        private byte[] k2 = new byte[16];

        public CBCBasedCMAC(String algo, String provider) {
            try {
                this.aes = provider != null ? Cipher.getInstance("AES/CBC/NoPadding", provider) : Cipher.getInstance("AES/CBC/NoPadding");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create AES/CBC/NoPadding instance", e);
            }
        }

        @Override
        public void init(Key key) {
            try {
                this.aes.init(1, key, iv);
                byte[] k0 = this.aes.doFinal(zero);
                byte s = (byte)(k0[0] & 0x80);
                CBCBasedCMAC.doLeftShiftOneBit(k0);
                if (s == -128) {
                    CBCBasedCMAC.xor128(k0, 0, rb);
                }
                System.arraycopy(k0, 0, this.k1, 0, 16);
                s = (byte)(k0[0] & 0x80);
                CBCBasedCMAC.doLeftShiftOneBit(k0);
                if (s == -128) {
                    CBCBasedCMAC.xor128(k0, 0, rb);
                }
                System.arraycopy(k0, 0, this.k2, 0, 16);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw new RuntimeException("Could not set AES key and calculate k0", e);
            }
        }

        @Override
        public byte[] doFinal(byte[] input) {
            byte[] res;
            int size = (input.length + 15) / 16 * 16;
            if (size == 0) {
                size = 16;
            }
            byte[] buf = new byte[size];
            System.arraycopy(input, 0, buf, 0, input.length);
            if (size == input.length) {
                CBCBasedCMAC.xor128(buf, size - 16, this.k1);
            } else {
                buf[input.length] = -128;
                CBCBasedCMAC.xor128(buf, size - 16, this.k2);
            }
            try {
                res = this.aes.doFinal(buf);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new RuntimeException("Could not perform AES/CBC", e);
            }
            byte[] mac = new byte[16];
            System.arraycopy(res, size - 16, mac, 0, 16);
            return mac;
        }

        private static void xor128(byte[] buf1, int offsetBuf1, byte[] buf2) {
            for (int i = 0; i < buf2.length; ++i) {
                buf1[offsetBuf1 + i] = (byte)(buf1[offsetBuf1 + i] ^ buf2[i]);
            }
        }

        private static void doLeftShiftOneBit(byte[] buf) {
            int overflow = 0;
            for (int i = buf.length - 1; i >= 0; --i) {
                byte d = (byte)(buf[i] << 1 | overflow);
                overflow = (buf[i] & 0x80) == 128 ? 1 : 0;
                buf[i] = d;
            }
        }

        public static void test() {
            byte[] k = new byte[]{43, 126, 21, 22, 40, -82, -46, -90, -85, -9, 21, -120, 9, -49, 79, 60};
            SecretKeySpec key = new SecretKeySpec(k, "AES");
            CBCBasedCMAC m = new CBCBasedCMAC("", "");
            m.init(key);
            byte[] msg = new byte[]{};
            byte[] ref = new byte[]{-69, 29, 105, 41, -23, 89, 55, 40, 127, -93, 125, 18, -101, 117, 103, 70};
            byte[] mac = m.doFinal(msg);
            if (!Arrays.equals(ref, mac)) {
                throw new RuntimeException("AES CMAC Selftest failed.");
            }
            msg = new byte[]{107, -63, -66, -30, 46, 64, -97, -106, -23, 61, 126, 17, 115, -109, 23, 42};
            ref = new byte[]{7, 10, 22, -76, 107, 77, 65, 68, -9, -101, -35, -99, -48, 74, 40, 124};
            mac = m.doFinal(msg);
            if (!Arrays.equals(ref, mac)) {
                throw new RuntimeException("AES CMAC Selftest failed.");
            }
            msg = new byte[]{107, -63, -66, -30, 46, 64, -97, -106, -23, 61, 126, 17, 115, -109, 23, 42, -82, 45, -118, 87, 30, 3, -84, -100, -98, -73, 111, -84, 69, -81, -114, 81, 48, -56, 28, 70, -93, 92, -28, 17};
            ref = new byte[]{-33, -90, 103, 71, -34, -102, -26, 48, 48, -54, 50, 97, 20, -105, -56, 39};
            mac = m.doFinal(msg);
            if (!Arrays.equals(ref, mac)) {
                throw new RuntimeException("AES CMAC Selftest failed.");
            }
            msg = new byte[]{107, -63, -66, -30, 46, 64, -97, -106, -23, 61, 126, 17, 115, -109, 23, 42, -82, 45, -118, 87, 30, 3, -84, -100, -98, -73, 111, -84, 69, -81, -114, 81, 48, -56, 28, 70, -93, 92, -28, 17, -27, -5, -63, 25, 26, 10, 82, -17, -10, -97, 36, 69, -33, 79, -101, 23, -83, 43, 65, 123, -26, 108, 55, 16};
            ref = new byte[]{81, -16, -66, -65, 126, 59, -99, -110, -4, 73, 116, 23, 121, 54, 60, -2};
            mac = m.doFinal(msg);
            if (!Arrays.equals(ref, mac)) {
                throw new RuntimeException("AES CMAC Selftest failed.");
            }
        }
    }

    private static class NativeMAC
    extends MessageAuthenticationCode {
        Mac mac;

        public NativeMAC(String algo, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.mac = provider != null ? Mac.getInstance(algo, provider) : Mac.getInstance(algo);
        }

        @Override
        public void init(Key key) {
            try {
                this.mac.init(key);
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
        }

        @Override
        public byte[] doFinal(byte[] input) {
            return this.mac.doFinal(input);
        }
    }
}

