/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.eac20;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.IsoSecureChannel;
import de.cardcontact.opencard.security.IsoSecureChannelCredential;
import de.cardcontact.opencard.security.MessageAuthenticationCode;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.CredentialStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EAC20 {
    final Logger log = LoggerFactory.getLogger(EAC20.class);
    private SmartCardHSMCardService hsms;
    private ECPrivateKey prkCA;
    private ECPublicKey pukCA;
    private byte[] ephemeralPublicKeyIfd;
    private ECPublicKey devAuthPK;
    private SecretKey kenc;
    private SecretKey kmac;
    private IsoSecureChannel sc;
    private IsoSecureChannelCredential credential;
    private CredentialStore store;
    private CardFilePath securityDomain = new CardFilePath("#E82B0601040181C31F0201");
    private byte[] protocol;
    private static ECParameterSpec eCParameterSpecBrainpoolP256r1 = null;

    public static ECParameterSpec getECParameterSpecforBrainpoolP256r1() {
        if (eCParameterSpecBrainpoolP256r1 == null) {
            BigInteger prime = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", 16);
            ECFieldFp field = new ECFieldFp(prime);
            BigInteger a = new BigInteger("7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", 16);
            BigInteger b = new BigInteger("26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", 16);
            EllipticCurve curve = new EllipticCurve(field, a, b);
            BigInteger x = new BigInteger("8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", 16);
            BigInteger y = new BigInteger("547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", 16);
            ECPoint g = new ECPoint(x, y);
            BigInteger n = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 16);
            int h = 1;
            eCParameterSpecBrainpoolP256r1 = new ECParameterSpec(curve, g, n, h);
        }
        return eCParameterSpecBrainpoolP256r1;
    }

    public EAC20(SmartCardHSMCardService hsms, ECPublicKey devAuthPK) {
        this.hsms = hsms;
        this.devAuthPK = devAuthPK;
    }

    public SecureChannelCredential performChipAuthentication() throws CardServiceException, CardTerminalException {
        this.generateEphemeralCAKeyPair();
        this.protocol = new byte[]{4, 0, 127, 0, 7, 2, 2, 3, 2, 2};
        try {
            byte[] cdata = new PrimitiveTLV(new Tag(0, -128, false), this.protocol).getBytes();
            this.hsms.manageSE(cdata);
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            if (e.getSW() != 27264) {
                throw e;
            }
            this.protocol = new byte[]{4, 0, 127, 0, 7, 2, 2, 3, 2, 1};
            byte[] cdata = new PrimitiveTLV(new Tag(0, -128, false), this.protocol).getBytes();
            this.hsms.manageSE(cdata);
        }
        byte[] dadobin = this.doGeneralAuthenticate();
        ConstructedTLV dado = null;
        try {
            dado = new ConstructedTLV(dadobin);
        }
        catch (TLVEncodingException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        PrimitiveTLV nonceDO = (PrimitiveTLV)dado.get(0);
        PrimitiveTLV authTokenDO = (PrimitiveTLV)dado.get(1);
        byte[] nonce = nonceDO.getValue();
        byte[] authToken = authTokenDO.getValue();
        ECPoint q = this.devAuthPK.getW();
        ECParameterSpec ecParameterSpec = this.prkCA.getParams();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(q, ecParameterSpec);
        PublicKey otherKey = null;
        try {
            otherKey = KeyFactory.getInstance("EC").generatePublic(ecPublicKeySpec);
        }
        catch (GeneralSecurityException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] k = null;
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.prkCA);
            ka.doPhase(otherKey, true);
            k = ka.generateSecret();
        }
        catch (GeneralSecurityException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.kenc = this.deriveKey(this.protocol[this.protocol.length - 1], k, 1, nonce);
        this.kmac = this.deriveKey(this.protocol[this.protocol.length - 1], k, 2, nonce);
        if (!this.verifyAuthenticationToken(authToken)) {
            this.log.error("Authentication token failed verification");
            throw new CardServiceException("Authentication token failed");
        }
        this.sc = new IsoSecureChannel();
        this.sc.setEncKey(this.kenc);
        this.sc.setMacKey(this.kmac);
        if (this.protocol[this.protocol.length - 1] == 1) {
            this.sc.setMACSendSequenceCounter(new byte[8]);
        } else {
            this.sc.setMACSendSequenceCounter(new byte[16]);
            this.sc.setSendSequenceCounterPolicy(IsoSecureChannel.SSCPolicyEnum.SYNC_AND_ENCRYPT);
        }
        this.credential = new IsoSecureChannelCredential(65535, this.sc);
        this.store = new IsoCredentialStore();
        ((IsoCredentialStore)this.store).setSecureChannelCredential(this.securityDomain, this.credential);
        return this.credential;
    }

    private void generateEphemeralCAKeyPair() {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            keyGen.initialize(EAC20.getECParameterSpecforBrainpoolP256r1());
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyPair kp = keyGen.generateKeyPair();
        this.prkCA = (ECPrivateKey)kp.getPrivate();
        this.pukCA = (ECPublicKey)kp.getPublic();
    }

    private byte[] doGeneralAuthenticate() throws CardTerminalException, CardServiceException {
        byte[] qx = EAC20.unsignedBigIntegerToByteArray(this.pukCA.getW().getAffineX(), 256);
        byte[] qy = EAC20.unsignedBigIntegerToByteArray(this.pukCA.getW().getAffineY(), 256);
        this.ephemeralPublicKeyIfd = new byte[qx.length * 2 + 1];
        this.ephemeralPublicKeyIfd[0] = 4;
        System.arraycopy(qx, 0, this.ephemeralPublicKeyIfd, 1, qx.length);
        System.arraycopy(qy, 0, this.ephemeralPublicKeyIfd, 1 + qx.length, qy.length);
        byte[] authTemplate = null;
        try {
            ConstructedTLV dado = new ConstructedTLV(124);
            PrimitiveTLV tmp = new PrimitiveTLV(128, this.ephemeralPublicKeyIfd);
            dado.add(tmp);
            authTemplate = dado.getBytes();
        }
        catch (TLVEncodingException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.hsms.generalAuthenticate(authTemplate);
    }

    public SecureChannelCredential getCredential() {
        return this.credential;
    }

    private SecretKey deriveKey(byte alg, byte[] k, int counter, byte[] nonce) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(k);
            bos.write(nonce);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(counter);
        byte[] input = bos.toByteArray();
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        digest.update(input);
        byte[] md = digest.digest();
        SecretKey key = null;
        if (alg == 1) {
            byte[] keyBin = new byte[24];
            System.arraycopy(md, 0, keyBin, 0, 16);
            System.arraycopy(md, 0, keyBin, 16, 8);
            DESedeKeySpec desedeKeySpec = null;
            try {
                desedeKeySpec = new DESedeKeySpec(keyBin);
            }
            catch (InvalidKeyException e) {
                this.log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            SecretKeyFactory skf = null;
            try {
                skf = SecretKeyFactory.getInstance("DESede");
                key = skf.generateSecret(desedeKeySpec);
            }
            catch (GeneralSecurityException e) {
                this.log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        byte[] keyBin = new byte[16];
        System.arraycopy(md, 0, keyBin, 0, 16);
        key = new SecretKeySpec(keyBin, "AES");
        return key;
    }

    public boolean verifyAuthenticationToken(byte[] authToken) {
        byte[] at = null;
        byte[] t = this.encodePublicKey();
        try {
            MessageAuthenticationCode mac = ((SecretKeySpec)this.kmac).getAlgorithm().equals("AES") ? MessageAuthenticationCode.getInstance("AESCMAC", null) : MessageAuthenticationCode.getInstance("ISO9797ALG3Mac", null);
            mac.init(this.kmac);
            at = mac.doFinal(t);
            if (at.length > 8) {
                byte[] stripped = new byte[8];
                System.arraycopy(at, 0, stripped, 0, 8);
                at = stripped;
            }
        }
        catch (GeneralSecurityException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return Arrays.equals(at, authToken);
    }

    public byte[] encodePublicKey() {
        ConstructedTLV t = null;
        try {
            t = new ConstructedTLV(32585);
            t.add(new PrimitiveTLV(6, this.protocol));
            t.add(new PrimitiveTLV(134, this.ephemeralPublicKeyIfd));
        }
        catch (TLVEncodingException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return t.getBytes();
    }

    protected static byte[] unsignedBigIntegerToByteArray(BigInteger bi, int size) {
        byte[] s = bi.toByteArray();
        size = (size >> 3) + ((size & 7) == 0 ? 0 : 1);
        byte[] d = new byte[size];
        int od = size - s.length;
        int os = 0;
        if (od < 0) {
            if (od < -1 || s[0] != 0) {
                throw new IllegalArgumentException("Size mismatch converting big integer to byte array");
            }
            os = -od;
            od = 0;
        }
        System.arraycopy(s, os, d, od, size -= od);
        return d;
    }
}

