/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.smartcardio;

import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOTerminal;
import java.util.Enumeration;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.TerminalInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardIOFactory
implements CardTerminalFactory,
Pollable {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardIOFactory.class);
    private int numberOfRegisteredTerminals = 0;

    @Override
    public void close() throws CardTerminalException {
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, String[] terminalInfo) throws CardTerminalException, TerminalInitException {
        String terminalType = "SmartCardIO";
        if (terminalInfo.length >= 2) {
            terminalType = terminalInfo[1];
        }
        if (terminalType.endsWith("-NOPOLL")) {
            try {
                TerminalFactory factory = TerminalFactory.getDefault();
                List<CardTerminal> terminals = factory.terminals().list();
                for (CardTerminal ct : terminals) {
                    ctr.add(new SmartCardIOTerminal(ct.getName(), terminalType, "", ct));
                    ++this.numberOfRegisteredTerminals;
                }
            }
            catch (CardException ce) {
                logger.error("[createCardTerminals]" + ce);
            }
        } else {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
    }

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void poll() throws CardTerminalException {
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        TerminalFactory factory = TerminalFactory.getDefault();
        CardTerminals ts = factory.terminals();
        List<CardTerminal> terminals = null;
        try {
            terminals = ts.list();
        }
        catch (CardException e) {
            if (this.numberOfRegisteredTerminals > 0) {
                this.removeAllTerminals(ctr);
            }
            return;
        }
        int numberOfTerminals = terminals.size();
        if (numberOfTerminals < this.numberOfRegisteredTerminals) {
            this.removeTerminals(terminals, ctr);
        }
        if (numberOfTerminals > this.numberOfRegisteredTerminals) {
            this.addTerminals(terminals, ctr);
        }
    }

    private void removeAllTerminals(CardTerminalRegistry ctr) throws CardTerminalException {
        Enumeration terminals = ctr.getCardTerminals();
        while (terminals.hasMoreElements()) {
            opencard.core.terminal.CardTerminal t = (opencard.core.terminal.CardTerminal)terminals.nextElement();
            if (!(t instanceof SmartCardIOTerminal)) continue;
            ctr.remove(t);
        }
        this.numberOfRegisteredTerminals = 0;
    }

    private void removeTerminals(List<CardTerminal> terminals, CardTerminalRegistry ctr) throws CardTerminalException {
        Enumeration registeredTerminals = ctr.getCardTerminals();
        while (registeredTerminals.hasMoreElements()) {
            opencard.core.terminal.CardTerminal rct = (opencard.core.terminal.CardTerminal)registeredTerminals.nextElement();
            if (!(rct instanceof SmartCardIOTerminal)) continue;
            boolean isRemoved = true;
            for (CardTerminal ct : terminals) {
                if (!ct.getName().equals(rct.getName())) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            ctr.remove(rct);
            --this.numberOfRegisteredTerminals;
        }
    }

    private void addTerminals(List<CardTerminal> terminals, CardTerminalRegistry ctr) throws CardTerminalException {
        for (CardTerminal ct : terminals) {
            Enumeration registeredTerminals = ctr.getCardTerminals();
            boolean isNew = true;
            while (registeredTerminals.hasMoreElements()) {
                opencard.core.terminal.CardTerminal rct = (opencard.core.terminal.CardTerminal)registeredTerminals.nextElement();
                if (!ct.getName().equals(rct.getName())) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            ctr.add(new SmartCardIOTerminal(ct.getName(), "PCSC", "", ct));
            ++this.numberOfRegisteredTerminals;
        }
    }
}

