/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

public class CompactInteger {
    protected int value;
    protected int sizeof;

    public CompactInteger(int newValue) {
        if (newValue < 0) {
            throw new NumberFormatException("Negative compact integer");
        }
        this.value = newValue;
        this.sizeof = this.value < 128 ? 1 : (this.value < 16384 ? 2 : (this.value < 0x200000 ? 3 : 4));
    }

    public CompactInteger(byte[] bytes, int ofs) {
        byte t;
        this.value = 0;
        this.sizeof = 0;
        do {
            t = bytes[ofs];
            this.value <<= 7;
            this.value |= t & 0x7F;
            ++ofs;
            ++this.sizeof;
        } while ((t & 0x80) == 128 && this.sizeof < 4);
        if ((t & 0x80) == 128) {
            throw new NumberFormatException("Compact integer too long");
        }
    }

    public CompactInteger(byte[] bytes) {
        this(bytes, 0);
    }

    public int sizeOf() {
        return this.sizeof;
    }

    public int intValue() {
        return this.value;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.sizeof];
        int i = this.sizeof - 1;
        int v = this.value;
        bytes[i--] = (byte)(v & 0x7F);
        while (i >= 0) {
            bytes[i--] = (byte)((v >>= 7) & 0x7F | 0x80);
        }
        return bytes;
    }
}

