/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class CapFile {
    public static final int HEADER = 0;
    public static final int DIRECTORY = 1;
    public static final int APPLET = 2;
    public static final int IMPORT = 3;
    public static final int CONSTANTPOOL = 4;
    public static final int CLASS = 5;
    public static final int METHOD = 6;
    public static final int STATICFIELD = 7;
    public static final int REFLOCATION = 8;
    public static final int EXPORT = 9;
    public static final int DESCRIPTOR = 10;
    public static final int DEBUG = 11;
    public static final String[] COMPONENTS = new String[]{"HEADER", "DIRECTORY", "APPLET", "IMPORT", "CONSTANTPOOL", "CLASS", "METHOD", "STATICFIELD", "REFLOCATION", "EXPORT", "DESCRIPTOR", "DEBUG"};
    public static final int[] CAPSEQUENCE = new int[]{0, 1, 3, 2, 5, 6, 7, 9, 4, 8};
    protected String filename;
    protected byte[][] components = new byte[COMPONENTS.length][];

    public void read(InputStream is) throws IOException {
        ZipEntry ze;
        int i;
        for (i = 0; i < this.components.length; ++i) {
            this.components[i] = null;
        }
        ZipInputStream zip = new ZipInputStream(is);
        while ((ze = zip.getNextEntry()) != null) {
            String name = ze.getName().toUpperCase();
            if (name.startsWith("META-INF") || name.startsWith("APPLET-INF") || name.endsWith(".CLASS")) {
                zip.closeEntry();
                continue;
            }
            for (i = 0; i < COMPONENTS.length && !name.endsWith("JAVACARD/" + COMPONENTS[i] + ".CAP"); ++i) {
            }
            if (i >= COMPONENTS.length) {
                throw new IOException("Invalid component " + name + " in cap file");
            }
            if (this.components[i] != null) {
                throw new IOException("Duplicate component " + name + " in cap file");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            zip.transferTo(baos);
            this.components[i] = baos.toByteArray();
            zip.closeEntry();
        }
    }

    public byte[] getLoadFile(int[] caplist) {
        int j;
        int i;
        int size = 0;
        for (i = 0; i < caplist.length; ++i) {
            j = caplist[i];
            if (this.components[j] == null) continue;
            size += this.components[j].length;
        }
        byte[] buffer = new byte[size];
        int offset = 0;
        for (i = 0; i < caplist.length; ++i) {
            j = caplist[i];
            if (this.components[j] == null) continue;
            int len = this.components[j].length;
            System.arraycopy(this.components[j], 0, buffer, offset, len);
            offset += len;
        }
        TLV c4 = new TLV(new Tag(4, 3, false), buffer);
        return c4.toBinary();
    }
}

