/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CertificateDate;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.time.LocalDate;

public class CertificateEffectiveDate
extends CertificateDate {
    static final Tag TAG = new Tag(37, 64, false);
    static final String NAME = "Certificate Effective Date";

    public CertificateEffectiveDate(byte[] date) {
        super(TAG, date);
        if (date == null || date.length != 6) {
            throw new IllegalArgumentException("Certificate Effective Date must be 6 byte long");
        }
        this.setName(NAME);
    }

    public CertificateEffectiveDate(LocalDate date) {
        super(TAG, date);
    }

    public CertificateEffectiveDate(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certificate Effective Date with wrong tag " + tlv.getTag());
        }
        if (tlv.getLength() != 6) {
            throw new IllegalArgumentException("Certificate Effective Date must be 6 byte long");
        }
        this.setName(NAME);
    }
}

