/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.remoteterminal;

import de.cardcontact.opencard.service.remoteclient.RemoteCardSpec;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolScript;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolUnit;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.CommunicationErrorException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.ScriptFailedException;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.TerminalTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTerminal
extends CardTerminal {
    private static final Logger logger = LoggerFactory.getLogger(RemoteTerminal.class);
    private static final int timeoutShort = 30;
    private static final int timeoutLong = 300;
    private boolean freshConnect = true;
    private volatile boolean longPoll = false;
    private long lastPollingTimeout = -1L;
    private int maxCAPDU = -1;
    private int maxRAPDU = -1;
    private CardID cardID = null;
    private LinkedBlockingQueue<RemoteProtocolScript> comQueue = new LinkedBlockingQueue(3);
    private LinkedBlockingQueue<RemoteProtocolScript> resQueue = new LinkedBlockingQueue(1);
    private RemoteProtocolScript current = null;
    private int currentAPDUs;

    public RemoteTerminal(String name) throws CardTerminalException {
        super(name, "RemoteTerminal", "");
        logger.debug("Created " + name);
        this.addSlots(1);
    }

    private boolean remoteDisappeared() {
        if (this.lastPollingTimeout != -1L && System.currentTimeMillis() - this.lastPollingTimeout > 5000L) {
            logger.debug("Remote terminal disappeared at " + this.lastPollingTimeout);
            this.cardID = null;
            this.cardRemoved(0);
            return true;
        }
        return false;
    }

    private void addRemoteProtocolUnit(RemoteProtocolUnit cmd) {
        if (this.current == null) {
            this.current = new RemoteProtocolScript();
        }
        this.current.add(cmd);
    }

    private RemoteProtocolScript transmit(int timeout) throws CardTerminalException {
        RemoteProtocolScript resObject;
        try {
            if (this.remoteDisappeared()) {
                throw new CardTerminalException("Remote terminal disappeared");
            }
            if (!this.comQueue.offer(this.current, 2L, TimeUnit.SECONDS)) {
                throw new TerminalTimeoutException("Could not queue APDU to terminal. Remote card terminal probably disappeared", 1);
            }
            logger.debug("Waiting for R-APDU from remote terminal");
            resObject = this.resQueue.poll(timeout, TimeUnit.SECONDS);
            if (resObject == null) {
                throw new TerminalTimeoutException("The waiting time of " + timeout + " seconds for the response has expired.", timeout);
            }
        }
        catch (InterruptedException e) {
            throw new CardTerminalException(e.getMessage());
        }
        finally {
            this.current = null;
        }
        return resObject;
    }

    public RemoteProtocolScript poll(int timeout) throws CardTerminalException {
        RemoteProtocolScript comObject;
        try {
            this.lastPollingTimeout = -1L;
            this.longPoll = true;
            comObject = this.comQueue.poll(timeout, TimeUnit.SECONDS);
            if (comObject == null) {
                if (this.freshConnect) {
                    throw new CommunicationErrorException("The waiting time of " + timeout + " seconds for the initial command apdu has expired.");
                }
                this.lastPollingTimeout = System.currentTimeMillis();
            }
            this.freshConnect = false;
        }
        catch (InterruptedException e) {
            throw new CardTerminalException(e.getMessage());
        }
        finally {
            this.longPoll = false;
        }
        return comObject;
    }

    public void put(RemoteProtocolScript resObject) {
        logger.debug("Placing R-APDU into queue");
        if (!this.resQueue.offer(resObject)) {
            logger.warn("Could not place message from remote into response queue. Queue stuck ?");
        }
        for (RemoteProtocolUnit rpe : resObject.getRemoteProtocolUnits()) {
            if (!rpe.isClosing() || !this.longPoll) continue;
            logger.debug("Cancel long polling");
            RemoteProtocolScript enc = new RemoteProtocolScript();
            enc.add(rpe);
            if (!this.comQueue.offer(enc)) {
                logger.warn("Could not place close message in command queue to end long polling request. Queue stuck ?");
            }
            this.cardRemoved(0);
        }
    }

    @Override
    public CardID getCardID(int slotID) throws CardTerminalException {
        return this.cardID;
    }

    public void initializeSession(RemoteCardSpec rcs) throws CardTerminalException {
        this.cardID = new CardID(this, 0, rcs.getCardID().getATR());
        this.maxCAPDU = rcs.getMaxCAPDU();
        this.maxRAPDU = rcs.getMaxRAPDU();
        this.freshConnect = true;
        this.comQueue.clear();
        this.resQueue.clear();
        this.cardInserted(0);
    }

    @Override
    protected Properties internalFeatures(Properties features) {
        if (this.maxCAPDU != -1) {
            features.put("maxCAPDUSize", String.valueOf(this.maxCAPDU));
        }
        if (this.maxRAPDU != -1) {
            features.put("maxRAPDUSize", String.valueOf(this.maxRAPDU));
        }
        return features;
    }

    @Override
    public boolean isCardPresent(int slotID) throws CardTerminalException {
        return this.cardID != null;
    }

    @Override
    public void open() throws CardTerminalException {
        logger.debug("[open] open");
    }

    @Override
    public void close() throws CardTerminalException {
        logger.debug("[close] close");
        if (this.cardID != null) {
            this.internalCloseSlotChannel(null);
        }
    }

    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        this.addRemoteProtocolUnit(new RemoteProtocolUnit(RemoteProtocolUnit.Action.RESET));
        RemoteProtocolScript rpe = this.transmit(30);
        for (RemoteProtocolUnit rpu : rpe.getRemoteProtocolUnits()) {
            switch (rpu.getAction()) {
                case RESET: {
                    this.cardID = new CardID(this, 0, ((RemoteCardSpec)rpu.getPayload()).getCardID().getATR());
                    break;
                }
                case CLOSE: {
                    throw new CommunicationErrorException(rpu.getMessage());
                }
            }
        }
        return this.cardID;
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        this.addRemoteProtocolUnit(new RemoteProtocolUnit(capdu));
        int cmds = this.current.getExecutedCommands() + 1;
        this.current.setExecutedCommands(cmds);
        ResponseAPDU rsp = null;
        if (capdu.isQueueable()) {
            rsp = new ResponseAPDU(new byte[]{-112, 0});
            rsp.setQueued(true);
            return rsp;
        }
        int timeout = 30;
        if (capdu.getByte(1) == 70 || capdu.getByte(1) == 230) {
            timeout = 300;
        }
        RemoteProtocolScript rpe = this.transmit(timeout);
        int rsps = rpe.getExecutedCommands();
        int step = 0;
        int lastsw = 36864;
        for (RemoteProtocolUnit rpu : rpe.getRemoteProtocolUnits()) {
            switch (rpu.getAction()) {
                case APDU: {
                    rsp = (ResponseAPDU)rpu.getPayload();
                    if (lastsw != 36864) {
                        logger.debug("Intermediate response APDU is not 9000");
                        throw new ScriptFailedException(step, lastsw);
                    }
                    lastsw = rsp.sw();
                    ++step;
                    break;
                }
                case CLOSE: {
                    throw new CommunicationErrorException(rpu.getMessage());
                }
            }
        }
        if (rsp == null) {
            throw new CardTerminalException("Response APDU missing");
        }
        if (step == 1) {
            if (cmds > 1 && rsps < cmds) {
                logger.debug("Did not execute all command APDUs (" + rsps + " of " + cmds + ")");
                throw new ScriptFailedException(step, lastsw);
            }
        } else if (step != cmds) {
            logger.debug("Did not execute all command APDUs (" + step + " of " + cmds + ")");
            throw new ScriptFailedException(step, lastsw);
        }
        return rsp;
    }

    @Override
    protected void internalCloseSlotChannel(SlotChannel sc) {
        try {
            if (this.current != null) {
                if (!this.comQueue.offer(this.current, 1L, TimeUnit.SECONDS)) {
                    logger.debug("Close message could not be added to queue");
                }
                this.current = null;
            }
            RemoteProtocolScript enc = new RemoteProtocolScript();
            enc.setClosing();
            if (!this.comQueue.offer(enc, 1L, TimeUnit.SECONDS)) {
                logger.debug("Close message could not be added to queue");
            }
        }
        catch (InterruptedException e) {
            logger.debug("Adding close message interrupted");
        }
        this.cardID = null;
    }

    public void sendNotification(int id, String message, int ttc) throws CardTerminalException {
        this.addRemoteProtocolUnit(new RemoteProtocolUnit(RemoteProtocolUnit.Action.NOTIFY, id, message, ttc));
    }

    public void sendNotification(int id, String message) throws CardTerminalException {
        this.sendNotification(id, message, 0);
    }
}

