/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import opencard.core.service.CHVDialog;

public class DefaultCHVDialog
implements CHVDialog {
    @Override
    public String getCHV(int chvNumber) {
        ResourceBundle rb = ResourceBundle.getBundle("opencard.core.service.DefaultCHVDialogResourceBundle");
        String dialogTitle = rb.getString("chv.title");
        String dialogPrompt = rb.getString("chv.prompt.prefix") + chvNumber + rb.getString("chv.prompt.postfix");
        Frame frame = new Frame("");
        IDDialog dialog = new IDDialog(frame, dialogTitle, dialogPrompt);
        frame.setVisible(false);
        Dimension dim = frame.getToolkit().getScreenSize();
        dialog.setSize(220, 150);
        dialog.setLocation(dim.width - 220, 0);
        dialog.showDialog();
        frame.dispose();
        String chv = dialog.chv();
        if (chv != null && chv.length() > 0) {
            return chv;
        }
        return null;
    }

    public class IDDialog
    extends Dialog
    implements ActionListener {
        protected Button okButton;
        protected Button cancelButton;
        protected Label messageLabel;
        protected boolean finished;
        protected Object objectToNotify;
        public TextField textField;
        protected String chv;

        public IDDialog(Frame parent, String title, String prompt) {
            super(parent, title, true);
            GridBagLayout gridBag = new GridBagLayout();
            this.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridBag);
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.messageLabel = new Label(prompt);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            gridBag.setConstraints(this.messageLabel, c);
            this.add(this.messageLabel);
            c.gridx = 0;
            c.gridy = 1;
            this.textField = new TextField("", 10);
            this.textField.addActionListener(this);
            this.textField.setEchoChar('*');
            gridBag.setConstraints(this.textField, c);
            this.add(this.textField);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            this.okButton = new Button(" OK ");
            this.okButton.addActionListener(this);
            gridBag.setConstraints(this.okButton, c);
            this.add(this.okButton);
            c.gridx = 1;
            c.gridy = 2;
            this.cancelButton = new Button("Cancel");
            this.cancelButton.addActionListener(this);
            gridBag.setConstraints(this.cancelButton, c);
            this.add(this.cancelButton);
            this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton || source == this.textField) {
                this.chv = this.textField.getText();
            } else if (source == this.cancelButton) {
                this.chv = null;
            }
            this.setVisible(false);
        }

        public String chv() {
            return this.chv;
        }

        public void showDialog() {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    IDDialog.this.textField.requestFocus();
                }
            };
            t.start();
            this.setVisible(true);
        }
    }
}

