/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.globalplatform;

import de.cardcontact.opencard.security.GPSCP02SecureChannel;
import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.utils.CapFile;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.opt.applet.AppletID;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDomainCardService
extends CardService
implements SecureService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityDomainCardService.class);
    public static final AppletID ISD_AID = new AppletID("A000000003000000");
    private AppletID aid = ISD_AID;
    private CredentialBag credentialBag = null;
    private byte level = 0;

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        logger.debug("[initialize] called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU select(AppletID id, boolean next) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(64);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-92);
            com.append((byte)4);
            com.append(next ? (byte)2 : 0);
            if (id != null) {
                byte[] aid = id.getBytes();
                com.append((byte)aid.length);
                com.append(aid);
                this.aid = id;
            } else {
                this.aid = ISD_AID;
            }
            com.append((byte)0);
            res = channel.sendCommandAPDU(com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU installForInstall(byte[] loadFileAID, byte[] execModAID, byte[] appInsAID, byte[] privileges, byte[] installParam, byte[] installToken, boolean makeSelectable) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-26);
            com.append((byte)(4 | (makeSelectable ? 8 : 0)));
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)loadFileAID.length);
            com.append(loadFileAID);
            com.append((byte)execModAID.length);
            com.append(execModAID);
            com.append((byte)appInsAID.length);
            com.append(appInsAID);
            com.append((byte)privileges.length);
            com.append(privileges);
            com.append((byte)installParam.length);
            com.append(installParam);
            if (installToken != null) {
                com.append((byte)installToken.length);
                com.append(installToken);
            } else {
                com.append((byte)0);
            }
            com.setByte(4, com.getLength() - 5);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    public ResponseAPDU installForInstallAndSelectable(byte[] loadFileAID, byte[] execModAID, byte[] appInsAID, byte[] privileges, byte[] installParam, byte[] installToken) throws CardTerminalException {
        return this.installForInstall(loadFileAID, execModAID, appInsAID, privileges, installParam, installToken, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU installForLoad(byte[] loadFileAID, byte[] secDomAID, byte[] loadDBHash, byte[] loadParam, byte[] loadToken) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-26);
            com.append((byte)2);
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)loadFileAID.length);
            com.append(loadFileAID);
            if (secDomAID != null) {
                com.append((byte)secDomAID.length);
                com.append(secDomAID);
            } else {
                com.append((byte)0);
            }
            if (loadDBHash != null) {
                com.append((byte)loadDBHash.length);
                com.append(loadDBHash);
            } else {
                com.append((byte)0);
            }
            if (loadParam != null) {
                com.append((byte)loadParam.length);
                com.append(loadParam);
            } else {
                com.append((byte)0);
            }
            if (loadToken != null) {
                com.append((byte)loadToken.length);
                com.append(loadToken);
            } else {
                com.append((byte)0);
            }
            com.setByte(4, com.getLength() - 5);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU load(CapFile capFile) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        byte[] loadFile = capFile.getLoadFile(CapFile.CAPSEQUENCE);
        int length = loadFile.length;
        int offset = 0;
        int count = 0;
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            while (length > 0) {
                int block = length;
                if (block > 230) {
                    block = 230;
                }
                com.setLength(0);
                com.append((byte)-128);
                com.append((byte)-24);
                com.append((byte)((length -= block) > 0 ? 0 : 128));
                com.append((byte)count);
                com.append((byte)block);
                System.arraycopy(loadFile, offset, com.getBuffer(), 5, block);
                com.setLength(block + 5);
                com.append((byte)0);
                res = this.sendCommandAPDU(channel, com);
                if (res.sw() != 36864) {
                    break;
                }
                ++count;
                offset += block;
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU deleteAID(byte[] aid) throws CardTerminalException {
        CommandAPDU com = new CommandAPDU(262);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.setLength(0);
            com.append((byte)-128);
            com.append((byte)-28);
            com.append((byte)0);
            com.append((byte)0);
            com.append((byte)(aid.length + 2));
            com.append((byte)79);
            com.append((byte)aid.length);
            com.append(aid);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, com);
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, CommandAPDU com) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU res;
        IsoCredentialStore credentialStore;
        SecureChannelCredential secureChannelCredential = null;
        if (this.credentialBag != null && (credentialStore = (IsoCredentialStore)this.credentialBag.getCredentialStore(null, IsoCredentialStore.class)) != null) {
            secureChannelCredential = credentialStore.getSecureChannelCredential(this.aid);
        }
        if (secureChannelCredential != null) {
            SlotChannel slc = channel.getSlotChannel();
            APDUTracer tracer = slc.getAPDUTracer();
            if (tracer != null && com.getLength() > 5) {
                tracer.traceCommandAPDU(slc, com);
            }
            SecureChannel sc = secureChannelCredential.getSecureChannel();
            com = sc.wrap(com, this.level);
            res = channel.sendCommandAPDU(com);
            res = sc.unwrap(res, this.level);
            if (tracer != null && res.getLength() > 2) {
                tracer.traceResponseAPDU(slc, res);
            }
        } else {
            res = channel.sendCommandAPDU(com);
        }
        return res;
    }

    public ResponseAPDU initializeUpdate(byte keyVersionNumber, byte keyIndex, byte[] hostChallenge) throws InvalidCardChannelException, CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(50);
        ResponseAPDU res = new ResponseAPDU(258);
        try {
            byte i;
            TLV cardData;
            TLV cardRecoginitionData;
            TLV secureChannelInfo;
            byte[] v;
            byte scp;
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.append((byte)-128);
            com.append((byte)-54);
            com.append((byte)0);
            com.append((byte)102);
            com.append((byte)0);
            res = channel.sendCommandAPDU(com);
            if (res.sw() == 36864 && !GPSCP02SecureChannel.scpOptionsSupported(scp = (v = (secureChannelInfo = (TLV)(cardRecoginitionData = (TLV)(cardData = TLV.factory(res.data())).getChildAt(0)).getChildAt(3)).getValue())[v.length - 2], i = v[v.length - 1])) {
                throw new CardServiceException("SCP " + scp + " with option " + i + " is not suppported");
            }
            com = new CommandAPDU(50);
            com.append((byte)-128);
            com.append((byte)80);
            com.append(keyVersionNumber);
            com.append((byte)0);
            com.append((byte)8);
            com.append(hostChallenge);
            com.append((byte)0);
            res = channel.sendCommandAPDU(com);
        }
        catch (TLVEncodingException e) {
            throw new CardServiceException("Invalid encoding of card recognition data : " + e.getLocalizedMessage());
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU externalAuthenticate(byte level, byte[] data) throws InvalidCardChannelException, CardTerminalException, CardServiceException {
        CommandAPDU com = new CommandAPDU(50);
        ResponseAPDU res = new ResponseAPDU(258);
        if (level != 0 && level != 1 && level != 3) {
            throw new CardServiceException("Security level not supported");
        }
        if (data.length != 16) {
            throw new CardServiceException("Wrong length of input data. Must be 16 bytes.");
        }
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            com.append((byte)-124);
            com.append((byte)-126);
            com.append(level);
            com.append((byte)0);
            com.append((byte)16);
            com.append(data);
            res = channel.sendCommandAPDU(com);
        }
        finally {
            this.releaseCardChannel();
        }
        if (res.sw() == 36864) {
            this.level = level;
        }
        return res;
    }

    @Override
    public void provideCredentials(SecurityDomain domain, CredentialBag creds) throws CardServiceException {
        this.credentialBag = creds;
    }
}

