/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.SecureChannel;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class IsoSecureChannel
implements SecureChannel {
    protected String provider;
    protected String macalgorithm;
    protected String cipheralgorithm;
    protected Key kenc;
    protected Key kmac;
    protected byte[] encssc;
    protected byte[] macssc;
    protected byte[] iv;
    protected byte[] crt;
    protected int maclen;
    protected int blocklen;
    protected SSCPolicyEnum sscpolicy = SSCPolicyEnum.DEFAULT;
    private static byte[] one = new byte[]{1};
    private static final boolean singleByteT97 = false;

    public IsoSecureChannel() {
        this("BC");
    }

    public IsoSecureChannel(String provider) {
        this.provider = provider;
        this.kenc = null;
        this.kmac = null;
        this.encssc = null;
        this.macssc = null;
        this.iv = new byte[8];
        this.maclen = 8;
        this.blocklen = 8;
        this.crt = null;
    }

    protected static byte[] incrementSSC(byte[] ssc) {
        int length;
        int rofs;
        int riofs;
        BigInteger bi = new BigInteger(1, ssc);
        BigInteger b1 = new BigInteger(one);
        bi = bi.add(b1);
        byte[] r = new byte[ssc.length];
        byte[] ri = bi.toByteArray();
        if (ri.length > r.length) {
            riofs = ri.length - r.length;
            rofs = 0;
            length = r.length;
        } else {
            riofs = 0;
            rofs = r.length - ri.length;
            length = ri.length;
        }
        System.arraycopy(ri, riofs, r, rofs, length);
        return r;
    }

    protected void incrementMACSSC() {
        this.macssc = IsoSecureChannel.incrementSSC(this.macssc);
    }

    protected void incrementENCSSC() {
        this.encssc = IsoSecureChannel.incrementSSC(this.encssc);
    }

    protected byte[] getIV(Cipher cipher) throws GeneralSecurityException {
        byte[] iiv = this.iv;
        if (this.sscpolicy == SSCPolicyEnum.SYNC_AND_ENCRYPT) {
            IvParameterSpec dps = new IvParameterSpec(iiv);
            cipher.init(1, this.kenc, dps);
            iiv = cipher.doFinal(this.macssc);
        } else if (this.sscpolicy == SSCPolicyEnum.SYNC) {
            iiv = this.macssc;
        } else if (this.encssc != null) {
            iiv = this.encssc;
        }
        return iiv;
    }

    protected byte[] encodeBodyEvenINS(byte[] body, boolean isEncrypted, boolean isProtected) {
        TLV t = null;
        if (isEncrypted) {
            if (this.encssc != null) {
                this.incrementENCSSC();
            }
            int paddedLength = (body.length & ~(this.blocklen - 1)) + this.blocklen;
            byte[] cryptoInput = new byte[paddedLength];
            System.arraycopy(body, 0, cryptoInput, 0, body.length);
            cryptoInput[body.length] = -128;
            try {
                Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                byte[] iiv = this.getIV(cipher);
                IvParameterSpec dps = new IvParameterSpec(iiv);
                cipher.init(1, this.kenc, dps);
                byte[] cipherText = cipher.doFinal(cryptoInput);
                byte[] tlvbody = new byte[cipherText.length + 1];
                tlvbody[0] = 1;
                System.arraycopy(cipherText, 0, tlvbody, 1, cipherText.length);
                t = new TLV(new Tag(isProtected ? 7 : 6, 2, false), tlvbody);
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException(e.getMessage());
            }
            if (!isProtected && this.macssc != null) {
                this.incrementMACSSC();
            }
        } else {
            t = new TLV(new Tag(isProtected ? 1 : 0, 2, false), body);
        }
        return t.toBinary();
    }

    protected byte[] encodeBodyOddINS(byte[] body, boolean isEncrypted, boolean isProtected) {
        TLV t = null;
        if (isEncrypted) {
            if (this.encssc != null) {
                this.incrementENCSSC();
            }
            int paddedLength = (body.length & ~(this.blocklen - 1)) + this.blocklen;
            byte[] cryptoInput = new byte[paddedLength];
            System.arraycopy(body, 0, cryptoInput, 0, body.length);
            cryptoInput[body.length] = -128;
            try {
                Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                byte[] iiv = this.getIV(cipher);
                IvParameterSpec dps = new IvParameterSpec(iiv);
                cipher.init(1, this.kenc, dps);
                byte[] cipherText = cipher.doFinal(cryptoInput);
                t = new TLV(new Tag(isProtected ? 5 : 4, 2, false), cipherText);
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException(e.getMessage());
            }
            if (!isProtected && this.macssc != null) {
                this.incrementMACSSC();
            }
        } else {
            t = new TLV(new Tag(isProtected ? 3 : 2, 2, true), body);
        }
        return t.toBinary();
    }

    protected byte[] calculateMAC(byte cla, byte ins, byte p1, byte p2, byte[] do81or87, byte[] doLe) {
        byte[] doMac;
        int macblen = this.blocklen;
        boolean addPadding = false;
        if (this.macssc != null) {
            macblen += this.macssc.length;
        }
        if (this.crt != null && (this.crt[0] & 1) == 1) {
            macblen += this.crt.length;
            addPadding = true;
        }
        if (do81or87 != null) {
            macblen += do81or87.length;
            addPadding = true;
        }
        if (doLe != null) {
            macblen += doLe.length;
            addPadding = true;
        }
        if (addPadding) {
            macblen = (macblen & ~(this.blocklen - 1)) + this.blocklen;
        }
        byte[] macb = new byte[macblen];
        int offset = 0;
        if (this.macssc != null) {
            System.arraycopy(this.macssc, 0, macb, offset, this.macssc.length);
            offset += this.macssc.length;
        }
        macb[offset++] = (byte)(cla | 0xC);
        macb[offset++] = ins;
        macb[offset++] = p1;
        macb[offset++] = p2;
        macb[offset++] = -128;
        for (int i = this.blocklen - 5; i > 0; --i) {
            macb[offset++] = 0;
        }
        if (this.crt != null && (this.crt[0] & 1) == 1) {
            System.arraycopy(this.crt, 0, macb, offset, this.crt.length);
            offset += this.crt.length;
        }
        if (do81or87 != null) {
            System.arraycopy(do81or87, 0, macb, offset, do81or87.length);
            offset += do81or87.length;
        }
        if (doLe != null) {
            System.arraycopy(doLe, 0, macb, offset, doLe.length);
            offset += doLe.length;
        }
        if (addPadding) {
            macb[offset++] = -128;
            while (offset < macblen) {
                macb[offset++] = 0;
            }
        }
        try {
            Mac eng = Mac.getInstance(this.macalgorithm, this.provider);
            eng.init(this.kmac);
            byte[] mac = eng.doFinal(macb);
            doMac = new byte[2 + this.maclen];
            doMac[0] = -114;
            doMac[1] = (byte)this.maclen;
            System.arraycopy(mac, 0, doMac, 2, this.maclen);
        }
        catch (Exception e) {
            throw new CardServiceInvalidParameterException(e.getMessage());
        }
        return doMac;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU apduToWrap, int usageQualifier) {
        boolean pro = (usageQualifier & 1) > 0;
        boolean enc = (usageQualifier & 2) > 0;
        int le = -1;
        byte[] body = null;
        byte cla = (byte)(apduToWrap.getByte(0) | 8);
        byte ins = (byte)apduToWrap.getByte(1);
        byte p1 = (byte)apduToWrap.getByte(2);
        byte p2 = (byte)apduToWrap.getByte(3);
        boolean oddINS = (ins & 1) == 1;
        boolean extended = false;
        int l = apduToWrap.getLength() - 4;
        if (l > 0) {
            int n;
            int i = 4;
            if ((n = apduToWrap.getByte(i++)) == 0 && --l > 0) {
                extended = true;
                if (l < 2) {
                    throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                }
                n = (apduToWrap.getByte(i) << 8) + apduToWrap.getByte(i + 1);
                i += 2;
                l -= 2;
            }
            if (l > 0) {
                if (l < n) {
                    throw new CardServiceInvalidParameterException("Invalid Lc in APDU");
                }
                body = new byte[n];
                System.arraycopy(apduToWrap.getBuffer(), i, body, 0, n);
                i += n;
                if ((l -= n) > 0) {
                    le = apduToWrap.getByte(i++);
                    --l;
                    if (extended) {
                        if (l < 1) {
                            throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                        }
                        le = (le << 8) + apduToWrap.getByte(i++);
                        --l;
                    }
                }
            } else {
                le = n;
            }
            if (l > 0) {
                throw new CardServiceInvalidParameterException("Unexpected bytes in APDU");
            }
        }
        if (pro && this.macssc != null) {
            this.incrementMACSSC();
        }
        byte[] do81or87 = null;
        if (body != null || this.crt != null) {
            do81or87 = oddINS ? this.encodeBodyOddINS(body, enc, pro) : this.encodeBodyEvenINS(body, enc, pro);
        }
        byte[] doLe = null;
        byte[] doMac = null;
        if (le >= 0) {
            doLe = new byte[extended ? 4 : 3];
            int n = doLe[0] = pro ? -105 : -106;
            if (extended) {
                doLe[1] = 2;
                doLe[2] = (byte)(le >> 8);
                doLe[3] = (byte)(le & 0xFF);
            } else {
                doLe[1] = 1;
                doLe[2] = (byte)(le & 0xFF);
            }
        }
        if (pro) {
            cla = (byte)(cla | 4);
            doMac = this.calculateMAC(cla, ins, p1, p2, do81or87, doLe);
        }
        int newlc = 0;
        if (this.crt != null) {
            newlc += this.crt.length;
        }
        if (do81or87 != null) {
            newlc += do81or87.length;
        }
        if (doLe != null) {
            newlc += doLe.length;
        }
        if (doMac != null) {
            newlc += doMac.length;
        }
        if (newlc > 255) {
            extended = true;
        }
        CommandAPDU apdu = new CommandAPDU(10 + newlc);
        apdu.append(cla);
        apdu.append(ins);
        apdu.append(p1);
        apdu.append(p2);
        if (newlc > 0) {
            if (extended) {
                apdu.append((byte)0);
                apdu.append((byte)(newlc >> 8));
                apdu.append((byte)(newlc & 0xFF));
            } else {
                apdu.append((byte)newlc);
            }
        }
        if (this.crt != null) {
            apdu.append(this.crt);
        }
        if (do81or87 != null) {
            apdu.append(do81or87);
        }
        if (doLe != null) {
            apdu.append(doLe);
        }
        if (doMac != null) {
            apdu.append(doMac);
        }
        if (le != -1 || (usageQualifier & 0xC) > 0) {
            apdu.append((byte)0);
            if (extended) {
                apdu.append((byte)0);
            }
        }
        return apdu;
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU apduToUnwrap, int usageQualifier) {
        int length;
        byte[] tb;
        boolean pro = (usageQualifier & 4) > 0;
        byte[] do81or87 = null;
        byte[] doSW = null;
        byte[] doMac = null;
        byte[] buffer = apduToUnwrap.getBuffer();
        int[] toffset = new int[]{0};
        block11: for (length = apduToUnwrap.getLength(); length > 2; length -= tb.length) {
            try {
                TLV t = new TLV(buffer, toffset);
                tb = t.toBinary();
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException("Invalid encoding of TLV object in secure messaging response detected");
            }
            switch (tb[0]) {
                case -128: 
                case -127: 
                case -124: 
                case -123: 
                case -122: 
                case -121: 
                case -78: 
                case -77: {
                    if (do81or87 != null) {
                        throw new CardServiceInvalidParameterException("Data object " + HexString.hexify(tb[0]) + " detected in secure messaging response that contains data object 80,81,84,85,86,86,B2 or B3 as well");
                    }
                    do81or87 = tb;
                    continue block11;
                }
                case -103: {
                    if (doSW != null) {
                        throw new CardServiceInvalidParameterException("Duplicate data object 99 (SW) found in secure messaging response");
                    }
                    doSW = tb;
                    continue block11;
                }
                case -114: {
                    if (doMac != null) {
                        throw new CardServiceInvalidParameterException("Duplicate data object 8E (MAC) found in secure messaging response");
                    }
                    doMac = tb;
                    continue block11;
                }
                default: {
                    throw new CardServiceInvalidParameterException("Unknown data object found in secure messaging response");
                }
            }
        }
        if (length != 2) {
            throw new CardServiceInvalidParameterException("Length of secure messaging response message invalid");
        }
        if (pro) {
            byte[] mac;
            if (doMac == null) {
                if (apduToUnwrap.sw() == 27015 || apduToUnwrap.sw() == 27016 || apduToUnwrap.sw() == 26754 || apduToUnwrap.sw() == 26368) {
                    return apduToUnwrap;
                }
                throw new CardServiceInvalidParameterException("MAC data object missing from secure messaging response");
            }
            if (doMac.length != this.maclen + 2) {
                throw new CardServiceInvalidParameterException("MAC data object has wrong length");
            }
            int macblen = 0;
            if (this.macssc != null) {
                this.incrementMACSSC();
                macblen += this.macssc.length;
            }
            if (do81or87 != null) {
                macblen += do81or87.length;
            }
            if (doSW != null) {
                macblen += doSW.length;
            }
            macblen = (macblen & ~(this.blocklen - 1)) + this.blocklen;
            byte[] macb = new byte[macblen];
            int offset = 0;
            if (this.macssc != null) {
                System.arraycopy(this.macssc, 0, macb, offset, this.macssc.length);
                offset += this.macssc.length;
            }
            if (do81or87 != null) {
                System.arraycopy(do81or87, 0, macb, offset, do81or87.length);
                offset += do81or87.length;
            }
            if (doSW != null) {
                System.arraycopy(doSW, 0, macb, offset, doSW.length);
                offset += doSW.length;
            }
            macb[offset++] = -128;
            while (offset < macblen) {
                macb[offset++] = 0;
            }
            try {
                Mac eng = Mac.getInstance(this.macalgorithm, this.provider);
                eng.init(this.kmac);
                mac = eng.doFinal(macb);
            }
            catch (Exception e) {
                throw new CardServiceInvalidParameterException(e.getMessage());
            }
            if (doMac[1] != this.maclen) {
                throw new CardServiceInvalidParameterException("MAC data object has wrong length");
            }
            for (int i = 0; i < this.maclen; ++i) {
                if (doMac[i + 2] == mac[i]) continue;
                throw new CardServiceInvalidCredentialException("MAC verification failed");
            }
        }
        byte[] body = null;
        if (do81or87 != null) {
            int tag = do81or87[0] & 0xFE;
            if ((usageQualifier & 8) > 0) {
                if (tag != 132 && tag != 134) {
                    throw new CardServiceInvalidParameterException("Expected enciphered response");
                }
                TLV t = new TLV(do81or87);
                byte[] tv = t.valueAsByteArray();
                int ofs = 0;
                if (tag == 134) {
                    ofs = 1;
                    if (tv[0] != 1) {
                        throw new CardServiceInvalidParameterException("Invalid padding indicator in enciphered block");
                    }
                }
                if (this.encssc != null) {
                    this.incrementENCSSC();
                }
                byte[] cryptoInput = new byte[tv.length - ofs];
                System.arraycopy(tv, ofs, cryptoInput, 0, cryptoInput.length);
                try {
                    int i;
                    Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                    byte[] iiv = this.getIV(cipher);
                    IvParameterSpec dps = new IvParameterSpec(iiv);
                    cipher.init(2, this.kenc, dps);
                    byte[] plainText = cipher.doFinal(cryptoInput);
                    for (i = plainText.length - 1; i > 0 && plainText[i] == 0; --i) {
                    }
                    if (plainText[i] != -128) {
                        throw new CardServiceInvalidCredentialException("Invalid padding in enciphered block");
                    }
                    body = new byte[i];
                    System.arraycopy(plainText, 0, body, 0, i);
                }
                catch (Exception e) {
                    throw new CardServiceInvalidParameterException(e.getMessage());
                }
                if (!pro && this.macssc != null) {
                    this.incrementMACSSC();
                }
            } else {
                if (tag != 128 && tag != 178) {
                    throw new CardServiceInvalidParameterException("Expected plain response");
                }
                TLV t = new TLV(do81or87);
                body = t.toBinaryContent();
            }
        }
        ResponseAPDU apdu = new ResponseAPDU((body == null ? 0 : body.length) + 2);
        if (body != null) {
            apdu.append(body);
        }
        if (doSW != null) {
            apdu.append(doSW[2]);
            apdu.append(doSW[3]);
        } else {
            apdu.append(buffer[apduToUnwrap.getLength() - 2]);
            apdu.append(buffer[apduToUnwrap.getLength() - 1]);
        }
        return apdu;
    }

    public void setEncKey(Key key) {
        this.kenc = key;
        String keyalgo = key.getAlgorithm();
        this.cipheralgorithm = keyalgo + "/CBC/NoPadding";
    }

    public void setMacKey(Key key) {
        this.kmac = key;
        String keyalgo = key.getAlgorithm();
        if (keyalgo.equals("DESede")) {
            this.macalgorithm = "ISO9797ALG3Mac";
            this.blocklen = 8;
        } else if (keyalgo.equals("AES")) {
            this.macalgorithm = "AESCMAC";
            this.blocklen = 16;
        } else {
            throw new CardServiceInvalidParameterException("Unsupported key type " + keyalgo + ". Only DESede or AES allowed.");
        }
        this.iv = new byte[this.blocklen];
    }

    public void setMacAlgorithm(String algo) {
        this.macalgorithm = algo;
    }

    public void setCipherAlgorithm(String algo) {
        this.cipheralgorithm = algo;
    }

    public void setIV(byte[] iv) {
        this.iv = iv;
    }

    public void setMacLength(int maclen) {
        this.maclen = maclen;
    }

    public void setSendSequenceCounter(byte[] ssc) {
        this.macssc = ssc;
    }

    public void setEncryptionSendSequenceCounter(byte[] ssc) {
        this.encssc = ssc;
    }

    public void setMACSendSequenceCounter(byte[] ssc) {
        this.macssc = ssc;
    }

    public byte[] getSendSequenceCounter() {
        return this.macssc;
    }

    public byte[] getEncryptionSendSequenceCounter() {
        return this.encssc;
    }

    public byte[] getMACSendSequenceCounter() {
        return this.macssc;
    }

    public void setSendSequenceCounterPolicy(SSCPolicyEnum policy) {
        this.sscpolicy = policy;
    }

    public void setCRT(byte[] crt) {
        this.crt = crt;
    }

    public static enum SSCPolicyEnum {
        DEFAULT,
        SYNC,
        SYNC_AND_ENCRYPT;

    }
}

