/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;

public class SmartCardHSMCHVDialog
implements CHVDialog {
    private int pinLength = 6;
    private CHVCardServiceWithControl.PasswordStatus status;
    private String title = rb.getString("chvdialog.title");
    static ResourceBundle rb = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());
    private SmartCardHSMCardService service;
    private String pinPrompt = rb.getString("chvdialog.pinPrompt");
    private String blockedMessage = rb.getString("message.blocked");
    private String notInitializedMessage = rb.getString("message.notInitialized");
    private String transportModeMessage = rb.getString("message.transport");
    private String notVerifiedStatus = rb.getString("status.notVerified");
    private String lowRetryCounterStatus = rb.getString("status.lowRetryCounter");
    private String lastTryStatus = rb.getString("status.lastTry");
    private String blockedStatus = rb.getString("status.blocked");
    private String transportModeStatus = rb.getString("status.transport");
    private String notInitializedStatus = rb.getString("status.notInitialized");
    private JLabel txtMessage = new JLabel(this.pinPrompt);
    private JLabel txtStatus = new JLabel();
    private JPasswordField pwField;
    private JPanel pnlPin;

    public SmartCardHSMCHVDialog() {
        this.txtStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.pwField = new JPasswordField(this.pinLength);
        this.pnlPin = new JPanel();
        this.pnlPin.setLayout(new BoxLayout(this.pnlPin, 2));
        this.pnlPin.add(this.txtMessage);
        this.pnlPin.add(Box.createRigidArea(new Dimension(6, 0)));
        this.pnlPin.add(this.pwField);
    }

    public SmartCardHSMCHVDialog(SmartCardHSMCardService service) {
        this();
        this.service = service;
    }

    public void setPasswordStatus(CHVCardServiceWithControl.PasswordStatus status) {
        this.status = status;
    }

    @Override
    public String getCHV(int chvNumber) {
        JComponent[] input;
        String pw = null;
        int messageType = -1;
        int optionType = 2;
        Object[] options = this.service != null ? new String[]{rb.getString("ok"), rb.getString("cancel"), rb.getString("change")} : new String[]{rb.getString("ok"), rb.getString("cancel")};
        if (this.status == CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED) {
            this.txtStatus.setText(this.notVerifiedStatus);
            this.txtMessage.setText(this.pinPrompt);
            input = new JComponent[]{this.txtStatus, this.pnlPin};
        } else if (this.status == CHVCardServiceWithControl.PasswordStatus.RETRYCOUNTERLOW) {
            this.txtStatus.setText(this.lowRetryCounterStatus);
            this.txtMessage.setText(this.pinPrompt);
            input = new JComponent[]{this.txtStatus, this.pnlPin};
            messageType = 2;
        } else if (this.status == CHVCardServiceWithControl.PasswordStatus.LASTTRY) {
            this.txtStatus.setText(this.lastTryStatus);
            this.txtMessage.setText(this.pinPrompt);
            input = new JComponent[]{this.txtStatus, this.pnlPin};
            messageType = 2;
        } else if (this.status == CHVCardServiceWithControl.PasswordStatus.BLOCKED) {
            this.txtStatus.setText(this.blockedStatus);
            this.txtMessage.setText(this.blockedMessage);
            input = new JComponent[]{this.txtStatus, this.txtMessage};
            messageType = 0;
            optionType = -1;
            options = new String[]{rb.getString("ok")};
        } else if (this.status == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE) {
            this.txtStatus.setText(this.transportModeStatus);
            this.txtMessage.setText(this.transportModeMessage);
            input = new JComponent[]{this.txtStatus, this.txtMessage};
            messageType = 0;
            optionType = -1;
            options = this.service != null ? new String[]{rb.getString("ok"), rb.getString("change")} : new String[]{};
        } else if (this.status == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
            this.txtStatus.setText(this.notInitializedStatus);
            this.txtMessage.setText(this.notInitializedMessage);
            input = new JComponent[]{this.txtStatus, this.txtMessage};
            messageType = 0;
            optionType = -1;
            options = new String[]{rb.getString("ok")};
        } else {
            this.txtMessage.setText(this.pinPrompt);
            input = new JComponent[]{this.pnlPin};
        }
        JOptionPane pane = new JOptionPane(input, messageType, optionType, null, options, options[0]);
        JDialog dialog = pane.createDialog(this.title);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SmartCardHSMCHVDialog.this.pwField.requestFocusInWindow();
            }
        });
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        Object action = pane.getValue();
        if (action == rb.getString("ok")) {
            pw = this.pwField.getPassword().length == 0 ? null : new String(this.pwField.getPassword());
        } else if (action == rb.getString("change")) {
            try {
                if (this.service != null) {
                    this.service.changeReferenceData();
                }
                pw = null;
            }
            catch (CardServiceException e1) {
                e1.printStackTrace();
            }
            catch (CardTerminalException e1) {
                e1.printStackTrace();
            }
        }
        this.pwField.setText("");
        return pw;
    }
}

