/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.AuthenticatedRequest;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class CVCertificateRequestGenerator {
    private CertificationAuthorityReference car;
    private CertificateHolderReference chr;
    private ObjectIdentifier pubalgo = ECPublicKeyTLV.id_TA_ECDSA_SHA_256;
    private PublicKey pub;

    void setCertificationAuthorityReference(CertificationAuthorityReference car) {
        this.car = car;
    }

    void setPublicKey(PublicKey pub) {
        this.pub = pub;
    }

    void setPublicKey(PublicKey pub, ObjectIdentifier algo) {
        this.pub = pub;
        this.pubalgo = algo;
    }

    void setCertificateHolderReference(CertificateHolderReference chr) {
        this.chr = chr;
    }

    public CVCertificate generate(PrivateKey signerkey, String algo) throws GeneralSecurityException {
        ECPublicKeyTLV pt = new ECPublicKeyTLV(this.pubalgo, (ECPublicKey)this.pub, true);
        CertificateBody body = new CertificateBody(this.car, pt, this.chr);
        Signature signer = Signature.getInstance(algo);
        signer.initSign(signerkey);
        signer.update(body.getBytes());
        byte[] signature = signer.sign();
        if (signerkey instanceof ECPrivateKey) {
            int keysize = ((ECPrivateKey)signerkey).getParams().getCurve().getField().getFieldSize();
            keysize = keysize + 7 >> 3;
            signature = ECPublicKeyTLV.unwrapSignature(signature, keysize);
        }
        return new CVCertificate(body, new SignatureTLV(signature));
    }

    public CVCertificate generate(PrivateKey signerkey) throws GeneralSecurityException {
        return this.generate(signerkey, "SHA256withECDSA");
    }

    public AuthenticatedRequest authenticate(CVCertificate request, PrivateKey authenticationKey, String algo, CertificationAuthorityReference car) throws GeneralSecurityException {
        Signature signer = Signature.getInstance(algo);
        signer.initSign(authenticationKey);
        signer.update(request.getBytes());
        signer.update(car.getBytes());
        byte[] signature = signer.sign();
        if (authenticationKey instanceof ECPrivateKey) {
            int keysize = ((ECPrivateKey)authenticationKey).getParams().getCurve().getField().getFieldSize();
            keysize = keysize + 7 >> 3;
            signature = ECPublicKeyTLV.unwrapSignature(signature, keysize);
        }
        return new AuthenticatedRequest(request, car, new SignatureTLV(signature));
    }
}

