/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class ECPublicKeyTLV
extends PublicKeyTLV {
    public static final ObjectIdentifier id_TA_ECDSA_SHA_1 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 1});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_224 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 2});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_256 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 3});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_384 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 4});
    public static final ObjectIdentifier id_TA_ECDSA_SHA_512 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 2, 2, 5});
    static final Tag TAG_P = new Tag(1, -128, false);
    static final Tag TAG_A = new Tag(2, -128, false);
    static final Tag TAG_B = new Tag(3, -128, false);
    static final Tag TAG_G = new Tag(4, -128, false);
    static final Tag TAG_R = new Tag(5, -128, false);
    static final Tag TAG_Y = new Tag(6, -128, false);
    static final Tag TAG_F = new Tag(7, -128, false);
    static final String NAME_P = "Prime";
    static final String NAME_A = "First Coefficient";
    static final String NAME_B = "Second Coefficient";
    static final String NAME_G = "Base Point";
    static final String NAME_R = "Order of the Base Point";
    static final String NAME_Y = "Public Point";
    static final String NAME_F = "Cofactor";

    public static byte[] encodePoint(ECPoint point, int size) {
        byte[] encoded = new byte[(size << 1) + 1];
        encoded[0] = 4;
        PublicKeyTLV.toUnsignedByteArray(point.getAffineX(), encoded, 1, size);
        PublicKeyTLV.toUnsignedByteArray(point.getAffineY(), encoded, 1 + size, size);
        return encoded;
    }

    public static ECPoint decodePoint(byte[] point) {
        int size = point.length - 1 >> 1;
        BigInteger x = new BigInteger(1, point, 1, size);
        BigInteger y = new BigInteger(1, point, 1 + size, size);
        return new ECPoint(x, y);
    }

    public static byte[] wrapSignature(byte[] signature) {
        int length = signature.length / 2;
        byte[] ib = new byte[length];
        System.arraycopy(signature, 0, ib, 0, length);
        BigInteger r = new BigInteger(1, ib);
        System.arraycopy(signature, length, ib, 0, length);
        BigInteger s = new BigInteger(1, ib);
        Sequence sequence = new Sequence();
        sequence.add(new IntegerTLV(r));
        sequence.add(new IntegerTLV(s));
        return sequence.getBytes();
    }

    public static byte[] unwrapSignature(byte[] signature, int size) {
        TLV t;
        try {
            t = TLV.factory(signature);
        }
        catch (TLVEncodingException e) {
            throw new IllegalArgumentException("Signature is not a TLV object");
        }
        if (!(t instanceof Sequence)) {
            throw new IllegalArgumentException("Signature missing outer Sequence");
        }
        Sequence s = (Sequence)t;
        if (s.getChildCount() != 2) {
            throw new IllegalArgumentException("Signature must contain two elements");
        }
        if (!(s.getChildAt(0) instanceof IntegerTLV) || !(s.getChildAt(1) instanceof IntegerTLV)) {
            throw new IllegalArgumentException("Signature must contain two integer");
        }
        byte[] uwsig = new byte[size << 1];
        IntegerTLV i = (IntegerTLV)s.getChildAt(0);
        PublicKeyTLV.toUnsignedByteArray(i.getValue(), uwsig, 0, size);
        i = (IntegerTLV)s.getChildAt(1);
        PublicKeyTLV.toUnsignedByteArray(i.getValue(), uwsig, size, size);
        return uwsig;
    }

    public ECPublicKeyTLV(ObjectIdentifier oid, ECPublicKey pk, boolean withDomainParameter) {
        super(oid);
        PrimitiveTLV t;
        ECParameterSpec param = pk.getParams();
        EllipticCurve curve = param.getCurve();
        int keysize = curve.getField().getFieldSize();
        keysize = keysize + 7 >> 3;
        ECFieldFp field = (ECFieldFp)curve.getField();
        if (withDomainParameter) {
            t = new PrimitiveTLV(TAG_P, PublicKeyTLV.toUnsignedByteArray(field.getP(), keysize));
            t.setName(NAME_P);
            this.add(t);
            t = new PrimitiveTLV(TAG_A, PublicKeyTLV.toUnsignedByteArray(curve.getA(), keysize));
            t.setName(NAME_A);
            this.add(t);
            t = new PrimitiveTLV(TAG_B, PublicKeyTLV.toUnsignedByteArray(curve.getB(), keysize));
            t.setName(NAME_B);
            this.add(t);
            t = new PrimitiveTLV(TAG_G, ECPublicKeyTLV.encodePoint(param.getGenerator(), keysize));
            t.setName(NAME_G);
            this.add(t);
            t = new PrimitiveTLV(TAG_R, PublicKeyTLV.toUnsignedByteArray(param.getOrder(), keysize));
            t.setName(NAME_R);
            this.add(t);
        }
        t = new PrimitiveTLV(TAG_Y, ECPublicKeyTLV.encodePoint(pk.getW(), keysize));
        t.setName(NAME_Y);
        this.add(t);
        if (withDomainParameter) {
            t = new PrimitiveTLV(TAG_F, new byte[]{(byte)param.getCofactor()});
            t.setName(NAME_F);
            this.add(t);
        }
    }

    public ECPublicKeyTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        TLV t;
        int size = this.childs.size();
        if (size != 2 && size != 8) {
            throw new TLVEncodingException("Public Key must contain 2 or 8 elements");
        }
        int i = 0;
        if (this.hasDomainParameter()) {
            if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_P)) {
                throw new TLVEncodingException("Expected Prime in Public Key");
            }
            t.setName(NAME_P);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_A)) {
                throw new TLVEncodingException("Expected First Coefficient in Public Key");
            }
            t.setName(NAME_A);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_B)) {
                throw new TLVEncodingException("Expected Second Coefficient in Public Key");
            }
            t.setName(NAME_B);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_G)) {
                throw new TLVEncodingException("Expected Base Point in Public Key");
            }
            t.setName(NAME_G);
            t = (TLV)this.childs.get(++i);
            if (!t.getTag().equals(TAG_R)) {
                throw new TLVEncodingException("Expected Order of the Base Point in Public Key");
            }
            t.setName(NAME_R);
        }
        if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_Y)) {
            throw new TLVEncodingException("Expected Public Point in Public Key");
        }
        t.setName(NAME_Y);
        if (this.hasDomainParameter()) {
            if (!(t = (TLV)this.childs.get(++i)).getTag().equals(TAG_F)) {
                throw new TLVEncodingException("Expected Cofactor in Public Key");
            }
            t.setName(NAME_F);
        }
    }

    public boolean hasDomainParameter() {
        return this.childs.size() == 8;
    }

    public PublicKey getPublicKey(ECParameterSpec params, String providerName) {
        int i = 6;
        if (this.hasDomainParameter()) {
            ECFieldFp field = new ECFieldFp(new BigInteger(1, ((TLV)this.childs.get(1)).getValue()));
            EllipticCurve curve = new EllipticCurve(field, new BigInteger(1, ((TLV)this.childs.get(2)).getValue()), new BigInteger(1, ((TLV)this.childs.get(3)).getValue()));
            ECPoint g = ECPublicKeyTLV.decodePoint(((TLV)this.childs.get(4)).getValue());
            BigInteger r = new BigInteger(1, ((TLV)this.childs.get(5)).getValue());
            byte f = ((TLV)this.childs.get(7)).getValue()[0];
            params = new ECParameterSpec(curve, g, r, f);
        } else {
            if (params == null || !(params instanceof ECParameterSpec)) {
                throw new RuntimeException("EC public key does not have domain parameter");
            }
            i = 1;
        }
        ECPoint y = ECPublicKeyTLV.decodePoint(((TLV)this.childs.get(i)).getValue());
        ECPublicKeySpec spec = new ECPublicKeySpec(y, params);
        KeyFactory fact = null;
        PublicKey key = null;
        try {
            fact = providerName != null ? KeyFactory.getInstance("EC", providerName) : KeyFactory.getInstance("EC");
            key = fact.generatePublic(spec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating public key", e);
        }
        return key;
    }

    @Override
    public PublicKey getPublicKey(AlgorithmParameterSpec params) {
        return this.getPublicKey((ECParameterSpec)params, null);
    }
}

