/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac;

import de.cardcontact.opencard.eac.StandardizedDomainParameter;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipAuthentication {
    public static final ObjectIdentifier id_CA_ECDH_3DES_CBC_CBC = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 3, 2, 1});
    public static final ObjectIdentifier id_CA_ECDH_AES_CBC_CMAC_128 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 3, 2, 2});
    public static final ObjectIdentifier id_CA_ECDH_AES_CBC_CMAC_192 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 3, 2, 3});
    public static final ObjectIdentifier id_CA_ECDH_AES_CBC_CMAC_256 = new ObjectIdentifier(new int[]{0, 4, 0, 127, 0, 7, 2, 2, 3, 2, 4});
    final Logger logger = LoggerFactory.getLogger(ChipAuthentication.class);
    StandardizedDomainParameter domainParameter;
    ObjectIdentifier protocol;
    KeyPair caKeyPair;
    SecretKey kenc;
    SecretKey kmac;

    public ChipAuthentication(ObjectIdentifier protocol, StandardizedDomainParameter domainParameter) {
        this.protocol = protocol;
        this.domainParameter = domainParameter;
    }

    public void generateEphemeralCAKeyPair() {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("EC");
            keyGen.initialize(new ECGenParameterSpec(this.domainParameter.name()));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            this.logger.error("Can not obtain and initialize EC key generator", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.caKeyPair = keyGen.generateKeyPair();
    }

    public byte[] getCompressedPublicKey() {
        ECPublicKey puk = (ECPublicKey)this.caKeyPair.getPublic();
        int keysize = puk.getParams().getCurve().getField().getFieldSize();
        keysize = keysize + 7 >> 3;
        byte[] comp = new byte[keysize];
        PublicKeyTLV.toUnsignedByteArray(puk.getW().getAffineX(), comp, 0, keysize);
        return comp;
    }

    public byte[] getEncodedPublicKey() {
        ECPublicKey puk = (ECPublicKey)this.caKeyPair.getPublic();
        int keysize = puk.getParams().getCurve().getField().getFieldSize();
        keysize = keysize + 7 >> 3;
        return ECPublicKeyTLV.encodePoint(puk.getW(), keysize);
    }

    public byte[] getProtocol() {
        return this.protocol.getValue();
    }

    private SecretKey deriveKey(int alg, byte[] sharedSecret, int counter, byte[] nonce) {
        ByteBuffer bb = ByteBuffer.allocate(80);
        bb.put(sharedSecret);
        bb.put(nonce);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)counter);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(alg <= 2 ? "SHA1" : "SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        digest.update(bb.array(), 0, bb.position());
        byte[] md = digest.digest();
        SecretKey key = null;
        if (alg == 1) {
            byte[] keyBin = new byte[24];
            System.arraycopy(md, 0, keyBin, 0, 16);
            System.arraycopy(md, 0, keyBin, 16, 8);
            DESedeKeySpec desedeKeySpec = null;
            try {
                desedeKeySpec = new DESedeKeySpec(keyBin);
            }
            catch (InvalidKeyException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            SecretKeyFactory skf = null;
            try {
                skf = SecretKeyFactory.getInstance("DESede");
                key = skf.generateSecret(desedeKeySpec);
            }
            catch (GeneralSecurityException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        int keylen = 8 * alg;
        byte[] keyBin = new byte[keylen];
        System.arraycopy(md, 0, keyBin, 0, keylen);
        key = new SecretKeySpec(keyBin, "AES");
        Arrays.fill(keyBin, (byte)0);
        Arrays.fill(md, (byte)0);
        return key;
    }

    public void performKeyAgreement(PublicKey peerKey, byte[] nonce) {
        byte[] sharedSecret = null;
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.caKeyPair.getPrivate());
            ka.doPhase(peerKey, true);
            sharedSecret = ka.generateSecret();
        }
        catch (GeneralSecurityException e) {
            this.logger.error("Can not agree key", (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] oidv = this.protocol.getValue();
        byte alg = oidv[oidv.length - 1];
        this.kenc = this.deriveKey(alg, sharedSecret, 1, nonce);
        this.kmac = this.deriveKey(alg, sharedSecret, 2, nonce);
        Arrays.fill(sharedSecret, (byte)0);
    }

    public boolean verifyAuthenticationToken(byte[] authToken) {
        byte[] at = null;
        ECPublicKeyTLV pub = new ECPublicKeyTLV(this.protocol, (ECPublicKey)this.caKeyPair.getPublic(), false);
        try {
            Mac mac = ((SecretKeySpec)this.kmac).getAlgorithm() == "AES" ? Mac.getInstance("AESCMAC") : Mac.getInstance("ISO9797ALG3Mac");
            mac.init(this.kmac);
            mac.update(pub.getBytes());
            at = mac.doFinal();
            if (at.length > 8) {
                byte[] stripped = new byte[8];
                System.arraycopy(at, 0, stripped, 0, 8);
                at = stripped;
            }
        }
        catch (GeneralSecurityException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return Arrays.equals(at, authToken);
    }
}

