/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.util.Arrays;

public class CertificateBody
extends ConstructedTLV {
    static final Tag TAG = new Tag(78, 64, true);
    static final String NAME = "Certificate Body";
    static final Tag CPI_TAG = new Tag(2, 64, false);
    static final String CPI_NAME = "Certificate Profile Indicator";
    static final byte[] CPI_VALUE = new byte[]{0};

    public CertificateBody(CertificationAuthorityReference car, PublicKeyTLV pub, CertificateHolderReference chr, CertificateHolderAuthorizationTemplate chat, CertificateEffectiveDate notBefore, CertificateExpirationDate notAfter) {
        super(TAG);
        this.setName(NAME);
        PrimitiveTLV t = new PrimitiveTLV(CPI_TAG, CPI_VALUE);
        t.setName(CPI_NAME);
        this.add(t);
        this.add(car);
        this.add(pub);
        this.add(chr);
        this.add(chat);
        this.add(notBefore);
        this.add(notAfter);
    }

    public CertificateBody(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certificate Body with wrong tag " + tlv.getTag());
        }
        this.setName(NAME);
        int i = 0;
        TLV t = (TLV)this.childs.get(i);
        if (!t.getTag().equals(CPI_TAG)) {
            throw new TLVEncodingException("Certificate Profile Indicator with wrong tag " + t.getTag());
        }
        if (Arrays.compare(CPI_VALUE, t.getValue()) != 0) {
            throw new TLVEncodingException("Certificate Profile Indicator unsupported version");
        }
        t.setName(CPI_NAME);
        this.childs.set(++i, new CertificationAuthorityReference((TLV)this.childs.get(i)));
        this.childs.set(++i, PublicKeyTLV.newPublicKey((TLV)this.childs.get(i)));
        this.childs.set(++i, new CertificateHolderReference((TLV)this.childs.get(i)));
        this.childs.set(++i, new CertificateHolderAuthorizationTemplate((TLV)this.childs.get(i)));
        this.childs.set(++i, new CertificateEffectiveDate((TLV)this.childs.get(i)));
        this.childs.set(++i, new CertificateExpirationDate((TLV)this.childs.get(i)));
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        return (CertificationAuthorityReference)this.childs.get(1);
    }

    public PublicKeyTLV getPublicKeyTLV() {
        return (PublicKeyTLV)this.childs.get(2);
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return (CertificateHolderReference)this.childs.get(3);
    }

    public CertificateHolderAuthorizationTemplate getCertificateHolderAuthorizationTemplate() {
        return (CertificateHolderAuthorizationTemplate)this.childs.get(4);
    }

    public CertificateEffectiveDate getCertificateEffectiveDate() {
        return (CertificateEffectiveDate)this.childs.get(5);
    }

    public CertificateExpirationDate getCertificateExpirationDate() {
        return (CertificateExpirationDate)this.childs.get(6);
    }
}

