/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class CVCertificateGenerator {
    private CertificationAuthorityReference car;
    private CertificateHolderReference chr;
    private ObjectIdentifier pubalgo = ECPublicKeyTLV.ID_TA_ECDSA_SHA_256;
    private PublicKey pub;
    private CertificateHolderAuthorizationTemplate chat;
    private CertificateEffectiveDate notBefore;
    private CertificateExpirationDate notAfter;
    private boolean withDomainParameter = true;

    void withDomainParameter(boolean withDomainParameter) {
        this.withDomainParameter = withDomainParameter;
    }

    void setCertificationAuthorityReference(CertificationAuthorityReference car) {
        this.car = car;
    }

    void setPublicKey(PublicKey pub) {
        this.pub = pub;
    }

    void setPublicKey(PublicKey pub, ObjectIdentifier algo) {
        this.pub = pub;
        this.pubalgo = algo;
    }

    void setCertificateHolderReference(CertificateHolderReference chr) {
        this.chr = chr;
    }

    void setCertificateHolderAuthorizationTemplate(CertificateHolderAuthorizationTemplate chat) {
        this.chat = chat;
    }

    void setCertificateEffectiveDate(CertificateEffectiveDate notBefore) {
        this.notBefore = notBefore;
    }

    void setCertificateExpirationDate(CertificateExpirationDate notAfter) {
        this.notAfter = notAfter;
    }

    public CVCertificate generate(PrivateKey signerkey, String algo) throws GeneralSecurityException {
        ECPublicKeyTLV pt = new ECPublicKeyTLV(this.pubalgo, (ECPublicKey)this.pub, this.withDomainParameter);
        CertificateBody body = new CertificateBody(this.car, pt, this.chr, this.chat, this.notBefore, this.notAfter);
        Signature signer = Signature.getInstance(algo);
        signer.initSign(signerkey);
        signer.update(body.getBytes());
        byte[] signature = signer.sign();
        if (signerkey instanceof ECPrivateKey) {
            int keysize = ((ECPrivateKey)signerkey).getParams().getCurve().getField().getFieldSize();
            keysize = keysize + 7 >> 3;
            signature = ECPublicKeyTLV.unwrapSignature(signature, keysize);
        }
        return new CVCertificate(body, new SignatureTLV(signature));
    }

    public CVCertificate generate(PrivateKey signerkey) throws GeneralSecurityException {
        return this.generate(signerkey, "SHA256withECDSA");
    }
}

